
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The ItinReshop transaction set passes new shopping requests to an airline to replace existing specified order or order items in an Order or for new shopping requests to add to an existing Order. 

 Airline responds with product offers within the context of the existing Order. This transaction may also be used to re-price an order (e.g. prior to payment). 

 There is no change to the Order or Order Items. Typically this transaction will be followed by an OrderChangeRQ or OrderCancelRQ or AirDocRefundRQ or AirDocExchangeRQ transaction, to commit the re-shop offer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinReshopRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element ref="ns:ItinReshopParameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:choice>
 *             &lt;xs:element name="RepriceOnly">
 *               &lt;!-- Reference to inner class RepriceOnly -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="Reshop">
 *               &lt;xs:complexType>
 *                 &lt;xs:sequence>
 *                   &lt;xs:element name="Actions" maxOccurs="unbounded">
 *                     &lt;!-- Reference to inner class Actions -->
 *                   &lt;/xs:element>
 *                 &lt;/xs:sequence>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *           &lt;/xs:choice>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ItinReshopRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private ItinReshopParamsType itinReshopParameters;
    private int querySelect = -1;
    private static final int REPRICE_ONLY_CHOICE = 0;
    private static final int QUERY_RESHOP_CHOICE = 1;
    private RepriceOnly repriceOnly;
    private List<Actions> queryReshopList = new ArrayList<Actions>();
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'ItinReshopParameters' element value.
     * 
     * @return value
     */
    public ItinReshopParamsType getItinReshopParameters() {
        return itinReshopParameters;
    }

    /** 
     * Set the 'ItinReshopParameters' element value.
     * 
     * @param itinReshopParameters
     */
    public void setItinReshopParameters(
            ItinReshopParamsType itinReshopParameters) {
        this.itinReshopParameters = itinReshopParameters;
    }

    private void setQuerySelect(int choice) {
        if (querySelect == -1) {
            querySelect = choice;
        } else if (querySelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearQuerySelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearQuerySelect() {
        querySelect = -1;
    }

    /** 
     * Check if RepriceOnly is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRepriceOnly() {
        return querySelect == REPRICE_ONLY_CHOICE;
    }

    /** 
     * Get the 'RepriceOnly' element value. itinerary Reshop Query.
     * 
     * @return value
     */
    public RepriceOnly getRepriceOnly() {
        return repriceOnly;
    }

    /** 
     * Set the 'RepriceOnly' element value. itinerary Reshop Query.
     * 
     * @param repriceOnly
     */
    public void setRepriceOnly(RepriceOnly repriceOnly) {
        setQuerySelect(REPRICE_ONLY_CHOICE);
        this.repriceOnly = repriceOnly;
    }

    /** 
     * Check if QueryReshopList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQueryReshop() {
        return querySelect == QUERY_RESHOP_CHOICE;
    }

    /** 
     * Get the list of 'Actions' element items. Reshop Parameters. Reshop is performed with no change to the order or the order items.
     * 
     * @return list
     */
    public List<Actions> getQueryReshopList() {
        return queryReshopList;
    }

    /** 
     * Set the list of 'Actions' element items. Reshop Parameters. Reshop is performed with no change to the order or the order items.
     * 
     * @param list
     */
    public void setQueryReshopList(List<Actions> list) {
        setQuerySelect(QUERY_RESHOP_CHOICE);
        queryReshopList = list;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Itinerary Repricing.

    Notes:
    1. Full itinerary (all order items) and/ or specified order item(s) repricing is supported.
    2. Repricing is performed with no change to the order or the order items.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RepriceOnly">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OrderItemCoreType" name="OrderItems" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="RepriceAllInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RepriceOnly implements Serializable
    {
        private OrderItemCoreType orderItems;
        private Boolean repriceAllInd;

        /** 
         * Get the 'OrderItems' element value. Specified Order Items to be repriced.
         * 
         * @return value
         */
        public OrderItemCoreType getOrderItems() {
            return orderItems;
        }

        /** 
         * Set the 'OrderItems' element value. Specified Order Items to be repriced.
         * 
         * @param orderItems
         */
        public void setOrderItems(OrderItemCoreType orderItems) {
            this.orderItems = orderItems;
        }

        /** 
         * Get the 'RepriceAllInd' attribute value. When TRUE, repricing for all order items is requested.
         * 
         * @return value
         */
        public Boolean getRepriceAllInd() {
            return repriceAllInd;
        }

        /** 
         * Set the 'RepriceAllInd' attribute value. When TRUE, repricing for all order items is requested.
         * 
         * @param repriceAllInd
         */
        public void setRepriceAllInd(Boolean repriceAllInd) {
            this.repriceAllInd = repriceAllInd;
        }
    }
    /** 
     * Reshop Actions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Actions" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ActionType">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:OrderID" minOccurs="0"/>
     *       &lt;xs:element name="OfferItemSets" minOccurs="0">
     *         &lt;!-- Reference to inner class OfferItemSets -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:OrderItemCoreType" name="OrderItems" minOccurs="0"/>
     *       &lt;xs:element name="TicketDocuments" minOccurs="0">
     *         &lt;!-- Reference to inner class TicketDocuments -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Passengers" minOccurs="0">
     *         &lt;!-- Reference to inner class Passengers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Qualifiers" minOccurs="0">
     *         &lt;!-- Reference to inner class Qualifiers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Preferences" minOccurs="0">
     *         &lt;!-- Reference to inner class Preferences -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Actions implements Serializable
    {
        private String actionTypeString;
        private String actionTypeContext;
        private BookingReferences bookingReferences;
        private OrderIDType orderID;
        private OfferItemSets offerItemSets;
        private OrderItemCoreType orderItems;
        private TicketDocuments ticketDocuments;
        private Passengers passengers;
        private Qualifiers qualifiers;
        private Preferences preferences;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getActionTypeString() {
            return actionTypeString;
        }

        /** 
         * Set the extension value.
         * 
         * @param actionTypeString
         */
        public void setActionTypeString(String actionTypeString) {
            this.actionTypeString = actionTypeString;
        }

        /** 
         * Get the 'Context' attribute value. Action Type Context.
         * 
         * @return value
         */
        public String getActionTypeContext() {
            return actionTypeContext;
        }

        /** 
         * Set the 'Context' attribute value. Action Type Context.
         * 
         * @param actionTypeContext
         */
        public void setActionTypeContext(String actionTypeContext) {
            this.actionTypeContext = actionTypeContext;
        }

        /** 
         * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
         * 
         * @return value
         */
        public BookingReferences getBookingReferences() {
            return bookingReferences;
        }

        /** 
         * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
         * 
         * @param bookingReferences
         */
        public void setBookingReferences(BookingReferences bookingReferences) {
            this.bookingReferences = bookingReferences;
        }

        /** 
         * Get the 'OrderID' element value.
         * 
         * @return value
         */
        public OrderIDType getOrderID() {
            return orderID;
        }

        /** 
         * Set the 'OrderID' element value.
         * 
         * @param orderID
         */
        public void setOrderID(OrderIDType orderID) {
            this.orderID = orderID;
        }

        /** 
         * Get the 'OfferItemSets' element value.
         * 
         * @return value
         */
        public OfferItemSets getOfferItemSets() {
            return offerItemSets;
        }

        /** 
         * Set the 'OfferItemSets' element value.
         * 
         * @param offerItemSets
         */
        public void setOfferItemSets(OfferItemSets offerItemSets) {
            this.offerItemSets = offerItemSets;
        }

        /** 
         * Get the 'OrderItems' element value. Order Item Detail.
         * 
         * @return value
         */
        public OrderItemCoreType getOrderItems() {
            return orderItems;
        }

        /** 
         * Set the 'OrderItems' element value. Order Item Detail.
         * 
         * @param orderItems
         */
        public void setOrderItems(OrderItemCoreType orderItems) {
            this.orderItems = orderItems;
        }

        /** 
         * Get the 'TicketDocuments' element value.
         * 
         * @return value
         */
        public TicketDocuments getTicketDocuments() {
            return ticketDocuments;
        }

        /** 
         * Set the 'TicketDocuments' element value.
         * 
         * @param ticketDocuments
         */
        public void setTicketDocuments(TicketDocuments ticketDocuments) {
            this.ticketDocuments = ticketDocuments;
        }

        /** 
         * Get the 'Passengers' element value.
         * 
         * @return value
         */
        public Passengers getPassengers() {
            return passengers;
        }

        /** 
         * Set the 'Passengers' element value.
         * 
         * @param passengers
         */
        public void setPassengers(Passengers passengers) {
            this.passengers = passengers;
        }

        /** 
         * Get the 'Qualifiers' element value.
         * 
         * @return value
         */
        public Qualifiers getQualifiers() {
            return qualifiers;
        }

        /** 
         * Set the 'Qualifiers' element value.
         * 
         * @param qualifiers
         */
        public void setQualifiers(Qualifiers qualifiers) {
            this.qualifiers = qualifiers;
        }

        /** 
         * Get the 'Preferences' element value.
         * 
         * @return value
         */
        public Preferences getPreferences() {
            return preferences;
        }

        /** 
         * Set the 'Preferences' element value.
         * 
         * @param preferences
         */
        public void setPreferences(Preferences preferences) {
            this.preferences = preferences;
        }
        /** 
         * One or more Offer Item Sets that each may contain one or more Offer Items that comprise one Order Item.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemSets" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="OfferItemSet" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class OfferItemSet -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OfferItemSets implements Serializable
        {
            private List<OfferItemSet> offerItemSetList = new ArrayList<OfferItemSet>();

            /** 
             * Get the list of 'OfferItemSet' element items.
             * 
             * @return list
             */
            public List<OfferItemSet> getOfferItemSetList() {
                return offerItemSetList;
            }

            /** 
             * Set the list of 'OfferItemSet' element items.
             * 
             * @param list
             */
            public void setOfferItemSetList(List<OfferItemSet> list) {
                offerItemSetList = list;
            }
            /** 
             * One or more Offer Item Sets that each may contain one or more Offer Items that comprise one Order Item.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemSet" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
             *         &lt;xs:sequence>
             *           &lt;xs:element type="ns:OrderOfferItemType" name="OfferItem" maxOccurs="unbounded"/>
             *         &lt;/xs:sequence>
             *         &lt;xs:attribute type="xs:string" use="optional" name="SetItemQuantity"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OfferItemSet extends KeyWithMetaObjectBaseType
                implements Serializable
            {
                private List<OrderOfferItemType> offerItemList = new ArrayList<OrderOfferItemType>();
                private String setItemQuantity;

                /** 
                 * Get the list of 'OfferItem' element items. Offer Item(s) that comprise the Order Item.
                 * 
                 * @return list
                 */
                public List<OrderOfferItemType> getOfferItemList() {
                    return offerItemList;
                }

                /** 
                 * Set the list of 'OfferItem' element items. Offer Item(s) that comprise the Order Item.
                 * 
                 * @param list
                 */
                public void setOfferItemList(List<OrderOfferItemType> list) {
                    offerItemList = list;
                }

                /** 
                 * Get the 'SetItemQuantity' attribute value. Quantity of Offer Items included in one Order Item.
                 * 
                 * @return value
                 */
                public String getSetItemQuantity() {
                    return setItemQuantity;
                }

                /** 
                 * Set the 'SetItemQuantity' attribute value. Quantity of Offer Items included in one Order Item.
                 * 
                 * @param setItemQuantity
                 */
                public void setSetItemQuantity(String setItemQuantity) {
                    this.setItemQuantity = setItemQuantity;
                }
            }
        }
        /** 
         * Ticket documents information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocuments" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:TicketDocumentType" name="TicketDocument" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketDocuments implements Serializable
        {
            private List<TicketDocumentType> ticketDocumentList = new ArrayList<TicketDocumentType>();

            /** 
             * Get the list of 'TicketDocument' element items. The ticket documents that .
             * 
             * @return list
             */
            public List<TicketDocumentType> getTicketDocumentList() {
                return ticketDocumentList;
            }

            /** 
             * Set the list of 'TicketDocument' element items. The ticket documents that .
             * 
             * @param list
             */
            public void setTicketDocumentList(List<TicketDocumentType> list) {
                ticketDocumentList = list;
            }
        }
        /** 
         * Passenger and Group information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:Passenger" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:GroupType" name="Group" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Passengers implements Serializable
        {
            private List<Passenger> passengerList = new ArrayList<Passenger>();
            private GroupType group;

            /** 
             * Get the list of 'Passenger' element items.
             * 
             * @return list
             */
            public List<Passenger> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items.
             * 
             * @param list
             */
            public void setPassengerList(List<Passenger> list) {
                passengerList = list;
            }

            /** 
             * Get the 'Group' element value. Group Information.
             * 
             * @return value
             */
            public GroupType getGroup() {
                return group;
            }

            /** 
             * Set the 'Group' element value. Group Information.
             * 
             * @param group
             */
            public void setGroup(GroupType group) {
                this.group = group;
            }
        }
        /** 
         * Shopper requested qualifiers to influence search results (e.g. offers and/ or offer pricing), including Payment Card, Programs, Promotions, Social Media, Special Fares and Special Needs.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifiers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Qualifier" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Qualifier -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Qualifiers implements Serializable
        {
            private List<Qualifier> qualifierList = new ArrayList<Qualifier>();

            /** 
             * Get the list of 'Qualifier' element items.
             * 
             * @return list
             */
            public List<Qualifier> getQualifierList() {
                return qualifierList;
            }

            /** 
             * Set the list of 'Qualifier' element items.
             * 
             * @param list
             */
            public void setQualifierList(List<Qualifier> list) {
                qualifierList = list;
            }
            /** 
             * Qualifier choices.

            Notes: 
            1. These qualifiers may be specified for (e.g. apply to) both Attribute and Affinity queries.
            2. These capabilities may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifier" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element ref="ns:BaggagePricingQualifier"/>
             *       &lt;xs:element ref="ns:ExistingOrderQualifier"/>
             *       &lt;xs:element ref="ns:PaymentCardQualifiers"/>
             *       &lt;xs:element ref="ns:ProgramQualifiers"/>
             *       &lt;xs:element ref="ns:PromotionQualifiers"/>
             *       &lt;xs:element ref="ns:SeatQualifier"/>
             *       &lt;xs:element ref="ns:ServiceQualifier"/>
             *       &lt;xs:element ref="ns:SocialMediaQualifiers"/>
             *       &lt;xs:element ref="ns:SpecialFareQualifiers"/>
             *       &lt;xs:element ref="ns:SpecialNeedQualifiers"/>
             *       &lt;xs:element ref="ns:TripPurposeQualifier"/>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Qualifier implements Serializable
            {
                private int qualifierListSelect = -1;
                private static final int BAGGAGE_PRICING_QUALIFIER_CHOICE = 0;
                private static final int EXISTING_ORDER_QUALIFIER_CHOICE = 1;
                private static final int PAYMENT_CARD_QUALIFIERS_CHOICE = 2;
                private static final int PROGRAM_QUALIFIERS_CHOICE = 3;
                private static final int PROMOTION_QUALIFIERS_CHOICE = 4;
                private static final int SEAT_QUALIFIER_CHOICE = 5;
                private static final int SERVICE_QUALIFIER_CHOICE = 6;
                private static final int SOCIAL_MEDIA_QUALIFIERS_CHOICE = 7;
                private static final int SPECIAL_FARE_QUALIFIERS_CHOICE = 8;
                private static final int SPECIAL_NEED_QUALIFIERS_CHOICE = 9;
                private static final int TRIP_PURPOSE_QUALIFIER_CHOICE = 10;
                private BaggagePricingQualifierType baggagePricingQualifier;
                private ExistingOrderQualifier existingOrderQualifier;
                private CardQualifierType paymentCardQualifiers;
                private ProgramQualifiers programQualifiers;
                private PromotionQualifiers promotionQualifiers;
                private SeatQualifier seatQualifier;
                private ServiceQualifierPriceType serviceQualifier;
                private SocialMediaQualifierType socialMediaQualifiers;
                private FareQualifierType specialFareQualifiers;
                private SpecialType specialNeedQualifiers;
                private TripPurposeQualifier tripPurposeQualifier;

                private void setQualifierListSelect(int choice) {
                    if (qualifierListSelect == -1) {
                        qualifierListSelect = choice;
                    } else if (qualifierListSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearQualifierListSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearQualifierListSelect() {
                    qualifierListSelect = -1;
                }

                /** 
                 * Check if BaggagePricingQualifier is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifBaggagePricingQualifier() {
                    return qualifierListSelect == BAGGAGE_PRICING_QUALIFIER_CHOICE;
                }

                /** 
                 * Get the 'BaggagePricingQualifier' element value.
                 * 
                 * @return value
                 */
                public BaggagePricingQualifierType getBaggagePricingQualifier() {
                    return baggagePricingQualifier;
                }

                /** 
                 * Set the 'BaggagePricingQualifier' element value.
                 * 
                 * @param baggagePricingQualifier
                 */
                public void setBaggagePricingQualifier(
                        BaggagePricingQualifierType baggagePricingQualifier) {
                    setQualifierListSelect(BAGGAGE_PRICING_QUALIFIER_CHOICE);
                    this.baggagePricingQualifier = baggagePricingQualifier;
                }

                /** 
                 * Check if ExistingOrderQualifier is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifExistingOrderQualifier() {
                    return qualifierListSelect == EXISTING_ORDER_QUALIFIER_CHOICE;
                }

                /** 
                 * Get the 'ExistingOrderQualifier' element value.
                 * 
                 * @return value
                 */
                public ExistingOrderQualifier getExistingOrderQualifier() {
                    return existingOrderQualifier;
                }

                /** 
                 * Set the 'ExistingOrderQualifier' element value.
                 * 
                 * @param existingOrderQualifier
                 */
                public void setExistingOrderQualifier(
                        ExistingOrderQualifier existingOrderQualifier) {
                    setQualifierListSelect(EXISTING_ORDER_QUALIFIER_CHOICE);
                    this.existingOrderQualifier = existingOrderQualifier;
                }

                /** 
                 * Check if PaymentCardQualifiers is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPaymentCardQualifiers() {
                    return qualifierListSelect == PAYMENT_CARD_QUALIFIERS_CHOICE;
                }

                /** 
                 * Get the 'PaymentCardQualifiers' element value.
                 * 
                 * @return value
                 */
                public CardQualifierType getPaymentCardQualifiers() {
                    return paymentCardQualifiers;
                }

                /** 
                 * Set the 'PaymentCardQualifiers' element value.
                 * 
                 * @param paymentCardQualifiers
                 */
                public void setPaymentCardQualifiers(
                        CardQualifierType paymentCardQualifiers) {
                    setQualifierListSelect(PAYMENT_CARD_QUALIFIERS_CHOICE);
                    this.paymentCardQualifiers = paymentCardQualifiers;
                }

                /** 
                 * Check if ProgramQualifiers is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifProgramQualifiers() {
                    return qualifierListSelect == PROGRAM_QUALIFIERS_CHOICE;
                }

                /** 
                 * Get the 'ProgramQualifiers' element value.
                 * 
                 * @return value
                 */
                public ProgramQualifiers getProgramQualifiers() {
                    return programQualifiers;
                }

                /** 
                 * Set the 'ProgramQualifiers' element value.
                 * 
                 * @param programQualifiers
                 */
                public void setProgramQualifiers(
                        ProgramQualifiers programQualifiers) {
                    setQualifierListSelect(PROGRAM_QUALIFIERS_CHOICE);
                    this.programQualifiers = programQualifiers;
                }

                /** 
                 * Check if PromotionQualifiers is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPromotionQualifiers() {
                    return qualifierListSelect == PROMOTION_QUALIFIERS_CHOICE;
                }

                /** 
                 * Get the 'PromotionQualifiers' element value.
                 * 
                 * @return value
                 */
                public PromotionQualifiers getPromotionQualifiers() {
                    return promotionQualifiers;
                }

                /** 
                 * Set the 'PromotionQualifiers' element value.
                 * 
                 * @param promotionQualifiers
                 */
                public void setPromotionQualifiers(
                        PromotionQualifiers promotionQualifiers) {
                    setQualifierListSelect(PROMOTION_QUALIFIERS_CHOICE);
                    this.promotionQualifiers = promotionQualifiers;
                }

                /** 
                 * Check if SeatQualifier is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSeatQualifier() {
                    return qualifierListSelect == SEAT_QUALIFIER_CHOICE;
                }

                /** 
                 * Get the 'SeatQualifier' element value.
                 * 
                 * @return value
                 */
                public SeatQualifier getSeatQualifier() {
                    return seatQualifier;
                }

                /** 
                 * Set the 'SeatQualifier' element value.
                 * 
                 * @param seatQualifier
                 */
                public void setSeatQualifier(SeatQualifier seatQualifier) {
                    setQualifierListSelect(SEAT_QUALIFIER_CHOICE);
                    this.seatQualifier = seatQualifier;
                }

                /** 
                 * Check if ServiceQualifier is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifServiceQualifier() {
                    return qualifierListSelect == SERVICE_QUALIFIER_CHOICE;
                }

                /** 
                 * Get the 'ServiceQualifier' element value.
                 * 
                 * @return value
                 */
                public ServiceQualifierPriceType getServiceQualifier() {
                    return serviceQualifier;
                }

                /** 
                 * Set the 'ServiceQualifier' element value.
                 * 
                 * @param serviceQualifier
                 */
                public void setServiceQualifier(
                        ServiceQualifierPriceType serviceQualifier) {
                    setQualifierListSelect(SERVICE_QUALIFIER_CHOICE);
                    this.serviceQualifier = serviceQualifier;
                }

                /** 
                 * Check if SocialMediaQualifiers is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSocialMediaQualifiers() {
                    return qualifierListSelect == SOCIAL_MEDIA_QUALIFIERS_CHOICE;
                }

                /** 
                 * Get the 'SocialMediaQualifiers' element value.
                 * 
                 * @return value
                 */
                public SocialMediaQualifierType getSocialMediaQualifiers() {
                    return socialMediaQualifiers;
                }

                /** 
                 * Set the 'SocialMediaQualifiers' element value.
                 * 
                 * @param socialMediaQualifiers
                 */
                public void setSocialMediaQualifiers(
                        SocialMediaQualifierType socialMediaQualifiers) {
                    setQualifierListSelect(SOCIAL_MEDIA_QUALIFIERS_CHOICE);
                    this.socialMediaQualifiers = socialMediaQualifiers;
                }

                /** 
                 * Check if SpecialFareQualifiers is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSpecialFareQualifiers() {
                    return qualifierListSelect == SPECIAL_FARE_QUALIFIERS_CHOICE;
                }

                /** 
                 * Get the 'SpecialFareQualifiers' element value.
                 * 
                 * @return value
                 */
                public FareQualifierType getSpecialFareQualifiers() {
                    return specialFareQualifiers;
                }

                /** 
                 * Set the 'SpecialFareQualifiers' element value.
                 * 
                 * @param specialFareQualifiers
                 */
                public void setSpecialFareQualifiers(
                        FareQualifierType specialFareQualifiers) {
                    setQualifierListSelect(SPECIAL_FARE_QUALIFIERS_CHOICE);
                    this.specialFareQualifiers = specialFareQualifiers;
                }

                /** 
                 * Check if SpecialNeedQualifiers is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSpecialNeedQualifiers() {
                    return qualifierListSelect == SPECIAL_NEED_QUALIFIERS_CHOICE;
                }

                /** 
                 * Get the 'SpecialNeedQualifiers' element value.
                 * 
                 * @return value
                 */
                public SpecialType getSpecialNeedQualifiers() {
                    return specialNeedQualifiers;
                }

                /** 
                 * Set the 'SpecialNeedQualifiers' element value.
                 * 
                 * @param specialNeedQualifiers
                 */
                public void setSpecialNeedQualifiers(
                        SpecialType specialNeedQualifiers) {
                    setQualifierListSelect(SPECIAL_NEED_QUALIFIERS_CHOICE);
                    this.specialNeedQualifiers = specialNeedQualifiers;
                }

                /** 
                 * Check if TripPurposeQualifier is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifTripPurposeQualifier() {
                    return qualifierListSelect == TRIP_PURPOSE_QUALIFIER_CHOICE;
                }

                /** 
                 * Get the 'TripPurposeQualifier' element value.
                 * 
                 * @return value
                 */
                public TripPurposeQualifier getTripPurposeQualifier() {
                    return tripPurposeQualifier;
                }

                /** 
                 * Set the 'TripPurposeQualifier' element value.
                 * 
                 * @param tripPurposeQualifier
                 */
                public void setTripPurposeQualifier(
                        TripPurposeQualifier tripPurposeQualifier) {
                    setQualifierListSelect(TRIP_PURPOSE_QUALIFIER_CHOICE);
                    this.tripPurposeQualifier = tripPurposeQualifier;
                }
            }
        }
        /** 
         * Shopping Preference(s), including Airline Supplier, Alliance Program, Fare, Flight and Transfer/ Connection Points.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preferences" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Preference" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Preference -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Preferences implements Serializable
        {
            private List<Preference> preferenceList = new ArrayList<Preference>();

            /** 
             * Get the list of 'Preference' element items.
             * 
             * @return list
             */
            public List<Preference> getPreferenceList() {
                return preferenceList;
            }

            /** 
             * Set the list of 'Preference' element items.
             * 
             * @param list
             */
            public void setPreferenceList(List<Preference> list) {
                preferenceList = list;
            }
            /** 
             * Preference choices.

            Notes: 
            1. These preferences may be specified for (e.g. apply to) both Attribute and Affinity queries.
            2. These capabilities may not be supported by all EDIST-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preference" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element ref="ns:AirlinePreferences"/>
             *       &lt;xs:element ref="ns:AlliancePreferences"/>
             *       &lt;xs:element ref="ns:FlightPreferences"/>
             *       &lt;xs:element ref="ns:FarePreferences"/>
             *       &lt;xs:element ref="ns:PricingMethodPreference"/>
             *       &lt;xs:element ref="ns:SegMaxTimePreferences"/>
             *       &lt;xs:element ref="ns:ServicePricingOnlyPreference"/>
             *       &lt;xs:element ref="ns:TransferPreferences"/>
             *       &lt;xs:element ref="ns:CabinPreferences"/>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Preference implements Serializable
            {
                private int preferenceListSelect = -1;
                private static final int AIRLINE_PREFERENCES_CHOICE = 0;
                private static final int ALLIANCE_PREFERENCES_CHOICE = 1;
                private static final int FLIGHT_PREFERENCES_CHOICE = 2;
                private static final int FARE_PREFERENCES_CHOICE = 3;
                private static final int PRICING_METHOD_PREFERENCE_CHOICE = 4;
                private static final int SEG_MAX_TIME_PREFERENCES_CHOICE = 5;
                private static final int SERVICE_PRICING_ONLY_PREFERENCE_CHOICE = 6;
                private static final int TRANSFER_PREFERENCES_CHOICE = 7;
                private static final int CABIN_PREFERENCES_CHOICE = 8;
                private AirlinePreferencesType airlinePreferences;
                private AlliancePreferencesType alliancePreferences;
                private FlightPreferencesType flightPreferences;
                private FarePreferencesType farePreferences;
                private BestPricingPreferencesType pricingMethodPreference;
                private FltSegmentMaxTimePreferencesType segMaxTimePreferences;
                private ServicePricingOnlyPreference servicePricingOnlyPreference;
                private TransferPreferencesType transferPreferences;
                private CabinPreferencesType cabinPreferences;

                private void setPreferenceListSelect(int choice) {
                    if (preferenceListSelect == -1) {
                        preferenceListSelect = choice;
                    } else if (preferenceListSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearPreferenceListSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearPreferenceListSelect() {
                    preferenceListSelect = -1;
                }

                /** 
                 * Check if AirlinePreferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAirlinePreferences() {
                    return preferenceListSelect == AIRLINE_PREFERENCES_CHOICE;
                }

                /** 
                 * Get the 'AirlinePreferences' element value.
                 * 
                 * @return value
                 */
                public AirlinePreferencesType getAirlinePreferences() {
                    return airlinePreferences;
                }

                /** 
                 * Set the 'AirlinePreferences' element value.
                 * 
                 * @param airlinePreferences
                 */
                public void setAirlinePreferences(
                        AirlinePreferencesType airlinePreferences) {
                    setPreferenceListSelect(AIRLINE_PREFERENCES_CHOICE);
                    this.airlinePreferences = airlinePreferences;
                }

                /** 
                 * Check if AlliancePreferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifAlliancePreferences() {
                    return preferenceListSelect == ALLIANCE_PREFERENCES_CHOICE;
                }

                /** 
                 * Get the 'AlliancePreferences' element value.
                 * 
                 * @return value
                 */
                public AlliancePreferencesType getAlliancePreferences() {
                    return alliancePreferences;
                }

                /** 
                 * Set the 'AlliancePreferences' element value.
                 * 
                 * @param alliancePreferences
                 */
                public void setAlliancePreferences(
                        AlliancePreferencesType alliancePreferences) {
                    setPreferenceListSelect(ALLIANCE_PREFERENCES_CHOICE);
                    this.alliancePreferences = alliancePreferences;
                }

                /** 
                 * Check if FlightPreferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifFlightPreferences() {
                    return preferenceListSelect == FLIGHT_PREFERENCES_CHOICE;
                }

                /** 
                 * Get the 'FlightPreferences' element value.
                 * 
                 * @return value
                 */
                public FlightPreferencesType getFlightPreferences() {
                    return flightPreferences;
                }

                /** 
                 * Set the 'FlightPreferences' element value.
                 * 
                 * @param flightPreferences
                 */
                public void setFlightPreferences(
                        FlightPreferencesType flightPreferences) {
                    setPreferenceListSelect(FLIGHT_PREFERENCES_CHOICE);
                    this.flightPreferences = flightPreferences;
                }

                /** 
                 * Check if FarePreferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifFarePreferences() {
                    return preferenceListSelect == FARE_PREFERENCES_CHOICE;
                }

                /** 
                 * Get the 'FarePreferences' element value.
                 * 
                 * @return value
                 */
                public FarePreferencesType getFarePreferences() {
                    return farePreferences;
                }

                /** 
                 * Set the 'FarePreferences' element value.
                 * 
                 * @param farePreferences
                 */
                public void setFarePreferences(
                        FarePreferencesType farePreferences) {
                    setPreferenceListSelect(FARE_PREFERENCES_CHOICE);
                    this.farePreferences = farePreferences;
                }

                /** 
                 * Check if PricingMethodPreference is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPricingMethodPreference() {
                    return preferenceListSelect == PRICING_METHOD_PREFERENCE_CHOICE;
                }

                /** 
                 * Get the 'PricingMethodPreference' element value.
                 * 
                 * @return value
                 */
                public BestPricingPreferencesType getPricingMethodPreference() {
                    return pricingMethodPreference;
                }

                /** 
                 * Set the 'PricingMethodPreference' element value.
                 * 
                 * @param pricingMethodPreference
                 */
                public void setPricingMethodPreference(
                        BestPricingPreferencesType pricingMethodPreference) {
                    setPreferenceListSelect(PRICING_METHOD_PREFERENCE_CHOICE);
                    this.pricingMethodPreference = pricingMethodPreference;
                }

                /** 
                 * Check if SegMaxTimePreferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifSegMaxTimePreferences() {
                    return preferenceListSelect == SEG_MAX_TIME_PREFERENCES_CHOICE;
                }

                /** 
                 * Get the 'SegMaxTimePreferences' element value.
                 * 
                 * @return value
                 */
                public FltSegmentMaxTimePreferencesType getSegMaxTimePreferences() {
                    return segMaxTimePreferences;
                }

                /** 
                 * Set the 'SegMaxTimePreferences' element value.
                 * 
                 * @param segMaxTimePreferences
                 */
                public void setSegMaxTimePreferences(
                        FltSegmentMaxTimePreferencesType segMaxTimePreferences) {
                    setPreferenceListSelect(SEG_MAX_TIME_PREFERENCES_CHOICE);
                    this.segMaxTimePreferences = segMaxTimePreferences;
                }

                /** 
                 * Check if ServicePricingOnlyPreference is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifServicePricingOnlyPreference() {
                    return preferenceListSelect == SERVICE_PRICING_ONLY_PREFERENCE_CHOICE;
                }

                /** 
                 * Get the 'ServicePricingOnlyPreference' element value.
                 * 
                 * @return value
                 */
                public ServicePricingOnlyPreference getServicePricingOnlyPreference() {
                    return servicePricingOnlyPreference;
                }

                /** 
                 * Set the 'ServicePricingOnlyPreference' element value.
                 * 
                 * @param servicePricingOnlyPreference
                 */
                public void setServicePricingOnlyPreference(
                        ServicePricingOnlyPreference servicePricingOnlyPreference) {
                    setPreferenceListSelect(SERVICE_PRICING_ONLY_PREFERENCE_CHOICE);
                    this.servicePricingOnlyPreference = servicePricingOnlyPreference;
                }

                /** 
                 * Check if TransferPreferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifTransferPreferences() {
                    return preferenceListSelect == TRANSFER_PREFERENCES_CHOICE;
                }

                /** 
                 * Get the 'TransferPreferences' element value.
                 * 
                 * @return value
                 */
                public TransferPreferencesType getTransferPreferences() {
                    return transferPreferences;
                }

                /** 
                 * Set the 'TransferPreferences' element value.
                 * 
                 * @param transferPreferences
                 */
                public void setTransferPreferences(
                        TransferPreferencesType transferPreferences) {
                    setPreferenceListSelect(TRANSFER_PREFERENCES_CHOICE);
                    this.transferPreferences = transferPreferences;
                }

                /** 
                 * Check if CabinPreferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifCabinPreferences() {
                    return preferenceListSelect == CABIN_PREFERENCES_CHOICE;
                }

                /** 
                 * Get the 'CabinPreferences' element value.
                 * 
                 * @return value
                 */
                public CabinPreferencesType getCabinPreferences() {
                    return cabinPreferences;
                }

                /** 
                 * Set the 'CabinPreferences' element value.
                 * 
                 * @param cabinPreferences
                 */
                public void setCabinPreferences(
                        CabinPreferencesType cabinPreferences) {
                    setPreferenceListSelect(CABIN_PREFERENCES_CHOICE);
                    this.cabinPreferences = cabinPreferences;
                }
            }
        }
    }
}
