
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The ItinReshop transaction set passes new shopping requests to an airline to replace existing specified order items in an Order or for new shopping requests to add to an existing Order. 

 Airline responds with product offers within the context of the existing Order. This transaction may also be used to re-price an order (e.g. prior to payment).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinReshopRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:ItinReshopProcessing"/>
 *                 &lt;xs:element ref="ns:ShoppingResponseIDs" minOccurs="0"/>
 *                 &lt;xs:element name="Passengers">
 *                   &lt;xs:complexType>
 *                     &lt;xs:sequence>
 *                       &lt;xs:element name="Passenger" minOccurs="0" maxOccurs="unbounded">
 *                         &lt;!-- Reference to inner class Passenger -->
 *                       &lt;/xs:element>
 *                       &lt;xs:element name="Group" minOccurs="0">
 *                         &lt;!-- Reference to inner class Group -->
 *                       &lt;/xs:element>
 *                     &lt;/xs:sequence>
 *                   &lt;/xs:complexType>
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="Order" minOccurs="0">
 *                   &lt;!-- Reference to inner class Order -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="ReShopOffers">
 *                   &lt;xs:complexType>
 *                     &lt;xs:sequence>
 *                       &lt;xs:element name="ReShopOffer" maxOccurs="unbounded">
 *                         &lt;!-- Reference to inner class ReShopOffer -->
 *                       &lt;/xs:element>
 *                     &lt;/xs:sequence>
 *                   &lt;/xs:complexType>
 *                 &lt;/xs:element>
 *                 &lt;xs:element type="ns:PenaltyType" name="ChangeFees" minOccurs="0"/>
 *                 &lt;xs:element name="Payments" minOccurs="0">
 *                   &lt;!-- Reference to inner class Payments -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="TicketDocInfos" minOccurs="0">
 *                   &lt;!-- Reference to inner class TicketDocInfos -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element name="Commission" minOccurs="0">
 *                   &lt;!-- Reference to inner class Commission -->
 *                 &lt;/xs:element>
 *                 &lt;xs:element type="ns:DataListType" name="DataList" minOccurs="0"/>
 *                 &lt;xs:element type="ns:ItinReshopMetadataType" name="Metadata" minOccurs="0"/>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ItinReshopRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private ItinReshopProcessType responseItinReshopProcessing;
    private ShoppingResponseIDType responseShoppingResponseIDs;
    private List<Passenger> passengerList = new ArrayList<Passenger>();
    private Group group;
    private Order order;
    private List<ReShopOffer> responseReShopOfferList = new ArrayList<ReShopOffer>();
    private PenaltyType responseChangeFees;
    private Payments payments;
    private TicketDocInfos ticketDocInfos;
    private Commission commission;
    private DataListType responseDataList;
    private ItinReshopMetadataType responseMetadata;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'ItinReshopProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @return value
     */
    public ItinReshopProcessType getResponseItinReshopProcessing() {
        return responseItinReshopProcessing;
    }

    /** 
     * Set the 'ItinReshopProcessing' element value. Transaction Processing Results, including processing status, alerts, notices, business warnings, supplemental marketing messages and policy.
     * 
     * @param responseItinReshopProcessing
     */
    public void setResponseItinReshopProcessing(
            ItinReshopProcessType responseItinReshopProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseItinReshopProcessing = responseItinReshopProcessing;
    }

    /** 
     * Get the 'ShoppingResponseIDs' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getResponseShoppingResponseIDs() {
        return responseShoppingResponseIDs;
    }

    /** 
     * Set the 'ShoppingResponseIDs' element value.
     * 
     * @param responseShoppingResponseIDs
     */
    public void setResponseShoppingResponseIDs(
            ShoppingResponseIDType responseShoppingResponseIDs) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseShoppingResponseIDs = responseShoppingResponseIDs;
    }

    /** 
     * Get the list of 'Passenger' element items. Passenger and Group information.
     * 
     * @return list
     */
    public List<Passenger> getPassengerList() {
        return passengerList;
    }

    /** 
     * Set the list of 'Passenger' element items. Passenger and Group information.
     * 
     * @param list
     */
    public void setPassengerList(List<Passenger> list) {
        setChoiceSelect(SUCCESS_CHOICE);
        passengerList = list;
    }

    /** 
     * Get the 'Group' element value. Passenger and Group information.
     * 
     * @return value
     */
    public Group getGroup() {
        return group;
    }

    /** 
     * Set the 'Group' element value. Passenger and Group information.
     * 
     * @param group
     */
    public void setGroup(Group group) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.group = group;
    }

    /** 
     * Get the 'Order' element value. Query Results.
     * 
     * @return value
     */
    public Order getOrder() {
        return order;
    }

    /** 
     * Set the 'Order' element value. Query Results.
     * 
     * @param order
     */
    public void setOrder(Order order) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.order = order;
    }

    /** 
     * Get the list of 'ReShopOffer' element items. Reshopped airline offer(s).
     * 
     * @return list
     */
    public List<ReShopOffer> getResponseReShopOfferList() {
        return responseReShopOfferList;
    }

    /** 
     * Set the list of 'ReShopOffer' element items. Reshopped airline offer(s).
     * 
     * @param list
     */
    public void setResponseReShopOfferList(List<ReShopOffer> list) {
        setChoiceSelect(SUCCESS_CHOICE);
        responseReShopOfferList = list;
    }

    /** 
     * Get the 'ChangeFees' element value. Reshop Fees(s) and Penalty(s).
     * 
     * @return value
     */
    public PenaltyType getResponseChangeFees() {
        return responseChangeFees;
    }

    /** 
     * Set the 'ChangeFees' element value. Reshop Fees(s) and Penalty(s).
     * 
     * @param responseChangeFees
     */
    public void setResponseChangeFees(PenaltyType responseChangeFees) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseChangeFees = responseChangeFees;
    }

    /** 
     * Get the 'Payments' element value. Query Results.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Query Results.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.payments = payments;
    }

    /** 
     * Get the 'TicketDocInfos' element value. Query Results.
     * 
     * @return value
     */
    public TicketDocInfos getTicketDocInfos() {
        return ticketDocInfos;
    }

    /** 
     * Set the 'TicketDocInfos' element value. Query Results.
     * 
     * @param ticketDocInfos
     */
    public void setTicketDocInfos(TicketDocInfos ticketDocInfos) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.ticketDocInfos = ticketDocInfos;
    }

    /** 
     * Get the 'Commission' element value. Query Results.
     * 
     * @return value
     */
    public Commission getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. Query Results.
     * 
     * @param commission
     */
    public void setCommission(Commission commission) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.commission = commission;
    }

    /** 
     * Get the 'DataList' element value. Data List(s)
     * 
     * @return value
     */
    public DataListType getResponseDataList() {
        return responseDataList;
    }

    /** 
     * Set the 'DataList' element value. Data List(s)
     * 
     * @param responseDataList
     */
    public void setResponseDataList(DataListType responseDataList) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseDataList = responseDataList;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public ItinReshopMetadataType getResponseMetadata() {
        return responseMetadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param responseMetadata
     */
    public void setResponseMetadata(ItinReshopMetadataType responseMetadata) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseMetadata = responseMetadata;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Passenger and Action.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passenger" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:PassengerSummaryType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="ActionType" minOccurs="0">
     *             &lt;!-- Reference to inner class ActionType -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passenger extends PassengerSummaryType implements
        Serializable
    {
        private ActionType actionType;

        /** 
         * Get the 'ActionType' element value.
         * 
         * @return value
         */
        public ActionType getActionType() {
            return actionType;
        }

        /** 
         * Set the 'ActionType' element value.
         * 
         * @param actionType
         */
        public void setActionType(ActionType actionType) {
            this.actionType = actionType;
        }
        /** 
         * Order Action. Examples: Cancel, Create, Update, Delete, Reissue, Reprice
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ActionType implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Action Type Context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Action Type Context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
    /** 
     * Group Information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Group" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:GroupType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="ActionType" minOccurs="0">
     *             &lt;!-- Reference to inner class ActionType -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Group extends GroupType implements Serializable
    {
        private ActionType actionType;

        /** 
         * Get the 'ActionType' element value.
         * 
         * @return value
         */
        public ActionType getActionType() {
            return actionType;
        }

        /** 
         * Set the 'ActionType' element value.
         * 
         * @param actionType
         */
        public void setActionType(ActionType actionType) {
            this.actionType = actionType;
        }
        /** 
         * Order Action. Examples: Cancel, Create, Update, Delete, Reissue, Reprice
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ActionType implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Action Type Context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Action Type Context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
    /** 
     * Order information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Order" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OrderCoreType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:OrderItemRepriceType" name="OrderItems"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Order extends OrderCoreType implements Serializable
    {
        private OrderItemRepriceType orderItems;

        /** 
         * Get the 'OrderItems' element value. Order Item Detail.
         * 
         * @return value
         */
        public OrderItemRepriceType getOrderItems() {
            return orderItems;
        }

        /** 
         * Set the 'OrderItems' element value. Order Item Detail.
         * 
         * @param orderItems
         */
        public void setOrderItems(OrderItemRepriceType orderItems) {
            this.orderItems = orderItems;
        }
    }
    /** 
     * Reshopped airline offer
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReShopOffer" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OfferItemDetailType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:PricedFlightOfferType" name="ReShopPricedOffer" minOccurs="0"/>
     *           &lt;xs:element name="ReshopDifferential" minOccurs="0">
     *             &lt;!-- Reference to inner class ReshopDifferential -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReShopOffer extends OfferItemDetailType implements
        Serializable
    {
        private PricedFlightOfferType reShopPricedOffer;
        private ReshopDifferential reshopDifferential;

        /** 
         * Get the 'ReShopPricedOffer' element value. A RESHOP PRICED FLIGHT Offer.

        Notes:
        1. A Priced Flight Offer may contain Branded Fare information. If it is a Branded Fare, Price Class-association will be specified.

        2. Additionally, Lead Pricing Calendar fares (prior to and/ or after the specified departure date) may be specified by passenger type.
         * 
         * @return value
         */
        public PricedFlightOfferType getReShopPricedOffer() {
            return reShopPricedOffer;
        }

        /** 
         * Set the 'ReShopPricedOffer' element value. A RESHOP PRICED FLIGHT Offer.

        Notes:
        1. A Priced Flight Offer may contain Branded Fare information. If it is a Branded Fare, Price Class-association will be specified.

        2. Additionally, Lead Pricing Calendar fares (prior to and/ or after the specified departure date) may be specified by passenger type.
         * 
         * @param reShopPricedOffer
         */
        public void setReShopPricedOffer(PricedFlightOfferType reShopPricedOffer) {
            this.reShopPricedOffer = reShopPricedOffer;
        }

        /** 
         * Get the 'ReshopDifferential' element value.
         * 
         * @return value
         */
        public ReshopDifferential getReshopDifferential() {
            return reshopDifferential;
        }

        /** 
         * Set the 'ReshopDifferential' element value.
         * 
         * @param reshopDifferential
         */
        public void setReshopDifferential(ReshopDifferential reshopDifferential) {
            this.reshopDifferential = reshopDifferential;
        }
        /** 
         * It contains the Original order amount, new offer amount, penalty details, fees and due by details. It also contains the taxes information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReshopDifferential" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="OriginalOrder">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element ref="ns:Total"/>
         *             &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="NewOffer">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element ref="ns:Total"/>
         *             &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="PenaltyAmount" minOccurs="0">
         *         &lt;!-- Reference to inner class PenaltyAmount -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="FeesAmount" minOccurs="0">
         *         &lt;!-- Reference to inner class FeesAmount -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ReshopDue">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element name="ByPassenger">
         *               &lt;xs:complexType>
         *                 &lt;xs:sequence>
         *                   &lt;xs:element ref="ns:Total"/>
         *                 &lt;/xs:sequence>
         *               &lt;/xs:complexType>
         *             &lt;/xs:element>
         *             &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ReshopDifferential implements Serializable
        {
            private TotalFareTransactionType originalOrderTotal;
            private TaxDetailType originalOrderTaxes;
            private TotalFareTransactionType newOfferTotal;
            private TaxDetailType newOfferTaxes;
            private PenaltyAmount penaltyAmount;
            private FeesAmount feesAmount;
            private TotalFareTransactionType reshopDueByPassenger;
            private TaxDetailType reshopDueTaxes;

            /** 
             * Get the 'Total' element value.
             * 
             * @return value
             */
            public TotalFareTransactionType getOriginalOrderTotal() {
                return originalOrderTotal;
            }

            /** 
             * Set the 'Total' element value.
             * 
             * @param originalOrderTotal
             */
            public void setOriginalOrderTotal(
                    TotalFareTransactionType originalOrderTotal) {
                this.originalOrderTotal = originalOrderTotal;
            }

            /** 
             * Get the 'Taxes' element value. Tax Information.
             * 
             * @return value
             */
            public TaxDetailType getOriginalOrderTaxes() {
                return originalOrderTaxes;
            }

            /** 
             * Set the 'Taxes' element value. Tax Information.
             * 
             * @param originalOrderTaxes
             */
            public void setOriginalOrderTaxes(TaxDetailType originalOrderTaxes) {
                this.originalOrderTaxes = originalOrderTaxes;
            }

            /** 
             * Get the 'Total' element value.
             * 
             * @return value
             */
            public TotalFareTransactionType getNewOfferTotal() {
                return newOfferTotal;
            }

            /** 
             * Set the 'Total' element value.
             * 
             * @param newOfferTotal
             */
            public void setNewOfferTotal(TotalFareTransactionType newOfferTotal) {
                this.newOfferTotal = newOfferTotal;
            }

            /** 
             * Get the 'Taxes' element value. Tax Information.
             * 
             * @return value
             */
            public TaxDetailType getNewOfferTaxes() {
                return newOfferTaxes;
            }

            /** 
             * Set the 'Taxes' element value. Tax Information.
             * 
             * @param newOfferTaxes
             */
            public void setNewOfferTaxes(TaxDetailType newOfferTaxes) {
                this.newOfferTaxes = newOfferTaxes;
            }

            /** 
             * Get the 'PenaltyAmount' element value.
             * 
             * @return value
             */
            public PenaltyAmount getPenaltyAmount() {
                return penaltyAmount;
            }

            /** 
             * Set the 'PenaltyAmount' element value.
             * 
             * @param penaltyAmount
             */
            public void setPenaltyAmount(PenaltyAmount penaltyAmount) {
                this.penaltyAmount = penaltyAmount;
            }

            /** 
             * Get the 'FeesAmount' element value.
             * 
             * @return value
             */
            public FeesAmount getFeesAmount() {
                return feesAmount;
            }

            /** 
             * Set the 'FeesAmount' element value.
             * 
             * @param feesAmount
             */
            public void setFeesAmount(FeesAmount feesAmount) {
                this.feesAmount = feesAmount;
            }

            /** 
             * Get the 'Total' element value. Use when reshop is due by Passenger.
             * 
             * @return value
             */
            public TotalFareTransactionType getReshopDueByPassenger() {
                return reshopDueByPassenger;
            }

            /** 
             * Set the 'Total' element value. Use when reshop is due by Passenger.
             * 
             * @param reshopDueByPassenger
             */
            public void setReshopDueByPassenger(
                    TotalFareTransactionType reshopDueByPassenger) {
                this.reshopDueByPassenger = reshopDueByPassenger;
            }

            /** 
             * Get the 'Taxes' element value. Tax Information.
             * 
             * @return value
             */
            public TaxDetailType getReshopDueTaxes() {
                return reshopDueTaxes;
            }

            /** 
             * Set the 'Taxes' element value. Tax Information.
             * 
             * @param reshopDueTaxes
             */
            public void setReshopDueTaxes(TaxDetailType reshopDueTaxes) {
                this.reshopDueTaxes = reshopDueTaxes;
            }
            /** 
             * Penalty fare details.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyAmount" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:Total"/>
             *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PenaltyAmount implements Serializable
            {
                private TotalFareTransactionType total;
                private TaxDetailType taxes;

                /** 
                 * Get the 'Total' element value.
                 * 
                 * @return value
                 */
                public TotalFareTransactionType getTotal() {
                    return total;
                }

                /** 
                 * Set the 'Total' element value.
                 * 
                 * @param total
                 */
                public void setTotal(TotalFareTransactionType total) {
                    this.total = total;
                }

                /** 
                 * Get the 'Taxes' element value. Tax Information.
                 * 
                 * @return value
                 */
                public TaxDetailType getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value. Tax Information.
                 * 
                 * @param taxes
                 */
                public void setTaxes(TaxDetailType taxes) {
                    this.taxes = taxes;
                }
            }
            /** 
             * Fees information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeesAmount" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:Total"/>
             *       &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FeesAmount implements Serializable
            {
                private TotalFareTransactionType total;
                private TaxDetailType taxes;

                /** 
                 * Get the 'Total' element value.
                 * 
                 * @return value
                 */
                public TotalFareTransactionType getTotal() {
                    return total;
                }

                /** 
                 * Set the 'Total' element value.
                 * 
                 * @param total
                 */
                public void setTotal(TotalFareTransactionType total) {
                    this.total = total;
                }

                /** 
                 * Get the 'Taxes' element value. Tax Information.
                 * 
                 * @return value
                 */
                public TaxDetailType getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value. Tax Information.
                 * 
                 * @param taxes
                 */
                public void setTaxes(TaxDetailType taxes) {
                    this.taxes = taxes;
                }
            }
        }
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Payment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Payment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private List<Payment> paymentList = new ArrayList<Payment>();

        /** 
         * Get the list of 'Payment' element items.
         * 
         * @return list
         */
        public List<Payment> getPaymentList() {
            return paymentList;
        }

        /** 
         * Set the list of 'Payment' element items.
         * 
         * @param list
         */
        public void setPaymentList(List<Payment> list) {
            paymentList = list;
        }
        /** 
         * Payment detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:PaymentMethodType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="ActionType" minOccurs="0">
         *             &lt;!-- Reference to inner class ActionType -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Payment extends PaymentMethodType implements
            Serializable
        {
            private ActionType actionType;

            /** 
             * Get the 'ActionType' element value.
             * 
             * @return value
             */
            public ActionType getActionType() {
                return actionType;
            }

            /** 
             * Set the 'ActionType' element value.
             * 
             * @param actionType
             */
            public void setActionType(ActionType actionType) {
                this.actionType = actionType;
            }
            /** 
             * Order Action. Examples: Cancel, Create, Update, Delete, Reissue, Reprice
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ActionType implements Serializable
            {
                private String string;
                private String context;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Action Type Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Action Type Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }
            }
        }
    }
    /** 
     * Ticket/ Document Information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfos" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="TicketDocInfo" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class TicketDocInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TicketDocInfos implements Serializable
    {
        private List<TicketDocInfo> ticketDocInfoList = new ArrayList<TicketDocInfo>();

        /** 
         * Get the list of 'TicketDocInfo' element items.
         * 
         * @return list
         */
        public List<TicketDocInfo> getTicketDocInfoList() {
            return ticketDocInfoList;
        }

        /** 
         * Set the list of 'TicketDocInfo' element items.
         * 
         * @param list
         */
        public void setTicketDocInfoList(List<TicketDocInfo> list) {
            ticketDocInfoList = list;
        }
        /** 
         * Ticket/document information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfo" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AgentIDs" minOccurs="0">
         *         &lt;!-- Reference to inner class AgentIDs -->
         *       &lt;/xs:element>
         *       &lt;xs:element ref="ns:IssuingAirlineInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:TicketDocument" maxOccurs="4"/>
         *       &lt;xs:element ref="ns:CarrierFeeInfo" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OriginalIssueInfo" minOccurs="0"/>
         *       &lt;xs:element name="ActionType" minOccurs="0">
         *         &lt;!-- Reference to inner class ActionType -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketDocInfo implements Serializable
        {
            private AgentIDs agentIDs;
            private AirlineIssuanceType issuingAirlineInfo;
            private List<TicketDocument> ticketDocumentList = new ArrayList<TicketDocument>();
            private CarrierFeeInfoType carrierFeeInfo;
            private OriginalIssueType originalIssueInfo;
            private ActionType actionType;

            /** 
             * Get the 'AgentIDs' element value.
             * 
             * @return value
             */
            public AgentIDs getAgentIDs() {
                return agentIDs;
            }

            /** 
             * Set the 'AgentIDs' element value.
             * 
             * @param agentIDs
             */
            public void setAgentIDs(AgentIDs agentIDs) {
                this.agentIDs = agentIDs;
            }

            /** 
             * Get the 'IssuingAirlineInfo' element value.
             * 
             * @return value
             */
            public AirlineIssuanceType getIssuingAirlineInfo() {
                return issuingAirlineInfo;
            }

            /** 
             * Set the 'IssuingAirlineInfo' element value.
             * 
             * @param issuingAirlineInfo
             */
            public void setIssuingAirlineInfo(
                    AirlineIssuanceType issuingAirlineInfo) {
                this.issuingAirlineInfo = issuingAirlineInfo;
            }

            /** 
             * Get the list of 'TicketDocument' element items.
             * 
             * @return list
             */
            public List<TicketDocument> getTicketDocumentList() {
                return ticketDocumentList;
            }

            /** 
             * Set the list of 'TicketDocument' element items.
             * 
             * @param list
             */
            public void setTicketDocumentList(List<TicketDocument> list) {
                ticketDocumentList = list;
            }

            /** 
             * Get the 'CarrierFeeInfo' element value.
             * 
             * @return value
             */
            public CarrierFeeInfoType getCarrierFeeInfo() {
                return carrierFeeInfo;
            }

            /** 
             * Set the 'CarrierFeeInfo' element value.
             * 
             * @param carrierFeeInfo
             */
            public void setCarrierFeeInfo(CarrierFeeInfoType carrierFeeInfo) {
                this.carrierFeeInfo = carrierFeeInfo;
            }

            /** 
             * Get the 'OriginalIssueInfo' element value.
             * 
             * @return value
             */
            public OriginalIssueType getOriginalIssueInfo() {
                return originalIssueInfo;
            }

            /** 
             * Set the 'OriginalIssueInfo' element value.
             * 
             * @param originalIssueInfo
             */
            public void setOriginalIssueInfo(OriginalIssueType originalIssueInfo) {
                this.originalIssueInfo = originalIssueInfo;
            }

            /** 
             * Get the 'ActionType' element value.
             * 
             * @return value
             */
            public ActionType getActionType() {
                return actionType;
            }

            /** 
             * Set the 'ActionType' element value.
             * 
             * @param actionType
             */
            public void setActionType(ActionType actionType) {
                this.actionType = actionType;
            }
            /** 
             * Booking and Servicing Agent information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentIDs" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:AgentID" maxOccurs="2"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AgentIDs implements Serializable
            {
                private List<CouponAgentType> agentIDList = new ArrayList<CouponAgentType>();

                /** 
                 * Get the list of 'AgentID' element items.
                 * 
                 * @return list
                 */
                public List<CouponAgentType> getAgentIDList() {
                    return agentIDList;
                }

                /** 
                 * Set the list of 'AgentID' element items.
                 * 
                 * @param list
                 */
                public void setAgentIDList(List<CouponAgentType> list) {
                    agentIDList = list;
                }
            }
            /** 
             * Order Action. Examples: Cancel, Create, Update, Delete, Reissue, Reprice
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ActionType implements Serializable
            {
                private String string;
                private String context;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Action Type Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Action Type Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }
            }
        }
    }
    /** 
     * Commission information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Commission" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:CommissionType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="ActionType" minOccurs="0">
     *             &lt;!-- Reference to inner class ActionType -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Commission extends CommissionType implements
        Serializable
    {
        private ActionType actionType;

        /** 
         * Get the 'ActionType' element value.
         * 
         * @return value
         */
        public ActionType getActionType() {
            return actionType;
        }

        /** 
         * Set the 'ActionType' element value.
         * 
         * @param actionType
         */
        public void setActionType(ActionType actionType) {
            this.actionType = actionType;
        }
        /** 
         * Order Action. Examples: Cancel, Create, Update, Delete, Reissue, Reprice
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ActionType implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Action Type Context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Action Type Context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
}
