
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Lead Price detail.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LeadPrice">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:date" name="LeadDate"/>
 *       &lt;xs:element type="xs:date" name="RequestedDate" minOccurs="0"/>
 *       &lt;xs:choice maxOccurs="2">
 *         &lt;!-- Reference to inner class Choice -->
 *       &lt;/xs:choice>
 *       &lt;xs:choice>
 *         &lt;xs:element name="TotalAmount">
 *           &lt;xs:complexType>
 *             &lt;xs:choice>
 *               &lt;xs:element ref="ns:AwardPricing"/>
 *               &lt;xs:element ref="ns:CombinationPricing"/>
 *               &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
 *               &lt;xs:element ref="ns:DetailCurrencyPrice"/>
 *               &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
 *             &lt;/xs:choice>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:sequence>
 *           &lt;!-- Reference to inner class Sequence -->
 *         &lt;/xs:sequence>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class LeadPrice implements Serializable
{
    private Date leadDate;
    private Date requestedDate;
    private List<Choice> choiceList = new ArrayList<Choice>();
    private int choiceSelect = -1;
    private static final int TOTAL_AMOUNT_CHOICE = 0;
    private static final int SEQUENCE_CHOICE = 1;
    private int totalAmountSelect = -1;
    private static final int TOTAL_AMOUNT_AWARD_PRICING_CHOICE = 0;
    private static final int TOTAL_AMOUNT_COMBINATION_PRICING_CHOICE = 1;
    private static final int TOTAL_AMOUNT_SIMPLE_CURRENCY_PRICE_CHOICE = 2;
    private static final int TOTAL_AMOUNT_DETAIL_CURRENCY_PRICE_CHOICE = 3;
    private static final int TOTAL_AMOUNT_ENCODED_CURRENCY_PRICE_CHOICE = 4;
    private AwardPriceUnitType totalAmountAwardPricing;
    private CombinationPriceType totalAmountCombinationPricing;
    private SimpleCurrencyPrice totalAmountSimpleCurrencyPrice;
    private DetailCurrencyPriceType totalAmountDetailCurrencyPrice;
    private EncodedCurrencyPrice totalAmountEncodedCurrencyPrice;
    private Sequence sequence;

    /** 
     * Get the 'LeadDate' element value. Lead Pricing (alternate) Date. Example: 2017-01-10

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public Date getLeadDate() {
        return leadDate;
    }

    /** 
     * Set the 'LeadDate' element value. Lead Pricing (alternate) Date. Example: 2017-01-10

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param leadDate
     */
    public void setLeadDate(Date leadDate) {
        this.leadDate = leadDate;
    }

    /** 
     * Get the 'RequestedDate' element value. Actual travel date requested by Traveler. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public Date getRequestedDate() {
        return requestedDate;
    }

    /** 
     * Set the 'RequestedDate' element value. Actual travel date requested by Traveler. Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param requestedDate
     */
    public void setRequestedDate(Date requestedDate) {
        this.requestedDate = requestedDate;
    }

    /** 
     * Get the list of choice items.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of choice items.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if TotalAmount is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalAmount() {
        return choiceSelect == TOTAL_AMOUNT_CHOICE;
    }

    private void setTotalAmountSelect(int choice) {
        setChoiceSelect(TOTAL_AMOUNT_CHOICE);
        if (totalAmountSelect == -1) {
            totalAmountSelect = choice;
        } else if (totalAmountSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearTotalAmountSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearTotalAmountSelect() {
        totalAmountSelect = -1;
    }

    /** 
     * Check if TotalAmountAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalAmountAwardPricing() {
        return totalAmountSelect == TOTAL_AMOUNT_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value.
     * 
     * @return value
     */
    public AwardPriceUnitType getTotalAmountAwardPricing() {
        return totalAmountAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value.
     * 
     * @param totalAmountAwardPricing
     */
    public void setTotalAmountAwardPricing(
            AwardPriceUnitType totalAmountAwardPricing) {
        setTotalAmountSelect(TOTAL_AMOUNT_AWARD_PRICING_CHOICE);
        this.totalAmountAwardPricing = totalAmountAwardPricing;
    }

    /** 
     * Check if TotalAmountCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalAmountCombinationPricing() {
        return totalAmountSelect == TOTAL_AMOUNT_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value.
     * 
     * @return value
     */
    public CombinationPriceType getTotalAmountCombinationPricing() {
        return totalAmountCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value.
     * 
     * @param totalAmountCombinationPricing
     */
    public void setTotalAmountCombinationPricing(
            CombinationPriceType totalAmountCombinationPricing) {
        setTotalAmountSelect(TOTAL_AMOUNT_COMBINATION_PRICING_CHOICE);
        this.totalAmountCombinationPricing = totalAmountCombinationPricing;
    }

    /** 
     * Check if TotalAmountSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalAmountSimpleCurrencyPrice() {
        return totalAmountSelect == TOTAL_AMOUNT_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value.
     * 
     * @return value
     */
    public SimpleCurrencyPrice getTotalAmountSimpleCurrencyPrice() {
        return totalAmountSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value.
     * 
     * @param totalAmountSimpleCurrencyPrice
     */
    public void setTotalAmountSimpleCurrencyPrice(
            SimpleCurrencyPrice totalAmountSimpleCurrencyPrice) {
        setTotalAmountSelect(TOTAL_AMOUNT_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.totalAmountSimpleCurrencyPrice = totalAmountSimpleCurrencyPrice;
    }

    /** 
     * Check if TotalAmountDetailCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalAmountDetailCurrencyPrice() {
        return totalAmountSelect == TOTAL_AMOUNT_DETAIL_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'DetailCurrencyPrice' element value.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getTotalAmountDetailCurrencyPrice() {
        return totalAmountDetailCurrencyPrice;
    }

    /** 
     * Set the 'DetailCurrencyPrice' element value.
     * 
     * @param totalAmountDetailCurrencyPrice
     */
    public void setTotalAmountDetailCurrencyPrice(
            DetailCurrencyPriceType totalAmountDetailCurrencyPrice) {
        setTotalAmountSelect(TOTAL_AMOUNT_DETAIL_CURRENCY_PRICE_CHOICE);
        this.totalAmountDetailCurrencyPrice = totalAmountDetailCurrencyPrice;
    }

    /** 
     * Check if TotalAmountEncodedCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTotalAmountEncodedCurrencyPrice() {
        return totalAmountSelect == TOTAL_AMOUNT_ENCODED_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyPrice' element value.
     * 
     * @return value
     */
    public EncodedCurrencyPrice getTotalAmountEncodedCurrencyPrice() {
        return totalAmountEncodedCurrencyPrice;
    }

    /** 
     * Set the 'EncodedCurrencyPrice' element value.
     * 
     * @param totalAmountEncodedCurrencyPrice
     */
    public void setTotalAmountEncodedCurrencyPrice(
            EncodedCurrencyPrice totalAmountEncodedCurrencyPrice) {
        setTotalAmountSelect(TOTAL_AMOUNT_ENCODED_CURRENCY_PRICE_CHOICE);
        this.totalAmountEncodedCurrencyPrice = totalAmountEncodedCurrencyPrice;
    }

    /** 
     * Check if Sequence is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSequence() {
        return choiceSelect == SEQUENCE_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getSequence() {
        return sequence;
    }

    /** 
     * Set the sequence value.
     * 
     * @param sequence
     */
    public void setSequence(Sequence sequence) {
        setChoiceSelect(SEQUENCE_CHOICE);
        this.sequence = sequence;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
     *   &lt;xs:element ref="ns:OriginDestinationReference"/>
     *   &lt;xs:element ref="ns:SegmentReference"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int ORIGIN_DESTINATION_REFERENCE_CHOICE = 0;
        private static final int SEGMENT_REFERENCE_CHOICE = 1;
        private OriginDestinationReference originDestinationReference;
        private SegmentReference segmentReference;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if OriginDestinationReference is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOriginDestinationReference() {
            return choiceListSelect == ORIGIN_DESTINATION_REFERENCE_CHOICE;
        }

        /** 
         * Get the 'OriginDestinationReference' element value.
         * 
         * @return value
         */
        public OriginDestinationReference getOriginDestinationReference() {
            return originDestinationReference;
        }

        /** 
         * Set the 'OriginDestinationReference' element value.
         * 
         * @param originDestinationReference
         */
        public void setOriginDestinationReference(
                OriginDestinationReference originDestinationReference) {
            setChoiceListSelect(ORIGIN_DESTINATION_REFERENCE_CHOICE);
            this.originDestinationReference = originDestinationReference;
        }

        /** 
         * Check if SegmentReference is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSegmentReference() {
            return choiceListSelect == SEGMENT_REFERENCE_CHOICE;
        }

        /** 
         * Get the 'SegmentReference' element value.
         * 
         * @return value
         */
        public SegmentReference getSegmentReference() {
            return segmentReference;
        }

        /** 
         * Set the 'SegmentReference' element value.
         * 
         * @param segmentReference
         */
        public void setSegmentReference(SegmentReference segmentReference) {
            setChoiceListSelect(SEGMENT_REFERENCE_CHOICE);
            this.segmentReference = segmentReference;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="ns:CurrencyAmountOptType" name="BaseAmount" minOccurs="0"/>
     *   &lt;xs:element ref="ns:FareFiledIn" minOccurs="0"/>
     *   &lt;xs:element name="Surcharges" minOccurs="0">
     *     &lt;!-- Reference to inner class Surcharges -->
     *   &lt;/xs:element>
     *   &lt;xs:element type="ns:TaxDetailType" name="Taxes" minOccurs="0"/>
     *   &lt;xs:element ref="ns:TaxExemption" minOccurs="0"/>
     *   &lt;xs:choice>
     *     &lt;xs:element type="ns:AwardPriceUnitType" name="AwardPricing" minOccurs="0"/>
     *     &lt;xs:element type="ns:CombinationPriceType" name="CombinationPricing" minOccurs="0"/>
     *   &lt;/xs:choice>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private CurrencyAmountOptType baseAmount;
        private FareFilingType fareFiledIn;
        private Surcharges surcharges;
        private TaxDetailType taxes;
        private TaxExemptionType taxExemption;
        private int choiceSelect = -1;
        private static final int AWARD_PRICING_CHOICE = 0;
        private static final int COMBINATION_PRICING_CHOICE = 1;
        private AwardPriceUnitType awardPricing;
        private CombinationPriceType combinationPricing;

        /** 
         * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

        Note: This includes  surcharges (if applicable).
         * 
         * @return value
         */
        public CurrencyAmountOptType getBaseAmount() {
            return baseAmount;
        }

        /** 
         * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000

        Note: This includes  surcharges (if applicable).
         * 
         * @param baseAmount
         */
        public void setBaseAmount(CurrencyAmountOptType baseAmount) {
            this.baseAmount = baseAmount;
        }

        /** 
         * Get the 'FareFiledIn' element value.
         * 
         * @return value
         */
        public FareFilingType getFareFiledIn() {
            return fareFiledIn;
        }

        /** 
         * Set the 'FareFiledIn' element value.
         * 
         * @param fareFiledIn
         */
        public void setFareFiledIn(FareFilingType fareFiledIn) {
            this.fareFiledIn = fareFiledIn;
        }

        /** 
         * Get the 'Surcharges' element value.
         * 
         * @return value
         */
        public Surcharges getSurcharges() {
            return surcharges;
        }

        /** 
         * Set the 'Surcharges' element value.
         * 
         * @param surcharges
         */
        public void setSurcharges(Surcharges surcharges) {
            this.surcharges = surcharges;
        }

        /** 
         * Get the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
         * 
         * @return value
         */
        public TaxDetailType getTaxes() {
            return taxes;
        }

        /** 
         * Set the 'Taxes' element value. Ticket Tax/fee/charge details to indicate taxes that apply to country of commencement of travel and routing.
         * 
         * @param taxes
         */
        public void setTaxes(TaxDetailType taxes) {
            this.taxes = taxes;
        }

        /** 
         * Get the 'TaxExemption' element value.
         * 
         * @return value
         */
        public TaxExemptionType getTaxExemption() {
            return taxExemption;
        }

        /** 
         * Set the 'TaxExemption' element value.
         * 
         * @param taxExemption
         */
        public void setTaxExemption(TaxExemptionType taxExemption) {
            this.taxExemption = taxExemption;
        }

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return choiceSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value. AWARD (Redemption Unit-based) Pricing information.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setChoiceSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Check if CombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCombinationPricing() {
            return choiceSelect == COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value. PARTIAL CURRENCY and AWARD Pricing Combination information.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            setChoiceSelect(COMBINATION_PRICING_CHOICE);
            this.combinationPricing = combinationPricing;
        }
        /** 
         * Applicable Surcharge(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharges" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:FeeSurchargeType" name="Surcharge" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Surcharges implements Serializable
        {
            private List<FeeSurchargeType> surchargeList = new ArrayList<FeeSurchargeType>();

            /** 
             * Get the list of 'Surcharge' element items. Surcharge detail.
             * 
             * @return list
             */
            public List<FeeSurchargeType> getSurchargeList() {
                return surchargeList;
            }

            /** 
             * Set the list of 'Surcharge' element items. Surcharge detail.
             * 
             * @param list
             */
            public void setSurchargeList(List<FeeSurchargeType> list) {
                surchargeList = list;
            }
        }
    }
}
