
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * LEAD TIMES PERIOD helper object.

 Notes: Supports Calendar Shopping and Departure/ Arrival Time preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LeadTimePeriodType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:attribute type="xs:string" use="optional" name="Before"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="After"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LeadTimePeriodType extends AssociatedObjectBaseType implements
    Serializable
{
    private String before;
    private String after;

    /** 
     * Get the 'Before' attribute value. The period duration to be applied BEFORE (prior to) the specified time.  Examples: 
    P3D (three days)
    PT2H (two hours)
     * 
     * @return value
     */
    public String getBefore() {
        return before;
    }

    /** 
     * Set the 'Before' attribute value. The period duration to be applied BEFORE (prior to) the specified time.  Examples: 
    P3D (three days)
    PT2H (two hours)
     * 
     * @param before
     */
    public void setBefore(String before) {
        this.before = before;
    }

    /** 
     * Get the 'After' attribute value. The period duration to be applied AFTER the specified time.  Examples: 
    P3D (three days)
    PT2H (two hours)
     * 
     * @return value
     */
    public String getAfter() {
        return after;
    }

    /** 
     * Set the 'After' attribute value. The period duration to be applied AFTER the specified time.  Examples: 
    P3D (three days)
    PT2H (two hours)
     * 
     * @param after
     */
    public void setAfter(String after) {
        this.after = after;
    }
}
