
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * A data type definition for Plain Text with Link Description.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LinkDescriptionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Links" minOccurs="0">
 *       &lt;!-- Reference to inner class Links -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Texts" minOccurs="0">
 *       &lt;!-- Reference to inner class Texts -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LangCode"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="Timestamp"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Title"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LinkDescriptionType implements Serializable
{
    private Links links;
    private Texts texts;
    private String langCode;
    private Date timestamp;
    private String title;

    /** 
     * Get the 'Links' element value.
     * 
     * @return value
     */
    public Links getLinks() {
        return links;
    }

    /** 
     * Set the 'Links' element value.
     * 
     * @param links
     */
    public void setLinks(Links links) {
        this.links = links;
    }

    /** 
     * Get the 'Texts' element value.
     * 
     * @return value
     */
    public Texts getTexts() {
        return texts;
    }

    /** 
     * Set the 'Texts' element value.
     * 
     * @param texts
     */
    public void setTexts(Texts texts) {
        this.texts = texts;
    }

    /** 
     * Get the 'LangCode' attribute value. Language Code. Example: en, en-US
     * 
     * @return value
     */
    public String getLangCode() {
        return langCode;
    }

    /** 
     * Set the 'LangCode' attribute value. Language Code. Example: en, en-US
     * 
     * @param langCode
     */
    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    /** 
     * Get the 'Timestamp' attribute value. Creation Timestamp. Example: 2017-01-13T13:59:38Z
     * 
     * @return value
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' attribute value. Creation Timestamp. Example: 2017-01-13T13:59:38Z
     * 
     * @param timestamp
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    /** 
     * Get the 'Title' attribute value. Title. Example: This Title
     * 
     * @return value
     */
    public String getTitle() {
        return title;
    }

    /** 
     * Set the 'Title' attribute value. Title. Example: This Title
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }
    /** 
     * Link(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Links" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:LinkFormattedType" name="Link" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Links implements Serializable
    {
        private List<LinkFormattedType> linkList = new ArrayList<LinkFormattedType>();

        /** 
         * Get the list of 'Link' element items. Description Link. Example: thisairline.com/myLink
         * 
         * @return list
         */
        public List<LinkFormattedType> getLinkList() {
            return linkList;
        }

        /** 
         * Set the list of 'Link' element items. Description Link. Example: thisairline.com/myLink
         * 
         * @param list
         */
        public void setLinkList(List<LinkFormattedType> list) {
            linkList = list;
        }
    }
    /** 
     * Link Description(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Texts" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Text" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Texts implements Serializable
    {
        private List<String> textList = new ArrayList<String>();

        /** 
         * Get the list of 'Text' element items. Description detail.
         * 
         * @return list
         */
        public List<String> getTextList() {
            return textList;
        }

        /** 
         * Set the list of 'Text' element items. Description detail.
         * 
         * @param list
         */
        public void setTextList(List<String> list) {
            textList = list;
        }
    }
}
