
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * US DOT BAGGAGE RULE data list definition.Select a value from the enumerated list or enter a string value.
 =enumerated values=
 N = NOT SUBJECT TO US DOT RESERVATION OR DISCLOSURE
 Y = SUBJECT TO US DOT RESERVATION AND DISCLOSURE
 D = SUBJECT TO DISCLOSURE BUT NOT TO US DOT RESERVATION
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfBagDisclosureType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="BagDisclosure" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class BagDisclosure -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfBagDisclosureType implements Serializable
{
    private List<BagDisclosure> bagDisclosureList = new ArrayList<BagDisclosure>();

    /** 
     * Get the list of 'BagDisclosure' element items.
     * 
     * @return list
     */
    public List<BagDisclosure> getBagDisclosureList() {
        return bagDisclosureList;
    }

    /** 
     * Set the list of 'BagDisclosure' element items.
     * 
     * @param list
     */
    public void setBagDisclosureList(List<BagDisclosure> list) {
        bagDisclosureList = list;
    }
    /** 
     * Baggage Disclosure detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDisclosure" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="xs:string" name="BagRule"/>
     *           &lt;xs:element type="ns:Descriptions" name="Descriptions" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BagDisclosure extends DataListObjectBaseType implements
        Serializable
    {
        private String bagRule;
        private Descriptions descriptions;

        /** 
         * Get the 'BagRule' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule.
        Examples: Y, Disclosure AND US DOT Reservation
         * 
         * @return value
         */
        public String getBagRule() {
            return bagRule;
        }

        /** 
         * Set the 'BagRule' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule.
        Examples: Y, Disclosure AND US DOT Reservation
         * 
         * @param bagRule
         */
        public void setBagRule(String bagRule) {
            this.bagRule = bagRule;
        }

        /** 
         * Get the 'Descriptions' element value.
         * 
         * @return value
         */
        public Descriptions getDescriptions() {
            return descriptions;
        }

        /** 
         * Set the 'Descriptions' element value.
         * 
         * @param descriptions
         */
        public void setDescriptions(Descriptions descriptions) {
            this.descriptions = descriptions;
        }
    }
}
