
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OPTIONAL SERVICE Data List definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ListOfServiceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Service" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Service -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ListOfServiceType implements Serializable
{
    private List<Service> serviceList = new ArrayList<Service>();

    /** 
     * Get the list of 'Service' element items.
     * 
     * @return list
     */
    public List<Service> getServiceList() {
        return serviceList;
    }

    /** 
     * Set the list of 'Service' element items.
     * 
     * @param list
     */
    public void setServiceList(List<Service> list) {
        serviceList = list;
    }
    /** 
     * Service Detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:ServiceID"/>
     *           &lt;xs:element type="xs:string" name="Name"/>
     *           &lt;xs:element type="ns:ServiceEncodingType" name="Encoding"/>
     *           &lt;xs:element type="xs:string" name="FeeMethod" minOccurs="0"/>
     *           &lt;xs:element type="ns:ServiceDescriptionType" name="SVCDescriptions"/>
     *           &lt;xs:element name="Settlement" minOccurs="0">
     *             &lt;!-- Reference to inner class Settlement -->
     *           &lt;/xs:element>
     *           &lt;xs:element type="ns:ServicePriceType" name="Price" minOccurs="0"/>
     *           &lt;xs:element type="ns:ServiceAssocType" name="Associations" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Service extends DataListObjectBaseType implements
        Serializable
    {
        private ServiceIDType serviceID;
        private String name;
        private ServiceEncodingType encoding;
        private String feeMethod;
        private ServiceDescriptionType SVCDescriptions;
        private Settlement settlement;
        private ServicePriceType price;
        private ServiceAssocType associations;

        /** 
         * Get the 'ServiceID' element value.
         * 
         * @return value
         */
        public ServiceIDType getServiceID() {
            return serviceID;
        }

        /** 
         * Set the 'ServiceID' element value.
         * 
         * @param serviceID
         */
        public void setServiceID(ServiceIDType serviceID) {
            this.serviceID = serviceID;
        }

        /** 
         * Get the 'Name' element value. Service name.Example: Lounge Pass
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Service name.Example: Lounge Pass
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'Encoding' element value. Service Codes and Reason for Issuance.
         * 
         * @return value
         */
        public ServiceEncodingType getEncoding() {
            return encoding;
        }

        /** 
         * Set the 'Encoding' element value. Service Codes and Reason for Issuance.
         * 
         * @param encoding
         */
        public void setEncoding(ServiceEncodingType encoding) {
            this.encoding = encoding;
        }

        /** 
         * Get the 'FeeMethod' element value. Two character generic code to identify ticket level charges, fees and taxes.
         * 
         * @return value
         */
        public String getFeeMethod() {
            return feeMethod;
        }

        /** 
         * Set the 'FeeMethod' element value. Two character generic code to identify ticket level charges, fees and taxes.
         * 
         * @param feeMethod
         */
        public void setFeeMethod(String feeMethod) {
            this.feeMethod = feeMethod;
        }

        /** 
         * Get the 'SVCDescriptions' element value. SERVICE Description.

        Note: Supports plain text, multimedia and code and link references.
         * 
         * @return value
         */
        public ServiceDescriptionType getSVCDescriptions() {
            return SVCDescriptions;
        }

        /** 
         * Set the 'SVCDescriptions' element value. SERVICE Description.

        Note: Supports plain text, multimedia and code and link references.
         * 
         * @param SVCDescriptions
         */
        public void setSVCDescriptions(ServiceDescriptionType SVCDescriptions) {
            this.SVCDescriptions = SVCDescriptions;
        }

        /** 
         * Get the 'Settlement' element value.
         * 
         * @return value
         */
        public Settlement getSettlement() {
            return settlement;
        }

        /** 
         * Set the 'Settlement' element value.
         * 
         * @param settlement
         */
        public void setSettlement(Settlement settlement) {
            this.settlement = settlement;
        }

        /** 
         * Get the 'Price' element value. Optional SERVICE PRICE.

        Notes: This Price amount may be set to zero if pricing has been applied at the Offer Item level.
         * 
         * @return value
         */
        public ServicePriceType getPrice() {
            return price;
        }

        /** 
         * Set the 'Price' element value. Optional SERVICE PRICE.

        Notes: This Price amount may be set to zero if pricing has been applied at the Offer Item level.
         * 
         * @param price
         */
        public void setPrice(ServicePriceType price) {
            this.price = price;
        }

        /** 
         * Get the 'Associations' element value. Other Service Association(s).
         * 
         * @return value
         */
        public ServiceAssocType getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value. Other Service Association(s).
         * 
         * @param associations
         */
        public void setAssociations(ServiceAssocType associations) {
            this.associations = associations;
        }
        /** 
         * Interline Settlement information between airlines, including method of settlement, interline settlement value and currency.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Settlement" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CodesetType" name="Method"/>
         *       &lt;xs:element type="ns:CurrencyAmountOptType" name="InterlineSettlementValue" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Settlement implements Serializable
        {
            private CodesetType method;
            private CurrencyAmountOptType interlineSettlementValue;

            /** 
             * Get the 'Method' element value. Service settlement method.
            Examples:
            AD (Internal Airline Document)
            DS (Direct Settlement)
            EA (EMD Associated or Internal Airline Document)
            ES (EMD Standalone )
            FI (Fare Integrated)
            MA (Flight Associated)
            MS (Standalone)

            Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
             * 
             * @return value
             */
            public CodesetType getMethod() {
                return method;
            }

            /** 
             * Set the 'Method' element value. Service settlement method.
            Examples:
            AD (Internal Airline Document)
            DS (Direct Settlement)
            EA (EMD Associated or Internal Airline Document)
            ES (EMD Standalone )
            FI (Fare Integrated)
            MA (Flight Associated)
            MS (Standalone)

            Encoding Scheme: IATA PADIS Codeset SST (Service Settlement Type)
             * 
             * @param method
             */
            public void setMethod(CodesetType method) {
                this.method = method;
            }

            /** 
             * Get the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

            Note: This represents a Settlement value that is only used between the POA and ORA.
             * 
             * @return value
             */
            public CurrencyAmountOptType getInterlineSettlementValue() {
                return interlineSettlementValue;
            }

            /** 
             * Set the 'InterlineSettlementValue' element value. Settlement (Price) Value. Example: 300 (USD)

            Note: This represents a Settlement value that is only used between the POA and ORA.
             * 
             * @param interlineSettlementValue
             */
            public void setInterlineSettlementValue(
                    CurrencyAmountOptType interlineSettlementValue) {
                this.interlineSettlementValue = interlineSettlementValue;
            }
        }
    }
}
