
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Offer Match Results.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MatchResultsListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Full"/>
 *     &lt;xs:enumeration value="None"/>
 *     &lt;xs:enumeration value="Partial"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MatchResultsListType implements Serializable {
    FULL("Full"), NONE("None"), PARTIAL("Partial"), OTHER("Other");
    private final String value;

    private MatchResultsListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MatchResultsListType convert(String value) {
        for (MatchResultsListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
