
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Language Code Application list constraint.

 Examples: Display, Requested, Spoken, Written, Other
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MediaAppListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Audio"/>
 *     &lt;xs:enumeration value="Image"/>
 *     &lt;xs:enumeration value="Link"/>
 *     &lt;xs:enumeration value="Markup"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MediaAppListType implements Serializable {
    AUDIO("Audio"), IMAGE("Image"), LINK("Link"), MARKUP("Markup"), OTHER(
            "Other");
    private final String value;

    private MediaAppListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MediaAppListType convert(String value) {
        for (MediaAppListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
