
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Media Category constrained kist.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MediaCategoryListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="File_PDF"/>
 *     &lt;xs:enumeration value="File_Other"/>
 *     &lt;xs:enumeration value="Image_GIF"/>
 *     &lt;xs:enumeration value="Image_JPG"/>
 *     &lt;xs:enumeration value="Image_PNG"/>
 *     &lt;xs:enumeration value="Image_Other"/>
 *     &lt;xs:enumeration value="Link_FTP"/>
 *     &lt;xs:enumeration value="Link_MailTo"/>
 *     &lt;xs:enumeration value="Link_URL"/>
 *     &lt;xs:enumeration value="Link_URN"/>
 *     &lt;xs:enumeration value="Multimedia_MP3"/>
 *     &lt;xs:enumeration value="Multimedia_SWF"/>
 *     &lt;xs:enumeration value="Multimedia_Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MediaCategoryListType implements Serializable {
    FILE_PDF("File_PDF"), FILE_OTHER("File_Other"), IMAGE_GIF("Image_GIF"), IMAGE_JPG(
            "Image_JPG"), IMAGE_PNG("Image_PNG"), IMAGE_OTHER("Image_Other"), LINK_FTP(
            "Link_FTP"), LINK_MAIL_TO("Link_MailTo"), LINK_URL("Link_URL"), LINK_URN(
            "Link_URN"), MULTIMEDIA_M_P3("Multimedia_MP3"), MULTIMEDIA_SWF(
            "Multimedia_SWF"), MULTIMEDIA_OTHER("Multimedia_Other");
    private final String value;

    private MediaCategoryListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MediaCategoryListType convert(String value) {
        for (MediaCategoryListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
