
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Requested search processing and results currency information.

 Notes:
 1. This is not the point of sale currency that is specified in the PointOfSale node.

 2. This element repeats to allow multiple search result currencies to be specified using a currency code and currency role combination.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MessageCurrencies">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:CurrencyCodeType" name="CurrCode" maxOccurs="unbounded"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class MessageCurrencies implements Serializable
{
    private List<CurrencyCodeType> currCodeList = new ArrayList<CurrencyCodeType>();

    /** 
     * Get the list of 'CurrCode' element items. ISO Currency Code. Example: USD

    Encoding Scheme: ISO 4217 (three alpha character) Currency Code
     * 
     * @return list
     */
    public List<CurrencyCodeType> getCurrCodeList() {
        return currCodeList;
    }

    /** 
     * Set the list of 'CurrCode' element items. ISO Currency Code. Example: USD

    Encoding Scheme: ISO 4217 (three alpha character) Currency Code
     * 
     * @param list
     */
    public void setCurrCodeList(List<CurrencyCodeType> list) {
        currCodeList = list;
    }
}
