
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for MetaSearch URL Link Application constrained list. Examples: AirlineSite, IntraService, MetaSearchSite, SellerAgencySite, Other
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MetaSrchLinkAppListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AirlineSite"/>
 *     &lt;xs:enumeration value="IntraService"/>
 *     &lt;xs:enumeration value="MetaSearchSite"/>
 *     &lt;xs:enumeration value="SellerAgencySite"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MetaSrchLinkAppListType implements Serializable {
    AIRLINE_SITE("AirlineSite"), INTRA_SERVICE("IntraService"), META_SEARCH_SITE(
            "MetaSearchSite"), SELLER_AGENCY_SITE("SellerAgencySite"), OTHER(
            "Other");
    private final String value;

    private MetaSrchLinkAppListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MetaSrchLinkAppListType convert(String value) {
        for (MetaSrchLinkAppListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
