
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Authentication and Notification of NDC Actors participating in the message/ transaction. Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MsgPartiesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Sender">
 *       &lt;xs:complexType>
 *         &lt;xs:choice>
 *           &lt;xs:element ref="ns:AgentUserSender"/>
 *           &lt;xs:element ref="ns:AggregatorSender"/>
 *           &lt;xs:element ref="ns:EnabledSystemSender"/>
 *           &lt;xs:element ref="ns:MarketingCarrierSender"/>
 *           &lt;xs:element ref="ns:ORA_Sender"/>
 *           &lt;xs:element ref="ns:OperatingCarrierSender"/>
 *           &lt;xs:element ref="ns:POA_Sender"/>
 *           &lt;xs:element ref="ns:RetailPartnerSender"/>
 *           &lt;xs:element ref="ns:TravelAgencySender"/>
 *         &lt;/xs:choice>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element nillable="true" name="Participants" minOccurs="0">
 *       &lt;!-- Reference to inner class Participants -->
 *     &lt;/xs:element>
 *     &lt;xs:element nillable="true" name="Recipient" minOccurs="0">
 *       &lt;!-- Reference to inner class Recipient -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MsgPartiesType implements Serializable
{
    private int senderSelect = -1;
    private static final int SENDER_AGENT_USER_SENDER_CHOICE = 0;
    private static final int SENDER_AGGREGATOR_SENDER_CHOICE = 1;
    private static final int SENDER_ENABLED_SYSTEM_SENDER_CHOICE = 2;
    private static final int SENDER_MARKETING_CARRIER_SENDER_CHOICE = 3;
    private static final int SENDER_ORA_SENDER_CHOICE = 4;
    private static final int SENDER_OPERATING_CARRIER_SENDER_CHOICE = 5;
    private static final int SENDER_POA_SENDER_CHOICE = 6;
    private static final int SENDER_RETAIL_PARTNER_SENDER_CHOICE = 7;
    private static final int SENDER_TRAVEL_AGENCY_SENDER_CHOICE = 8;
    private AgentUserSender senderAgentUserSender;
    private AggregatorSender senderAggregatorSender;
    private EnabledSystemSender senderEnabledSystemSender;
    private MarketingCarrierSender senderMarketingCarrierSender;
    private ORASender senderORASender;
    private OperatingCarrierSender senderOperatingCarrierSender;
    private POASender senderPOASender;
    private RetailPartnerSender senderRetailPartnerSender;
    private TravelAgencySender senderTravelAgencySender;
    private Participants participants;
    private Recipient recipient;

    private void setSenderSelect(int choice) {
        if (senderSelect == -1) {
            senderSelect = choice;
        } else if (senderSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearSenderSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearSenderSelect() {
        senderSelect = -1;
    }

    /** 
     * Check if SenderAgentUserSender is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSenderAgentUserSender() {
        return senderSelect == SENDER_AGENT_USER_SENDER_CHOICE;
    }

    /** 
     * Get the 'AgentUserSender' element value.
     * 
     * @return value
     */
    public AgentUserSender getSenderAgentUserSender() {
        return senderAgentUserSender;
    }

    /** 
     * Set the 'AgentUserSender' element value.
     * 
     * @param senderAgentUserSender
     */
    public void setSenderAgentUserSender(AgentUserSender senderAgentUserSender) {
        setSenderSelect(SENDER_AGENT_USER_SENDER_CHOICE);
        this.senderAgentUserSender = senderAgentUserSender;
    }

    /** 
     * Check if SenderAggregatorSender is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSenderAggregatorSender() {
        return senderSelect == SENDER_AGGREGATOR_SENDER_CHOICE;
    }

    /** 
     * Get the 'AggregatorSender' element value.
     * 
     * @return value
     */
    public AggregatorSender getSenderAggregatorSender() {
        return senderAggregatorSender;
    }

    /** 
     * Set the 'AggregatorSender' element value.
     * 
     * @param senderAggregatorSender
     */
    public void setSenderAggregatorSender(
            AggregatorSender senderAggregatorSender) {
        setSenderSelect(SENDER_AGGREGATOR_SENDER_CHOICE);
        this.senderAggregatorSender = senderAggregatorSender;
    }

    /** 
     * Check if SenderEnabledSystemSender is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSenderEnabledSystemSender() {
        return senderSelect == SENDER_ENABLED_SYSTEM_SENDER_CHOICE;
    }

    /** 
     * Get the 'EnabledSystemSender' element value.
     * 
     * @return value
     */
    public EnabledSystemSender getSenderEnabledSystemSender() {
        return senderEnabledSystemSender;
    }

    /** 
     * Set the 'EnabledSystemSender' element value.
     * 
     * @param senderEnabledSystemSender
     */
    public void setSenderEnabledSystemSender(
            EnabledSystemSender senderEnabledSystemSender) {
        setSenderSelect(SENDER_ENABLED_SYSTEM_SENDER_CHOICE);
        this.senderEnabledSystemSender = senderEnabledSystemSender;
    }

    /** 
     * Check if SenderMarketingCarrierSender is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSenderMarketingCarrierSender() {
        return senderSelect == SENDER_MARKETING_CARRIER_SENDER_CHOICE;
    }

    /** 
     * Get the 'MarketingCarrierSender' element value.
     * 
     * @return value
     */
    public MarketingCarrierSender getSenderMarketingCarrierSender() {
        return senderMarketingCarrierSender;
    }

    /** 
     * Set the 'MarketingCarrierSender' element value.
     * 
     * @param senderMarketingCarrierSender
     */
    public void setSenderMarketingCarrierSender(
            MarketingCarrierSender senderMarketingCarrierSender) {
        setSenderSelect(SENDER_MARKETING_CARRIER_SENDER_CHOICE);
        this.senderMarketingCarrierSender = senderMarketingCarrierSender;
    }

    /** 
     * Check if SenderORASender is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSenderORASender() {
        return senderSelect == SENDER_ORA_SENDER_CHOICE;
    }

    /** 
     * Get the 'ORA_Sender' element value.
     * 
     * @return value
     */
    public ORASender getSenderORASender() {
        return senderORASender;
    }

    /** 
     * Set the 'ORA_Sender' element value.
     * 
     * @param senderORASender
     */
    public void setSenderORASender(ORASender senderORASender) {
        setSenderSelect(SENDER_ORA_SENDER_CHOICE);
        this.senderORASender = senderORASender;
    }

    /** 
     * Check if SenderOperatingCarrierSender is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSenderOperatingCarrierSender() {
        return senderSelect == SENDER_OPERATING_CARRIER_SENDER_CHOICE;
    }

    /** 
     * Get the 'OperatingCarrierSender' element value.
     * 
     * @return value
     */
    public OperatingCarrierSender getSenderOperatingCarrierSender() {
        return senderOperatingCarrierSender;
    }

    /** 
     * Set the 'OperatingCarrierSender' element value.
     * 
     * @param senderOperatingCarrierSender
     */
    public void setSenderOperatingCarrierSender(
            OperatingCarrierSender senderOperatingCarrierSender) {
        setSenderSelect(SENDER_OPERATING_CARRIER_SENDER_CHOICE);
        this.senderOperatingCarrierSender = senderOperatingCarrierSender;
    }

    /** 
     * Check if SenderPOASender is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSenderPOASender() {
        return senderSelect == SENDER_POA_SENDER_CHOICE;
    }

    /** 
     * Get the 'POA_Sender' element value.
     * 
     * @return value
     */
    public POASender getSenderPOASender() {
        return senderPOASender;
    }

    /** 
     * Set the 'POA_Sender' element value.
     * 
     * @param senderPOASender
     */
    public void setSenderPOASender(POASender senderPOASender) {
        setSenderSelect(SENDER_POA_SENDER_CHOICE);
        this.senderPOASender = senderPOASender;
    }

    /** 
     * Check if SenderRetailPartnerSender is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSenderRetailPartnerSender() {
        return senderSelect == SENDER_RETAIL_PARTNER_SENDER_CHOICE;
    }

    /** 
     * Get the 'RetailPartnerSender' element value.
     * 
     * @return value
     */
    public RetailPartnerSender getSenderRetailPartnerSender() {
        return senderRetailPartnerSender;
    }

    /** 
     * Set the 'RetailPartnerSender' element value.
     * 
     * @param senderRetailPartnerSender
     */
    public void setSenderRetailPartnerSender(
            RetailPartnerSender senderRetailPartnerSender) {
        setSenderSelect(SENDER_RETAIL_PARTNER_SENDER_CHOICE);
        this.senderRetailPartnerSender = senderRetailPartnerSender;
    }

    /** 
     * Check if SenderTravelAgencySender is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSenderTravelAgencySender() {
        return senderSelect == SENDER_TRAVEL_AGENCY_SENDER_CHOICE;
    }

    /** 
     * Get the 'TravelAgencySender' element value.
     * 
     * @return value
     */
    public TravelAgencySender getSenderTravelAgencySender() {
        return senderTravelAgencySender;
    }

    /** 
     * Set the 'TravelAgencySender' element value.
     * 
     * @param senderTravelAgencySender
     */
    public void setSenderTravelAgencySender(
            TravelAgencySender senderTravelAgencySender) {
        setSenderSelect(SENDER_TRAVEL_AGENCY_SENDER_CHOICE);
        this.senderTravelAgencySender = senderTravelAgencySender;
    }

    /** 
     * Get the 'Participants' element value.
     * 
     * @return value
     */
    public Participants getParticipants() {
        return participants;
    }

    /** 
     * Set the 'Participants' element value.
     * 
     * @param participants
     */
    public void setParticipants(Participants participants) {
        this.participants = participants;
    }

    /** 
     * Get the 'Recipient' element value.
     * 
     * @return value
     */
    public Recipient getRecipient() {
        return recipient;
    }

    /** 
     * Set the 'Recipient' element value.
     * 
     * @param recipient
     */
    public void setRecipient(Recipient recipient) {
        this.recipient = recipient;
    }
    /** 
     * Message Participant(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" nillable="true" name="Participants" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Participant" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Participant -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Participants implements Serializable
    {
        private List<Participant> participantList = new ArrayList<Participant>();

        /** 
         * Get the list of 'Participant' element items.
         * 
         * @return list
         */
        public List<Participant> getParticipantList() {
            return participantList;
        }

        /** 
         * Set the list of 'Participant' element items.
         * 
         * @param list
         */
        public void setParticipantList(List<Participant> list) {
            participantList = list;
        }
        /** 
         * Participant detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Participant" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:AggregatorParticipant" minOccurs="0"/>
         *       &lt;xs:element ref="ns:EnabledSystemParticipant" minOccurs="0"/>
         *       &lt;xs:element ref="ns:MarketingCarrierParticipant" minOccurs="0"/>
         *       &lt;xs:element ref="ns:ORA_Participant" minOccurs="0"/>
         *       &lt;xs:element ref="ns:OperatingCarrierParticipant" minOccurs="0"/>
         *       &lt;xs:element ref="ns:POA_Participant" minOccurs="0"/>
         *       &lt;xs:element ref="ns:RetailSupplierParticipant" minOccurs="0"/>
         *       &lt;xs:element ref="ns:TravelAgencyParticipant" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Participant implements Serializable
        {
            private AggregatorParticipantType aggregatorParticipant;
            private EnabledSysParticipantType enabledSystemParticipant;
            private MarketingCarrierParticipantType marketingCarrierParticipant;
            private ORAAirlineParticipantType ORAParticipant;
            private OperatingCarrierParticipantType operatingCarrierParticipant;
            private POAAirlineParticipantType POAParticipant;
            private RetailSupplierParticipantType retailSupplierParticipant;
            private TravelAgencyParticipantType travelAgencyParticipant;

            /** 
             * Get the 'AggregatorParticipant' element value.
             * 
             * @return value
             */
            public AggregatorParticipantType getAggregatorParticipant() {
                return aggregatorParticipant;
            }

            /** 
             * Set the 'AggregatorParticipant' element value.
             * 
             * @param aggregatorParticipant
             */
            public void setAggregatorParticipant(
                    AggregatorParticipantType aggregatorParticipant) {
                this.aggregatorParticipant = aggregatorParticipant;
            }

            /** 
             * Get the 'EnabledSystemParticipant' element value.
             * 
             * @return value
             */
            public EnabledSysParticipantType getEnabledSystemParticipant() {
                return enabledSystemParticipant;
            }

            /** 
             * Set the 'EnabledSystemParticipant' element value.
             * 
             * @param enabledSystemParticipant
             */
            public void setEnabledSystemParticipant(
                    EnabledSysParticipantType enabledSystemParticipant) {
                this.enabledSystemParticipant = enabledSystemParticipant;
            }

            /** 
             * Get the 'MarketingCarrierParticipant' element value.
             * 
             * @return value
             */
            public MarketingCarrierParticipantType getMarketingCarrierParticipant() {
                return marketingCarrierParticipant;
            }

            /** 
             * Set the 'MarketingCarrierParticipant' element value.
             * 
             * @param marketingCarrierParticipant
             */
            public void setMarketingCarrierParticipant(
                    MarketingCarrierParticipantType marketingCarrierParticipant) {
                this.marketingCarrierParticipant = marketingCarrierParticipant;
            }

            /** 
             * Get the 'ORA_Participant' element value.
             * 
             * @return value
             */
            public ORAAirlineParticipantType getORAParticipant() {
                return ORAParticipant;
            }

            /** 
             * Set the 'ORA_Participant' element value.
             * 
             * @param ORAParticipant
             */
            public void setORAParticipant(
                    ORAAirlineParticipantType ORAParticipant) {
                this.ORAParticipant = ORAParticipant;
            }

            /** 
             * Get the 'OperatingCarrierParticipant' element value.
             * 
             * @return value
             */
            public OperatingCarrierParticipantType getOperatingCarrierParticipant() {
                return operatingCarrierParticipant;
            }

            /** 
             * Set the 'OperatingCarrierParticipant' element value.
             * 
             * @param operatingCarrierParticipant
             */
            public void setOperatingCarrierParticipant(
                    OperatingCarrierParticipantType operatingCarrierParticipant) {
                this.operatingCarrierParticipant = operatingCarrierParticipant;
            }

            /** 
             * Get the 'POA_Participant' element value.
             * 
             * @return value
             */
            public POAAirlineParticipantType getPOAParticipant() {
                return POAParticipant;
            }

            /** 
             * Set the 'POA_Participant' element value.
             * 
             * @param POAParticipant
             */
            public void setPOAParticipant(
                    POAAirlineParticipantType POAParticipant) {
                this.POAParticipant = POAParticipant;
            }

            /** 
             * Get the 'RetailSupplierParticipant' element value.
             * 
             * @return value
             */
            public RetailSupplierParticipantType getRetailSupplierParticipant() {
                return retailSupplierParticipant;
            }

            /** 
             * Set the 'RetailSupplierParticipant' element value.
             * 
             * @param retailSupplierParticipant
             */
            public void setRetailSupplierParticipant(
                    RetailSupplierParticipantType retailSupplierParticipant) {
                this.retailSupplierParticipant = retailSupplierParticipant;
            }

            /** 
             * Get the 'TravelAgencyParticipant' element value.
             * 
             * @return value
             */
            public TravelAgencyParticipantType getTravelAgencyParticipant() {
                return travelAgencyParticipant;
            }

            /** 
             * Set the 'TravelAgencyParticipant' element value.
             * 
             * @param travelAgencyParticipant
             */
            public void setTravelAgencyParticipant(
                    TravelAgencyParticipantType travelAgencyParticipant) {
                this.travelAgencyParticipant = travelAgencyParticipant;
            }
        }
    }
    /** 
     * Named Message Recipient.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" nillable="true" name="Recipient" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:AgentUserRecipient"/>
     *       &lt;xs:element ref="ns:AggregatorRecipient"/>
     *       &lt;xs:element ref="ns:EnabledSystemRecipient"/>
     *       &lt;xs:element ref="ns:MarketingCarrierRecipient"/>
     *       &lt;xs:element ref="ns:ORA_Recipient"/>
     *       &lt;xs:element ref="ns:OperatingCarrierRecipient"/>
     *       &lt;xs:element ref="ns:POA_Recipient"/>
     *       &lt;xs:element ref="ns:RetailPartnerRecipient"/>
     *       &lt;xs:element ref="ns:TravelAgencyRecipient"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Recipient implements Serializable
    {
        private int recipientSelect = -1;
        private static final int AGENT_USER_RECIPIENT_CHOICE = 0;
        private static final int AGGREGATOR_RECIPIENT_CHOICE = 1;
        private static final int ENABLED_SYSTEM_RECIPIENT_CHOICE = 2;
        private static final int MARKETING_CARRIER_RECIPIENT_CHOICE = 3;
        private static final int ORA_RECIPIENT_CHOICE = 4;
        private static final int OPERATING_CARRIER_RECIPIENT_CHOICE = 5;
        private static final int POA_RECIPIENT_CHOICE = 6;
        private static final int RETAIL_PARTNER_RECIPIENT_CHOICE = 7;
        private static final int TRAVEL_AGENCY_RECIPIENT_CHOICE = 8;
        private AgentUserRecipient agentUserRecipient;
        private AggregatorRecipient aggregatorRecipient;
        private EnabledSystemRecipient enabledSystemRecipient;
        private MarketingCarrierRecipient marketingCarrierRecipient;
        private ORARecipient ORARecipient;
        private OperatingCarrierRecipient operatingCarrierRecipient;
        private POARecipient POARecipient;
        private RetailPartnerRecipient retailPartnerRecipient;
        private TravelAgencyRecipient travelAgencyRecipient;

        private void setRecipientSelect(int choice) {
            if (recipientSelect == -1) {
                recipientSelect = choice;
            } else if (recipientSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearRecipientSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearRecipientSelect() {
            recipientSelect = -1;
        }

        /** 
         * Check if AgentUserRecipient is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAgentUserRecipient() {
            return recipientSelect == AGENT_USER_RECIPIENT_CHOICE;
        }

        /** 
         * Get the 'AgentUserRecipient' element value.
         * 
         * @return value
         */
        public AgentUserRecipient getAgentUserRecipient() {
            return agentUserRecipient;
        }

        /** 
         * Set the 'AgentUserRecipient' element value.
         * 
         * @param agentUserRecipient
         */
        public void setAgentUserRecipient(AgentUserRecipient agentUserRecipient) {
            setRecipientSelect(AGENT_USER_RECIPIENT_CHOICE);
            this.agentUserRecipient = agentUserRecipient;
        }

        /** 
         * Check if AggregatorRecipient is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAggregatorRecipient() {
            return recipientSelect == AGGREGATOR_RECIPIENT_CHOICE;
        }

        /** 
         * Get the 'AggregatorRecipient' element value.
         * 
         * @return value
         */
        public AggregatorRecipient getAggregatorRecipient() {
            return aggregatorRecipient;
        }

        /** 
         * Set the 'AggregatorRecipient' element value.
         * 
         * @param aggregatorRecipient
         */
        public void setAggregatorRecipient(
                AggregatorRecipient aggregatorRecipient) {
            setRecipientSelect(AGGREGATOR_RECIPIENT_CHOICE);
            this.aggregatorRecipient = aggregatorRecipient;
        }

        /** 
         * Check if EnabledSystemRecipient is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEnabledSystemRecipient() {
            return recipientSelect == ENABLED_SYSTEM_RECIPIENT_CHOICE;
        }

        /** 
         * Get the 'EnabledSystemRecipient' element value.
         * 
         * @return value
         */
        public EnabledSystemRecipient getEnabledSystemRecipient() {
            return enabledSystemRecipient;
        }

        /** 
         * Set the 'EnabledSystemRecipient' element value.
         * 
         * @param enabledSystemRecipient
         */
        public void setEnabledSystemRecipient(
                EnabledSystemRecipient enabledSystemRecipient) {
            setRecipientSelect(ENABLED_SYSTEM_RECIPIENT_CHOICE);
            this.enabledSystemRecipient = enabledSystemRecipient;
        }

        /** 
         * Check if MarketingCarrierRecipient is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifMarketingCarrierRecipient() {
            return recipientSelect == MARKETING_CARRIER_RECIPIENT_CHOICE;
        }

        /** 
         * Get the 'MarketingCarrierRecipient' element value.
         * 
         * @return value
         */
        public MarketingCarrierRecipient getMarketingCarrierRecipient() {
            return marketingCarrierRecipient;
        }

        /** 
         * Set the 'MarketingCarrierRecipient' element value.
         * 
         * @param marketingCarrierRecipient
         */
        public void setMarketingCarrierRecipient(
                MarketingCarrierRecipient marketingCarrierRecipient) {
            setRecipientSelect(MARKETING_CARRIER_RECIPIENT_CHOICE);
            this.marketingCarrierRecipient = marketingCarrierRecipient;
        }

        /** 
         * Check if ORARecipient is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifORARecipient() {
            return recipientSelect == ORA_RECIPIENT_CHOICE;
        }

        /** 
         * Get the 'ORA_Recipient' element value.
         * 
         * @return value
         */
        public ORARecipient getORARecipient() {
            return ORARecipient;
        }

        /** 
         * Set the 'ORA_Recipient' element value.
         * 
         * @param ORARecipient
         */
        public void setORARecipient(ORARecipient ORARecipient) {
            setRecipientSelect(ORA_RECIPIENT_CHOICE);
            this.ORARecipient = ORARecipient;
        }

        /** 
         * Check if OperatingCarrierRecipient is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifOperatingCarrierRecipient() {
            return recipientSelect == OPERATING_CARRIER_RECIPIENT_CHOICE;
        }

        /** 
         * Get the 'OperatingCarrierRecipient' element value.
         * 
         * @return value
         */
        public OperatingCarrierRecipient getOperatingCarrierRecipient() {
            return operatingCarrierRecipient;
        }

        /** 
         * Set the 'OperatingCarrierRecipient' element value.
         * 
         * @param operatingCarrierRecipient
         */
        public void setOperatingCarrierRecipient(
                OperatingCarrierRecipient operatingCarrierRecipient) {
            setRecipientSelect(OPERATING_CARRIER_RECIPIENT_CHOICE);
            this.operatingCarrierRecipient = operatingCarrierRecipient;
        }

        /** 
         * Check if POARecipient is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPOARecipient() {
            return recipientSelect == POA_RECIPIENT_CHOICE;
        }

        /** 
         * Get the 'POA_Recipient' element value.
         * 
         * @return value
         */
        public POARecipient getPOARecipient() {
            return POARecipient;
        }

        /** 
         * Set the 'POA_Recipient' element value.
         * 
         * @param POARecipient
         */
        public void setPOARecipient(POARecipient POARecipient) {
            setRecipientSelect(POA_RECIPIENT_CHOICE);
            this.POARecipient = POARecipient;
        }

        /** 
         * Check if RetailPartnerRecipient is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifRetailPartnerRecipient() {
            return recipientSelect == RETAIL_PARTNER_RECIPIENT_CHOICE;
        }

        /** 
         * Get the 'RetailPartnerRecipient' element value.
         * 
         * @return value
         */
        public RetailPartnerRecipient getRetailPartnerRecipient() {
            return retailPartnerRecipient;
        }

        /** 
         * Set the 'RetailPartnerRecipient' element value.
         * 
         * @param retailPartnerRecipient
         */
        public void setRetailPartnerRecipient(
                RetailPartnerRecipient retailPartnerRecipient) {
            setRecipientSelect(RETAIL_PARTNER_RECIPIENT_CHOICE);
            this.retailPartnerRecipient = retailPartnerRecipient;
        }

        /** 
         * Check if TravelAgencyRecipient is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTravelAgencyRecipient() {
            return recipientSelect == TRAVEL_AGENCY_RECIPIENT_CHOICE;
        }

        /** 
         * Get the 'TravelAgencyRecipient' element value.
         * 
         * @return value
         */
        public TravelAgencyRecipient getTravelAgencyRecipient() {
            return travelAgencyRecipient;
        }

        /** 
         * Set the 'TravelAgencyRecipient' element value.
         * 
         * @param travelAgencyRecipient
         */
        public void setTravelAgencyRecipient(
                TravelAgencyRecipient travelAgencyRecipient) {
            setRecipientSelect(TRAVEL_AGENCY_RECIPIENT_CHOICE);
            this.travelAgencyRecipient = travelAgencyRecipient;
        }
    }
}
