
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Shopping and Order Multiple Association definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiAssociationType">
 *   &lt;xs:choice>
 *     &lt;xs:element ref="ns:OfferAssociations"/>
 *     &lt;xs:element ref="ns:OrderAssociations"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MultiAssociationType implements Serializable
{
    private int choiceSelect = -1;
    private static final int OFFER_ASSOCIATIONS_CHOICE = 0;
    private static final int ORDER_ASSOCIATIONS_CHOICE = 1;
    private OfferAssociationsType offerAssociations;
    private OrderAssociations orderAssociations;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if OfferAssociations is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferAssociations() {
        return choiceSelect == OFFER_ASSOCIATIONS_CHOICE;
    }

    /** 
     * Get the 'OfferAssociations' element value.
     * 
     * @return value
     */
    public OfferAssociationsType getOfferAssociations() {
        return offerAssociations;
    }

    /** 
     * Set the 'OfferAssociations' element value.
     * 
     * @param offerAssociations
     */
    public void setOfferAssociations(OfferAssociationsType offerAssociations) {
        setChoiceSelect(OFFER_ASSOCIATIONS_CHOICE);
        this.offerAssociations = offerAssociations;
    }

    /** 
     * Check if OrderAssociations is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOrderAssociations() {
        return choiceSelect == ORDER_ASSOCIATIONS_CHOICE;
    }

    /** 
     * Get the 'OrderAssociations' element value.
     * 
     * @return value
     */
    public OrderAssociations getOrderAssociations() {
        return orderAssociations;
    }

    /** 
     * Set the 'OrderAssociations' element value.
     * 
     * @param orderAssociations
     */
    public void setOrderAssociations(OrderAssociations orderAssociations) {
        setChoiceSelect(ORDER_ASSOCIATIONS_CHOICE);
        this.orderAssociations = orderAssociations;
    }
}
