
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * CORE OFFER definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemCoreType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Parameters" minOccurs="0">
 *           &lt;!-- Reference to inner class Parameters -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:ItemID_Type" name="OfferID"/>
 *         &lt;xs:element ref="ns:ValidatingCarrier" minOccurs="0"/>
 *         &lt;xs:element type="ns:OfferTimeLimitSetType" name="TimeLimits" minOccurs="0"/>
 *         &lt;xs:element name="TotalPrice" minOccurs="0">
 *           &lt;!-- Reference to inner class TotalPrice -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:DescriptionReferences" minOccurs="0"/>
 *         &lt;xs:element type="ns:DisclosureType" name="Disclosure" minOccurs="0"/>
 *         &lt;xs:element type="ns:PenaltyType" name="Penalty" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:boolean" name="RequestedDateInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferItemCoreType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private Parameters parameters;
    private ItemIDType offerID;
    private ValidatingCarrier validatingCarrier;
    private OfferTimeLimitSetType timeLimits;
    private TotalPrice totalPrice;
    private DescriptionReferences descriptionReferences;
    private DisclosureType disclosure;
    private PenaltyType penalty;
    private Boolean requestedDateInd;

    /** 
     * Get the 'Parameters' element value.
     * 
     * @return value
     */
    public Parameters getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value.
     * 
     * @param parameters
     */
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'OfferID' element value. Globally unique Offer instance ID. length should not be exceed 64 character and it is recommended to not use dash char in it.Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @return value
     */
    public ItemIDType getOfferID() {
        return offerID;
    }

    /** 
     * Set the 'OfferID' element value. Globally unique Offer instance ID. length should not be exceed 64 character and it is recommended to not use dash char in it.Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @param offerID
     */
    public void setOfferID(ItemIDType offerID) {
        this.offerID = offerID;
    }

    /** 
     * Get the 'ValidatingCarrier' element value.
     * 
     * @return value
     */
    public ValidatingCarrier getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' element value.
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(ValidatingCarrier validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'TimeLimits' element value. Offer-Level Time Limits, including Offer Expiration, Payment and Bilateral Time Limits.

    Note: If specified, these time limits are at the OFFER-LEVEL and will apply by default to any relevant (child) Offer Items. These time limits may also be specified at a (child) OFFER ITEM-level where it will apply to that one instance of the Offer Item (and override the Offer-level time limit if one has been specified.)
     * 
     * @return value
     */
    public OfferTimeLimitSetType getTimeLimits() {
        return timeLimits;
    }

    /** 
     * Set the 'TimeLimits' element value. Offer-Level Time Limits, including Offer Expiration, Payment and Bilateral Time Limits.

    Note: If specified, these time limits are at the OFFER-LEVEL and will apply by default to any relevant (child) Offer Items. These time limits may also be specified at a (child) OFFER ITEM-level where it will apply to that one instance of the Offer Item (and override the Offer-level time limit if one has been specified.)
     * 
     * @param timeLimits
     */
    public void setTimeLimits(OfferTimeLimitSetType timeLimits) {
        this.timeLimits = timeLimits;
    }

    /** 
     * Get the 'TotalPrice' element value.
     * 
     * @return value
     */
    public TotalPrice getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value.
     * 
     * @param totalPrice
     */
    public void setTotalPrice(TotalPrice totalPrice) {
        this.totalPrice = totalPrice;
    }

    /** 
     * Get the 'DescriptionReferences' element value.
     * 
     * @return value
     */
    public DescriptionReferences getDescriptionReferences() {
        return descriptionReferences;
    }

    /** 
     * Set the 'DescriptionReferences' element value.
     * 
     * @param descriptionReferences
     */
    public void setDescriptionReferences(
            DescriptionReferences descriptionReferences) {
        this.descriptionReferences = descriptionReferences;
    }

    /** 
     * Get the 'Disclosure' element value. Disclosure information.
     * 
     * @return value
     */
    public DisclosureType getDisclosure() {
        return disclosure;
    }

    /** 
     * Set the 'Disclosure' element value. Disclosure information.
     * 
     * @param disclosure
     */
    public void setDisclosure(DisclosureType disclosure) {
        this.disclosure = disclosure;
    }

    /** 
     * Get the 'Penalty' element value. Penalty information.
     * 
     * @return value
     */
    public PenaltyType getPenalty() {
        return penalty;
    }

    /** 
     * Set the 'Penalty' element value. Penalty information.
     * 
     * @param penalty
     */
    public void setPenalty(PenaltyType penalty) {
        this.penalty = penalty;
    }

    /** 
     * Get the 'RequestedDateInd' attribute value. Indicator to specify if the offer relates to requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @return value
     */
    public Boolean getRequestedDateInd() {
        return requestedDateInd;
    }

    /** 
     * Set the 'RequestedDateInd' attribute value. Indicator to specify if the offer relates to requested date. For example in calendar search, this indicator will be set to 'true' if this airline offer is for a requested date and will not be present (or will be set to 'false' if airline offer is for another date than requested one.
     * 
     * @param requestedDateInd
     */
    public void setRequestedDateInd(Boolean requestedDateInd) {
        this.requestedDateInd = requestedDateInd;
    }
    /** 
     * Offer-wide parameters, including Traveler Applicability; Total Offer Quantity; Passenger Pricing Method; Inventory Guarantee.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Parameters" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="TotalItemQuantity" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PTC_Priced" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ApplyToAllInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="RedemptionOnlyInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Parameters implements Serializable
    {
        private String totalItemQuantity;
        private List<PTCQuantityPricedType> PTCPricedList = new ArrayList<PTCQuantityPricedType>();
        private Boolean applyToAllInd;
        private Boolean redemptionOnlyInd;

        /** 
         * Get the 'TotalItemQuantity' element value. Total Offer Items in this Offer. Example: 3
         * 
         * @return value
         */
        public String getTotalItemQuantity() {
            return totalItemQuantity;
        }

        /** 
         * Set the 'TotalItemQuantity' element value. Total Offer Items in this Offer. Example: 3
         * 
         * @param totalItemQuantity
         */
        public void setTotalItemQuantity(String totalItemQuantity) {
            this.totalItemQuantity = totalItemQuantity;
        }

        /** 
         * Get the list of 'PTC_Priced' element items. Requested and Priced PTC (passenger type code) and associated Traveler quantity.
         * 
         * @return list
         */
        public List<PTCQuantityPricedType> getPTCPricedList() {
            return PTCPricedList;
        }

        /** 
         * Set the list of 'PTC_Priced' element items. Requested and Priced PTC (passenger type code) and associated Traveler quantity.
         * 
         * @param list
         */
        public void setPTCPricedList(List<PTCQuantityPricedType> list) {
            PTCPricedList = list;
        }

        /** 
         * Get the 'ApplyToAllInd' attribute value. When TRUE, this Offer applies to all Travelers.
         * 
         * @return value
         */
        public Boolean getApplyToAllInd() {
            return applyToAllInd;
        }

        /** 
         * Set the 'ApplyToAllInd' attribute value. When TRUE, this Offer applies to all Travelers.
         * 
         * @param applyToAllInd
         */
        public void setApplyToAllInd(Boolean applyToAllInd) {
            this.applyToAllInd = applyToAllInd;
        }

        /** 
         * Get the 'RedemptionOnlyInd' attribute value. When TRUE, this Offer must be redeemed, e.g. it cannot be purchased.

        Note: Taxes may still apply.
         * 
         * @return value
         */
        public Boolean getRedemptionOnlyInd() {
            return redemptionOnlyInd;
        }

        /** 
         * Set the 'RedemptionOnlyInd' attribute value. When TRUE, this Offer must be redeemed, e.g. it cannot be purchased.

        Note: Taxes may still apply.
         * 
         * @param redemptionOnlyInd
         */
        public void setRedemptionOnlyInd(Boolean redemptionOnlyInd) {
            this.redemptionOnlyInd = redemptionOnlyInd;
        }
    }
    /** 
     * The total price for all Travelers associated with this offer.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalPrice" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:AwardPricing"/>
     *       &lt;xs:element ref="ns:CombinationPricing"/>
     *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
     *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
     *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
     *     &lt;/xs:choice>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class TotalPrice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int AWARD_PRICING_CHOICE = 0;
        private static final int COMBINATION_PRICING_CHOICE = 1;
        private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 2;
        private static final int DETAIL_CURRENCY_PRICE_CHOICE = 3;
        private static final int ENCODED_CURRENCY_PRICE_CHOICE = 4;
        private AwardPriceUnitType awardPricing;
        private CombinationPriceType combinationPricing;
        private SimpleCurrencyPrice simpleCurrencyPrice;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private String refs;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return choiceSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setChoiceSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Check if CombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCombinationPricing() {
            return choiceSelect == COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            setChoiceSelect(COMBINATION_PRICING_CHOICE);
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Check if SimpleCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSimpleCurrencyPrice() {
            return choiceSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            setChoiceSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }

        /** 
         * Check if DetailCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDetailCurrencyPrice() {
            return choiceSelect == DETAIL_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            setChoiceSelect(DETAIL_CURRENCY_PRICE_CHOICE);
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Check if EncodedCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEncodedCurrencyPrice() {
            return choiceSelect == ENCODED_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            setChoiceSelect(ENCODED_CURRENCY_PRICE_CHOICE);
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
