
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for OPERATING CARRIER Supplier Role with Optional Flight Number.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingCarrierFlightType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:AirlineID" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element ref="ns:FlightNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="ResBookDesigCode" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OperatingCarrierFlightType extends AssociatedObjectBaseType
    implements Serializable
{
    private AirlineIDType airlineID;
    private String name;
    private FlightNumber flightNumber;
    private String resBookDesigCode;

    /** 
     * Get the 'AirlineID' element value. A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory.
     * 
     * @return value
     */
    public AirlineIDType getAirlineID() {
        return airlineID;
    }

    /** 
     * Set the 'AirlineID' element value. A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory.
     * 
     * @param airlineID
     */
    public void setAirlineID(AirlineIDType airlineID) {
        this.airlineID = airlineID;
    }

    /** 
     * Get the 'Name' element value. Airline Name.  Example: British Airways
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Airline Name.  Example: British Airways
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'FlightNumber' element value.
     * 
     * @return value
     */
    public FlightNumber getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value.
     * 
     * @param flightNumber
     */
    public void setFlightNumber(FlightNumber flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'ResBookDesigCode' element value. The Reservation Booking Designator (booking class) of the Operating Carrier if different from the Marketing Carrier. Example: Y
     * 
     * @return value
     */
    public String getResBookDesigCode() {
        return resBookDesigCode;
    }

    /** 
     * Set the 'ResBookDesigCode' element value. The Reservation Booking Designator (booking class) of the Operating Carrier if different from the Marketing Carrier. Example: Y
     * 
     * @param resBookDesigCode
     */
    public void setResBookDesigCode(String resBookDesigCode) {
        this.resBookDesigCode = resBookDesigCode;
    }
}
