
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Notice definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrdCreateNoticesType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:NoticeBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CampaignReferralType" name="CampaignReferral" minOccurs="0"/>
 *         &lt;xs:element name="PaymentRules" minOccurs="0">
 *           &lt;!-- Reference to inner class PaymentRules -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="PricingParameters" minOccurs="0">
 *           &lt;!-- Reference to inner class PricingParameters -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="PriceVarianceRules" minOccurs="0">
 *           &lt;!-- Reference to inner class PriceVarianceRules -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="TaxExemptionRules" minOccurs="0">
 *           &lt;!-- Reference to inner class TaxExemptionRules -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrdCreateNoticesType extends NoticeBaseType implements
    Serializable
{
    private CampaignReferralType campaignReferral;
    private PaymentRules paymentRules;
    private PricingParameters pricingParameters;
    private PriceVarianceRules priceVarianceRules;
    private TaxExemptionRules taxExemptionRules;

    /** 
     * Get the 'CampaignReferral' element value. UTM Search Campaign Referral Notice.

    Note: Supports marketing channel measurement from trading partner websites that refer shoppers to other EDIST-enabled systems. Urchin Tracking Monitoring (UTM) parameters are used to specify referral source and campaign parameters.
     * 
     * @return value
     */
    public CampaignReferralType getCampaignReferral() {
        return campaignReferral;
    }

    /** 
     * Set the 'CampaignReferral' element value. UTM Search Campaign Referral Notice.

    Note: Supports marketing channel measurement from trading partner websites that refer shoppers to other EDIST-enabled systems. Urchin Tracking Monitoring (UTM) parameters are used to specify referral source and campaign parameters.
     * 
     * @param campaignReferral
     */
    public void setCampaignReferral(CampaignReferralType campaignReferral) {
        this.campaignReferral = campaignReferral;
    }

    /** 
     * Get the 'PaymentRules' element value.
     * 
     * @return value
     */
    public PaymentRules getPaymentRules() {
        return paymentRules;
    }

    /** 
     * Set the 'PaymentRules' element value.
     * 
     * @param paymentRules
     */
    public void setPaymentRules(PaymentRules paymentRules) {
        this.paymentRules = paymentRules;
    }

    /** 
     * Get the 'PricingParameters' element value.
     * 
     * @return value
     */
    public PricingParameters getPricingParameters() {
        return pricingParameters;
    }

    /** 
     * Set the 'PricingParameters' element value.
     * 
     * @param pricingParameters
     */
    public void setPricingParameters(PricingParameters pricingParameters) {
        this.pricingParameters = pricingParameters;
    }

    /** 
     * Get the 'PriceVarianceRules' element value.
     * 
     * @return value
     */
    public PriceVarianceRules getPriceVarianceRules() {
        return priceVarianceRules;
    }

    /** 
     * Set the 'PriceVarianceRules' element value.
     * 
     * @param priceVarianceRules
     */
    public void setPriceVarianceRules(PriceVarianceRules priceVarianceRules) {
        this.priceVarianceRules = priceVarianceRules;
    }

    /** 
     * Get the 'TaxExemptionRules' element value.
     * 
     * @return value
     */
    public TaxExemptionRules getTaxExemptionRules() {
        return taxExemptionRules;
    }

    /** 
     * Set the 'TaxExemptionRules' element value.
     * 
     * @param taxExemptionRules
     */
    public void setTaxExemptionRules(TaxExemptionRules taxExemptionRules) {
        this.taxExemptionRules = taxExemptionRules;
    }
    /** 
     * Payment Processing Rule(s) Notice.

    Note: Supports specifying Payment Processing Rules, including payment failure. Request messages may include defined payment processing rules and an indicator requesting that the rules be applied during payment processing where relevant. Response messages may additionally include notice about if and how payment rule(s) were applied during transaction processing.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentRules" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ProceedOnFailureInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PaymentRules implements Serializable
    {
        private Boolean proceedOnFailureInd;

        /** 
         * Get the 'ProceedOnFailureInd' attribute value. When TRUE, the Seller wants to proceed with Order creation if one of multiple forms of payment provided fails.

        Note: This supports multi payment form-enabled systems where one Traveler may provide multiple FOPs, or individual Travelers may each provide their own FOP.
         * 
         * @return value
         */
        public Boolean getProceedOnFailureInd() {
            return proceedOnFailureInd;
        }

        /** 
         * Set the 'ProceedOnFailureInd' attribute value. When TRUE, the Seller wants to proceed with Order creation if one of multiple forms of payment provided fails.

        Note: This supports multi payment form-enabled systems where one Traveler may provide multiple FOPs, or individual Travelers may each provide their own FOP.
         * 
         * @param proceedOnFailureInd
         */
        public void setProceedOnFailureInd(Boolean proceedOnFailureInd) {
            this.proceedOnFailureInd = proceedOnFailureInd;
        }
    }
    /** 
     * Pricing Parameters Notice.

    Note: Supports specifying transaction pricing parameters. Request messages may include indicators requesting that certain methods be applied during payment processing where relevant. Response messages may additionally include notice about if and how pricing parameters were applied during transaction processing.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingParameters" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AutoExchRequestInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="IncludeAwardRequestInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="AwardOnlyRequestInd"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="SimpleRequestInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PricingParameters implements Serializable
    {
        private Boolean autoExchRequestInd;
        private Boolean includeAwardRequestInd;
        private Boolean awardOnlyRequestInd;
        private Boolean simpleRequestInd;

        /** 
         * Get the 'AutoExchRequestInd' attribute value. When TRUE, this request is to be handled by an auto-exchange process
         * 
         * @return value
         */
        public Boolean getAutoExchRequestInd() {
            return autoExchRequestInd;
        }

        /** 
         * Set the 'AutoExchRequestInd' attribute value. When TRUE, this request is to be handled by an auto-exchange process
         * 
         * @param autoExchRequestInd
         */
        public void setAutoExchRequestInd(Boolean autoExchRequestInd) {
            this.autoExchRequestInd = autoExchRequestInd;
        }

        /** 
         * Get the 'IncludeAwardRequestInd' attribute value. When TRUE, award eligible in addition to priced offers and fares is requested.
         * 
         * @return value
         */
        public Boolean getIncludeAwardRequestInd() {
            return includeAwardRequestInd;
        }

        /** 
         * Set the 'IncludeAwardRequestInd' attribute value. When TRUE, award eligible in addition to priced offers and fares is requested.
         * 
         * @param includeAwardRequestInd
         */
        public void setIncludeAwardRequestInd(Boolean includeAwardRequestInd) {
            this.includeAwardRequestInd = includeAwardRequestInd;
        }

        /** 
         * Get the 'AwardOnlyRequestInd' attribute value. When TRUE, only award eligible offers/ fares are requested.
         * 
         * @return value
         */
        public Boolean getAwardOnlyRequestInd() {
            return awardOnlyRequestInd;
        }

        /** 
         * Set the 'AwardOnlyRequestInd' attribute value. When TRUE, only award eligible offers/ fares are requested.
         * 
         * @param awardOnlyRequestInd
         */
        public void setAwardOnlyRequestInd(Boolean awardOnlyRequestInd) {
            this.awardOnlyRequestInd = awardOnlyRequestInd;
        }

        /** 
         * Get the 'SimpleRequestInd' attribute value. When TRUE, Simple Pricing  for flight offers is requested.
         * 
         * @return value
         */
        public Boolean getSimpleRequestInd() {
            return simpleRequestInd;
        }

        /** 
         * Set the 'SimpleRequestInd' attribute value. When TRUE, Simple Pricing  for flight offers is requested.
         * 
         * @param simpleRequestInd
         */
        public void setSimpleRequestInd(Boolean simpleRequestInd) {
            this.simpleRequestInd = simpleRequestInd;
        }
    }
    /** 
     * Price Variance Rule(s) Notice.

    Note: Supports specifying the acceptable amount and/or percentage of the total amount by which the Order item price can vary from the Offer price for Order creation to proceed, for example to cover minor currency exchange rate fluctuations for taxes quoted in a different currency. 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVarianceRules" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PriceVarianceRule" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PriceVarianceRule -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="trxItemKey"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="VarianceRuleInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PriceVarianceRules implements Serializable
    {
        private List<PriceVarianceRule> priceVarianceRuleList = new ArrayList<PriceVarianceRule>();
        private String trxItemKey;
        private Boolean varianceRuleInd;

        /** 
         * Get the list of 'PriceVarianceRule' element items.
         * 
         * @return list
         */
        public List<PriceVarianceRule> getPriceVarianceRuleList() {
            return priceVarianceRuleList;
        }

        /** 
         * Set the list of 'PriceVarianceRule' element items.
         * 
         * @param list
         */
        public void setPriceVarianceRuleList(List<PriceVarianceRule> list) {
            priceVarianceRuleList = list;
        }

        /** 
         * Get the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
         * 
         * @return value
         */
        public String getTrxItemKey() {
            return trxItemKey;
        }

        /** 
         * Set the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
         * 
         * @param trxItemKey
         */
        public void setTrxItemKey(String trxItemKey) {
            this.trxItemKey = trxItemKey;
        }

        /** 
         * Get the 'VarianceRuleInd' attribute value. When TRUE, price variance rule(s) have been specified.
         * 
         * @return value
         */
        public Boolean getVarianceRuleInd() {
            return varianceRuleInd;
        }

        /** 
         * Set the 'VarianceRuleInd' attribute value. When TRUE, price variance rule(s) have been specified.
         * 
         * @param varianceRuleInd
         */
        public void setVarianceRuleInd(Boolean varianceRuleInd) {
            this.varianceRuleInd = varianceRuleInd;
        }
        /** 
         * Price Variance Rule detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVarianceRule" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
         *         &lt;xs:sequence>
         *           &lt;xs:element type="xs:string" name="SequenceNbr" minOccurs="0"/>
         *           &lt;xs:element name="RuleID" minOccurs="0">
         *             &lt;!-- Reference to inner class RuleID -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="AcceptableVariance">
         *             &lt;xs:complexType>
         *               &lt;xs:sequence>
         *                 &lt;xs:element ref="ns:PercentageValue"/>
         *                 &lt;xs:element ref="ns:CurrencyAmountValue"/>
         *               &lt;/xs:sequence>
         *             &lt;/xs:complexType>
         *           &lt;/xs:element>
         *           &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
         *           &lt;xs:element type="xs:string" name="Owner" minOccurs="0"/>
         *           &lt;xs:element name="RuleValid" minOccurs="0">
         *             &lt;!-- Reference to inner class RuleValid -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="Currencies" minOccurs="0">
         *             &lt;!-- Reference to inner class Currencies -->
         *           &lt;/xs:element>
         *           &lt;xs:element name="Associations" minOccurs="0">
         *             &lt;!-- Reference to inner class Associations -->
         *           &lt;/xs:element>
         *           &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceVarianceRule extends KeyWithMetaObjectBaseType
            implements Serializable
        {
            private String sequenceNbr;
            private RuleID ruleID;
            private PercentageValue acceptableVariancePercentageValue;
            private CurrencyAmountValue acceptableVarianceCurrencyAmountValue;
            private String name;
            private String owner;
            private RuleValid ruleValid;
            private Currencies currencies;
            private Associations associations;
            private Remarks remarks;

            /** 
             * Get the 'SequenceNbr' element value. Rule sequence (or order) number. Example: 1
             * 
             * @return value
             */
            public String getSequenceNbr() {
                return sequenceNbr;
            }

            /** 
             * Set the 'SequenceNbr' element value. Rule sequence (or order) number. Example: 1
             * 
             * @param sequenceNbr
             */
            public void setSequenceNbr(String sequenceNbr) {
                this.sequenceNbr = sequenceNbr;
            }

            /** 
             * Get the 'RuleID' element value.
             * 
             * @return value
             */
            public RuleID getRuleID() {
                return ruleID;
            }

            /** 
             * Set the 'RuleID' element value.
             * 
             * @param ruleID
             */
            public void setRuleID(RuleID ruleID) {
                this.ruleID = ruleID;
            }

            /** 
             * Get the 'PercentageValue' element value.
             * 
             * @return value
             */
            public PercentageValue getAcceptableVariancePercentageValue() {
                return acceptableVariancePercentageValue;
            }

            /** 
             * Set the 'PercentageValue' element value.
             * 
             * @param acceptableVariancePercentageValue
             */
            public void setAcceptableVariancePercentageValue(
                    PercentageValue acceptableVariancePercentageValue) {
                this.acceptableVariancePercentageValue = acceptableVariancePercentageValue;
            }

            /** 
             * Get the 'CurrencyAmountValue' element value.
             * 
             * @return value
             */
            public CurrencyAmountValue getAcceptableVarianceCurrencyAmountValue() {
                return acceptableVarianceCurrencyAmountValue;
            }

            /** 
             * Set the 'CurrencyAmountValue' element value.
             * 
             * @param acceptableVarianceCurrencyAmountValue
             */
            public void setAcceptableVarianceCurrencyAmountValue(
                    CurrencyAmountValue acceptableVarianceCurrencyAmountValue) {
                this.acceptableVarianceCurrencyAmountValue = acceptableVarianceCurrencyAmountValue;
            }

            /** 
             * Get the 'Name' element value. Rule Name. Example: Acceptable Price variance
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' element value. Rule Name. Example: Acceptable Price variance
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }

            /** 
             * Get the 'Owner' element value. Entity that owns/ assigned this Rule. Example: BA

            Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
             * 
             * @return value
             */
            public String getOwner() {
                return owner;
            }

            /** 
             * Set the 'Owner' element value. Entity that owns/ assigned this Rule. Example: BA

            Note: If this is an airline, the IATA/ A4A (two or three character) Airline Designator Code should be used.
             * 
             * @param owner
             */
            public void setOwner(String owner) {
                this.owner = owner;
            }

            /** 
             * Get the 'RuleValid' element value.
             * 
             * @return value
             */
            public RuleValid getRuleValid() {
                return ruleValid;
            }

            /** 
             * Set the 'RuleValid' element value.
             * 
             * @param ruleValid
             */
            public void setRuleValid(RuleValid ruleValid) {
                this.ruleValid = ruleValid;
            }

            /** 
             * Get the 'Currencies' element value.
             * 
             * @return value
             */
            public Currencies getCurrencies() {
                return currencies;
            }

            /** 
             * Set the 'Currencies' element value.
             * 
             * @param currencies
             */
            public void setCurrencies(Currencies currencies) {
                this.currencies = currencies;
            }

            /** 
             * Get the 'Associations' element value.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }

            /** 
             * Get the 'Remarks' element value.
             * 
             * @return value
             */
            public Remarks getRemarks() {
                return remarks;
            }

            /** 
             * Set the 'Remarks' element value.
             * 
             * @param remarks
             */
            public void setRemarks(Remarks remarks) {
                this.remarks = remarks;
            }
            /** 
             * Unique Rule ID.
            Example: PRICERULE001

            Note: Optional rule context and name may also be specified.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleID" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *         &lt;xs:attribute type="xs:anySimpleType" name="Name"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RuleID implements Serializable
            {
                private String string;
                private String context;
                private String name;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Rule ID Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Rule ID Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }

                /** 
                 * Get the 'Name' attribute value. Rule Name.
                Example: Acceptable Order Item Price Variance
                 * 
                 * @return value
                 */
                public String getName() {
                    return name;
                }

                /** 
                 * Set the 'Name' attribute value. Rule Name.
                Example: Acceptable Order Item Price Variance
                 * 
                 * @param name
                 */
                public void setName(String name) {
                    this.name = name;
                }
            }
            /** 
             * Rule Effective Period.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleValid" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:YearPeriod"/>
             *       &lt;xs:element ref="ns:YearMonthPeriod"/>
             *       &lt;xs:element ref="ns:TimePeriod"/>
             *       &lt;xs:element ref="ns:QuarterPeriod"/>
             *       &lt;xs:element ref="ns:MonthPeriod"/>
             *       &lt;xs:element ref="ns:DayPeriod"/>
             *       &lt;xs:element ref="ns:DateTimePeriod"/>
             *       &lt;xs:element ref="ns:DatePeriod"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RuleValid implements Serializable
            {
                private YearPeriodRepType yearPeriod;
                private YearMonthPeriodRepType yearMonthPeriod;
                private TimePeriodRepType timePeriod;
                private QuarterPeriodRepType quarterPeriod;
                private MonthPeriodRepType monthPeriod;
                private DayPeriodRepType dayPeriod;
                private DateTimePeriodRepType dateTimePeriod;
                private DatePeriodRepType datePeriod;

                /** 
                 * Get the 'YearPeriod' element value.
                 * 
                 * @return value
                 */
                public YearPeriodRepType getYearPeriod() {
                    return yearPeriod;
                }

                /** 
                 * Set the 'YearPeriod' element value.
                 * 
                 * @param yearPeriod
                 */
                public void setYearPeriod(YearPeriodRepType yearPeriod) {
                    this.yearPeriod = yearPeriod;
                }

                /** 
                 * Get the 'YearMonthPeriod' element value.
                 * 
                 * @return value
                 */
                public YearMonthPeriodRepType getYearMonthPeriod() {
                    return yearMonthPeriod;
                }

                /** 
                 * Set the 'YearMonthPeriod' element value.
                 * 
                 * @param yearMonthPeriod
                 */
                public void setYearMonthPeriod(
                        YearMonthPeriodRepType yearMonthPeriod) {
                    this.yearMonthPeriod = yearMonthPeriod;
                }

                /** 
                 * Get the 'TimePeriod' element value.
                 * 
                 * @return value
                 */
                public TimePeriodRepType getTimePeriod() {
                    return timePeriod;
                }

                /** 
                 * Set the 'TimePeriod' element value.
                 * 
                 * @param timePeriod
                 */
                public void setTimePeriod(TimePeriodRepType timePeriod) {
                    this.timePeriod = timePeriod;
                }

                /** 
                 * Get the 'QuarterPeriod' element value.
                 * 
                 * @return value
                 */
                public QuarterPeriodRepType getQuarterPeriod() {
                    return quarterPeriod;
                }

                /** 
                 * Set the 'QuarterPeriod' element value.
                 * 
                 * @param quarterPeriod
                 */
                public void setQuarterPeriod(QuarterPeriodRepType quarterPeriod) {
                    this.quarterPeriod = quarterPeriod;
                }

                /** 
                 * Get the 'MonthPeriod' element value.
                 * 
                 * @return value
                 */
                public MonthPeriodRepType getMonthPeriod() {
                    return monthPeriod;
                }

                /** 
                 * Set the 'MonthPeriod' element value.
                 * 
                 * @param monthPeriod
                 */
                public void setMonthPeriod(MonthPeriodRepType monthPeriod) {
                    this.monthPeriod = monthPeriod;
                }

                /** 
                 * Get the 'DayPeriod' element value.
                 * 
                 * @return value
                 */
                public DayPeriodRepType getDayPeriod() {
                    return dayPeriod;
                }

                /** 
                 * Set the 'DayPeriod' element value.
                 * 
                 * @param dayPeriod
                 */
                public void setDayPeriod(DayPeriodRepType dayPeriod) {
                    this.dayPeriod = dayPeriod;
                }

                /** 
                 * Get the 'DateTimePeriod' element value.
                 * 
                 * @return value
                 */
                public DateTimePeriodRepType getDateTimePeriod() {
                    return dateTimePeriod;
                }

                /** 
                 * Set the 'DateTimePeriod' element value.
                 * 
                 * @param dateTimePeriod
                 */
                public void setDateTimePeriod(
                        DateTimePeriodRepType dateTimePeriod) {
                    this.dateTimePeriod = dateTimePeriod;
                }

                /** 
                 * Get the 'DatePeriod' element value.
                 * 
                 * @return value
                 */
                public DatePeriodRepType getDatePeriod() {
                    return datePeriod;
                }

                /** 
                 * Set the 'DatePeriod' element value.
                 * 
                 * @param datePeriod
                 */
                public void setDatePeriod(DatePeriodRepType datePeriod) {
                    this.datePeriod = datePeriod;
                }
            }
            /** 
             * Rule-applicable Input and Settlement Currency(s).

            Note: This contains one or multiple input and settlement currency codes that this rule applies to. In addition to the specified currency code, an Application of InputCurrency and/ or SettlementCurrency should be specified.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Currencies" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:CurrencyCodeType" name="InputCode" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:CurrencyCodeType" name="SettlementCode" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Currencies implements Serializable
            {
                private List<CurrencyCodeType> inputCodeList = new ArrayList<CurrencyCodeType>();
                private List<CurrencyCodeType> settlementCodeList = new ArrayList<CurrencyCodeType>();

                /** 
                 * Get the list of 'InputCode' element items. Input Payment Currency code. Example: USD

                Encoding Scheme: ISO 4217 (three alpha character) Currency Code
                 * 
                 * @return list
                 */
                public List<CurrencyCodeType> getInputCodeList() {
                    return inputCodeList;
                }

                /** 
                 * Set the list of 'InputCode' element items. Input Payment Currency code. Example: USD

                Encoding Scheme: ISO 4217 (three alpha character) Currency Code
                 * 
                 * @param list
                 */
                public void setInputCodeList(List<CurrencyCodeType> list) {
                    inputCodeList = list;
                }

                /** 
                 * Get the list of 'SettlementCode' element items. Settlement Payment Currency code. Example: CHF

                Encoding Scheme: ISO 4217 (three alpha character) Currency Code
                 * 
                 * @return list
                 */
                public List<CurrencyCodeType> getSettlementCodeList() {
                    return settlementCodeList;
                }

                /** 
                 * Set the list of 'SettlementCode' element items. Settlement Payment Currency code. Example: CHF

                Encoding Scheme: ISO 4217 (three alpha character) Currency Code
                 * 
                 * @param list
                 */
                public void setSettlementCodeList(List<CurrencyCodeType> list) {
                    settlementCodeList = list;
                }
            }
            /** 
             * Association(s).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="OfferSetReferences" minOccurs="0"/>
             *       &lt;xs:element ref="ns:OfferItemID" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element name="Passengers" minOccurs="0">
             *         &lt;!-- Reference to inner class Passengers -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class OtherAssociation -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Associations implements Serializable
            {
                private String offerSetReferences;
                private List<OfferItemID> offerItemIDList = new ArrayList<OfferItemID>();
                private Passengers passengers;
                private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

                /** 
                 * Get the 'OfferSetReferences' element value. Associated Offer Set(s).
                 * 
                 * @return value
                 */
                public String getOfferSetReferences() {
                    return offerSetReferences;
                }

                /** 
                 * Set the 'OfferSetReferences' element value. Associated Offer Set(s).
                 * 
                 * @param offerSetReferences
                 */
                public void setOfferSetReferences(String offerSetReferences) {
                    this.offerSetReferences = offerSetReferences;
                }

                /** 
                 * Get the list of 'OfferItemID' element items. Associated Offer Item ID(s).
                Example: OFFER1226
                 * 
                 * @return list
                 */
                public List<OfferItemID> getOfferItemIDList() {
                    return offerItemIDList;
                }

                /** 
                 * Set the list of 'OfferItemID' element items. Associated Offer Item ID(s).
                Example: OFFER1226
                 * 
                 * @param list
                 */
                public void setOfferItemIDList(List<OfferItemID> list) {
                    offerItemIDList = list;
                }

                /** 
                 * Get the 'Passengers' element value.
                 * 
                 * @return value
                 */
                public Passengers getPassengers() {
                    return passengers;
                }

                /** 
                 * Set the 'Passengers' element value.
                 * 
                 * @param passengers
                 */
                public void setPassengers(Passengers passengers) {
                    this.passengers = passengers;
                }

                /** 
                 * Get the list of 'OtherAssociation' element items.
                 * 
                 * @return list
                 */
                public List<OtherAssociation> getOtherAssociationList() {
                    return otherAssociationList;
                }

                /** 
                 * Set the list of 'OtherAssociation' element items.
                 * 
                 * @param list
                 */
                public void setOtherAssociationList(List<OtherAssociation> list) {
                    otherAssociationList = list;
                }
                /** 
                 * Passenger(s)/ Group associated with the Offer Item.

                Note: This contains references to Passenger and Group instance(s) defined in the  Passengers node.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element ref="ns:PassengerReferences"/>
                 *       &lt;xs:element ref="ns:GroupReference"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Passengers implements Serializable
                {
                    private PassengerReferences passengerReferences;
                    private GroupReference groupReference;

                    /** 
                     * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @return value
                     */
                    public PassengerReferences getPassengerReferences() {
                        return passengerReferences;
                    }

                    /** 
                     * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                     * 
                     * @param passengerReferences
                     */
                    public void setPassengerReferences(
                            PassengerReferences passengerReferences) {
                        this.passengerReferences = passengerReferences;
                    }

                    /** 
                     * Get the 'GroupReference' element value.
                     * 
                     * @return value
                     */
                    public GroupReference getGroupReference() {
                        return groupReference;
                    }

                    /** 
                     * Set the 'GroupReference' element value.
                     * 
                     * @param groupReference
                     */
                    public void setGroupReference(GroupReference groupReference) {
                        this.groupReference = groupReference;
                    }
                }
                /** 
                 * Other Named Association(s).

                Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="ReferenceValue"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class OtherAssociation implements Serializable
                {
                    private String type;
                    private String referenceValue;

                    /** 
                     * Get the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @return value
                     */
                    public String getType() {
                        return type;
                    }

                    /** 
                     * Set the 'Type' attribute value. Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                     * 
                     * @param type
                     */
                    public void setType(String type) {
                        this.type = type;
                    }

                    /** 
                     * Get the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediagrp1
                     * 
                     * @return value
                     */
                    public String getReferenceValue() {
                        return referenceValue;
                    }

                    /** 
                     * Set the 'ReferenceValue' attribute value. Associated object instance value.
                    Example: mediagrp1
                     * 
                     * @param referenceValue
                     */
                    public void setReferenceValue(String referenceValue) {
                        this.referenceValue = referenceValue;
                    }
                }
            }
        }
    }
    /** 
     * Tax/ Fee Exemption Notice.

    Note: Supports notification to receiving system that tax/ fee exemptions are requested during transaction processing, and, if and how the exemptions were applied to message results.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxExemptionRules" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Named" minOccurs="0">
     *         &lt;!-- Reference to inner class Named -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:RuleSetType" name="Rules" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="trxItemKey"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="ExemptAllInd"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TaxExemptionRules implements Serializable
    {
        private Named named;
        private RuleSetType rules;
        private String trxItemKey;
        private Boolean exemptAllInd;

        /** 
         * Get the 'Named' element value.
         * 
         * @return value
         */
        public Named getNamed() {
            return named;
        }

        /** 
         * Set the 'Named' element value.
         * 
         * @param named
         */
        public void setNamed(Named named) {
            this.named = named;
        }

        /** 
         * Get the 'Rules' element value. Additional Tax Exemption Rule(s).
         * 
         * @return value
         */
        public RuleSetType getRules() {
            return rules;
        }

        /** 
         * Set the 'Rules' element value. Additional Tax Exemption Rule(s).
         * 
         * @param rules
         */
        public void setRules(RuleSetType rules) {
            this.rules = rules;
        }

        /** 
         * Get the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
         * 
         * @return value
         */
        public String getTrxItemKey() {
            return trxItemKey;
        }

        /** 
         * Set the 'trxItemKey' attribute value. Globally unique id for this Transaction Processing object instance.
         * 
         * @param trxItemKey
         */
        public void setTrxItemKey(String trxItemKey) {
            this.trxItemKey = trxItemKey;
        }

        /** 
         * Get the 'ExemptAllInd' attribute value. When TRUE, all pricing is tax/ fee exempt.
         * 
         * @return value
         */
        public Boolean getExemptAllInd() {
            return exemptAllInd;
        }

        /** 
         * Set the 'ExemptAllInd' attribute value. When TRUE, all pricing is tax/ fee exempt.
         * 
         * @param exemptAllInd
         */
        public void setExemptAllInd(Boolean exemptAllInd) {
            this.exemptAllInd = exemptAllInd;
        }
        /** 
         * Named Tax Exemptions, including Country(s), Entity(s), Territory(s) and Tax Code(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Named" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Countries" minOccurs="0">
         *         &lt;!-- Reference to inner class Countries -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Entities" minOccurs="0">
         *         &lt;!-- Reference to inner class Entities -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Territories" minOccurs="0">
         *         &lt;!-- Reference to inner class Territories -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TaxCodes" minOccurs="0">
         *         &lt;!-- Reference to inner class TaxCodes -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Named implements Serializable
        {
            private Countries countries;
            private Entities entities;
            private Territories territories;
            private TaxCodes taxCodes;

            /** 
             * Get the 'Countries' element value.
             * 
             * @return value
             */
            public Countries getCountries() {
                return countries;
            }

            /** 
             * Set the 'Countries' element value.
             * 
             * @param countries
             */
            public void setCountries(Countries countries) {
                this.countries = countries;
            }

            /** 
             * Get the 'Entities' element value.
             * 
             * @return value
             */
            public Entities getEntities() {
                return entities;
            }

            /** 
             * Set the 'Entities' element value.
             * 
             * @param entities
             */
            public void setEntities(Entities entities) {
                this.entities = entities;
            }

            /** 
             * Get the 'Territories' element value.
             * 
             * @return value
             */
            public Territories getTerritories() {
                return territories;
            }

            /** 
             * Set the 'Territories' element value.
             * 
             * @param territories
             */
            public void setTerritories(Territories territories) {
                this.territories = territories;
            }

            /** 
             * Get the 'TaxCodes' element value.
             * 
             * @return value
             */
            public TaxCodes getTaxCodes() {
                return taxCodes;
            }

            /** 
             * Set the 'TaxCodes' element value.
             * 
             * @param taxCodes
             */
            public void setTaxCodes(TaxCodes taxCodes) {
                this.taxCodes = taxCodes;
            }
            /** 
             * Exempt tax country information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Countries" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element ref="ns:CountryCode" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Countries implements Serializable
            {
                private List<CountryCodeType> countryCodeList = new ArrayList<CountryCodeType>();

                /** 
                 * Get the list of 'CountryCode' element items.
                 * 
                 * @return list
                 */
                public List<CountryCodeType> getCountryCodeList() {
                    return countryCodeList;
                }

                /** 
                 * Set the list of 'CountryCode' element items.
                 * 
                 * @param list
                 */
                public void setCountryCodeList(List<CountryCodeType> list) {
                    countryCodeList = list;
                }
            }
            /** 
             * Fee/ Tax Exempt Entity(s).

            Note: Includes companies and government bodies.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Entities" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Entity" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Entities implements Serializable
            {
                private List<String> entityList = new ArrayList<String>();

                /** 
                 * Get the list of 'Entity' element items. Exempt tax entity name.  Example: Military, IBM
                 * 
                 * @return list
                 */
                public List<String> getEntityList() {
                    return entityList;
                }

                /** 
                 * Set the list of 'Entity' element items. Exempt tax entity name.  Example: Military, IBM
                 * 
                 * @param list
                 */
                public void setEntityList(List<String> list) {
                    entityList = list;
                }
            }
            /** 
             * Exempt tax province/ territory information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Territories" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="Territory" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Territories implements Serializable
            {
                private List<String> territoryList = new ArrayList<String>();

                /** 
                 * Get the list of 'Territory' element items. Exempt tax province/  territory name or code.  Example: QC
                 * 
                 * @return list
                 */
                public List<String> getTerritoryList() {
                    return territoryList;
                }

                /** 
                 * Set the list of 'Territory' element items. Exempt tax province/  territory name or code.  Example: QC
                 * 
                 * @param list
                 */
                public void setTerritoryList(List<String> list) {
                    territoryList = list;
                }
            }
            /** 
             * Exempt Tax Code(s).

            Note: This contains tax exemption(s) based on tax designator and nature.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxCodes" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TaxCode" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class TaxCode -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TaxCodes implements Serializable
            {
                private List<TaxCode> taxCodeList = new ArrayList<TaxCode>();

                /** 
                 * Get the list of 'TaxCode' element items.
                 * 
                 * @return list
                 */
                public List<TaxCode> getTaxCodeList() {
                    return taxCodeList;
                }

                /** 
                 * Set the list of 'TaxCode' element items.
                 * 
                 * @param list
                 */
                public void setTaxCodeList(List<TaxCode> list) {
                    taxCodeList = list;
                }
                /** 
                 * Tax Code detail.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxCode" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element type="xs:string" name="Designator"/>
                 *       &lt;xs:element type="xs:string" name="Nature" minOccurs="0"/>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TaxCode implements Serializable
                {
                    private String designator;
                    private String nature;

                    /** 
                     * Get the 'Designator' element value. Tax designator. Example: XY
                     * 
                     * @return value
                     */
                    public String getDesignator() {
                        return designator;
                    }

                    /** 
                     * Set the 'Designator' element value. Tax designator. Example: XY
                     * 
                     * @param designator
                     */
                    public void setDesignator(String designator) {
                        this.designator = designator;
                    }

                    /** 
                     * Get the 'Nature' element value. Tax nature. Example: I
                     * 
                     * @return value
                     */
                    public String getNature() {
                        return nature;
                    }

                    /** 
                     * Set the 'Nature' element value. Tax nature. Example: I
                     * 
                     * @param nature
                     */
                    public void setNature(String nature) {
                        this.nature = nature;
                    }
                }
            }
        }
    }
}
