
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 *  Alerts definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrdRetrieveAlertsType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:PinPhraseAnswerType" name="PIN_AuthResponse" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrdRetrieveAlertsType extends AssociatedObjectBaseType implements
    Serializable
{
    private PinPhraseAnswerType PINAuthResponse;

    /** 
     * Get the 'PIN_AuthResponse' element value. Traveler PIN Phrase Authentication Response.

    Notes:
    1. This is part of an ongoing transaction for a processing condition that occured when additional Traveler authentication was required to complete transaction processing, such as access to secure FQTV information to complete Order amendment.
    2. This information contains the authentication scheme response information, e.g. the Pin Phrase answer.
     * 
     * @return value
     */
    public PinPhraseAnswerType getPINAuthResponse() {
        return PINAuthResponse;
    }

    /** 
     * Set the 'PIN_AuthResponse' element value. Traveler PIN Phrase Authentication Response.

    Notes:
    1. This is part of an ongoing transaction for a processing condition that occured when additional Traveler authentication was required to complete transaction processing, such as access to secure FQTV information to complete Order amendment.
    2. This information contains the authentication scheme response information, e.g. the Pin Phrase answer.
     * 
     * @param PINAuthResponse
     */
    public void setPINAuthResponse(PinPhraseAnswerType PINAuthResponse) {
        this.PINAuthResponse = PINAuthResponse;
    }
}
