
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderCancel transaction set requests the cancellation of a specified order, and returns confirmation of cancellation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderCancelRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element ref="ns:OrderCancelParameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element ref="ns:OrderID" minOccurs="0" maxOccurs="unbounded"/>
 *             &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderCancelRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private OrdCancelParamsType orderCancelParameters;
    private List<OrderIDType> queryOrderIDList = new ArrayList<OrderIDType>();
    private BookingReferences queryBookingReferences;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'OrderCancelParameters' element value.
     * 
     * @return value
     */
    public OrdCancelParamsType getOrderCancelParameters() {
        return orderCancelParameters;
    }

    /** 
     * Set the 'OrderCancelParameters' element value.
     * 
     * @param orderCancelParameters
     */
    public void setOrderCancelParameters(
            OrdCancelParamsType orderCancelParameters) {
        this.orderCancelParameters = orderCancelParameters;
    }

    /** 
     * Get the list of 'OrderID' element items.
     * 
     * @return list
     */
    public List<OrderIDType> getQueryOrderIDList() {
        return queryOrderIDList;
    }

    /** 
     * Set the list of 'OrderID' element items.
     * 
     * @param list
     */
    public void setQueryOrderIDList(List<OrderIDType> list) {
        queryOrderIDList = list;
    }

    /** 
     * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
}
