
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * CORE ORDER definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderCoreType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:OrderID"/>
 *         &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *         &lt;xs:element name="OriginalOrder" minOccurs="0">
 *           &lt;!-- Reference to inner class OriginalOrder -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="TotalOrderPrice" minOccurs="0">
 *           &lt;!-- Reference to inner class TotalOrderPrice -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Payments" minOccurs="0">
 *           &lt;!-- Reference to inner class Payments -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="TimeLimits" minOccurs="0">
 *           &lt;!-- Reference to inner class TimeLimits -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:OrderKeys" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="TotalOrderItemQuantity" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderCoreType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private OrderIDType orderID;
    private BookingReferences bookingReferences;
    private OriginalOrder originalOrder;
    private TotalOrderPrice totalOrderPrice;
    private Payments payments;
    private TimeLimits timeLimits;
    private OrderKeysType orderKeys;
    private String totalOrderItemQuantity;

    /** 
     * Get the 'OrderID' element value.
     * 
     * @return value
     */
    public OrderIDType getOrderID() {
        return orderID;
    }

    /** 
     * Set the 'OrderID' element value.
     * 
     * @param orderID
     */
    public void setOrderID(OrderIDType orderID) {
        this.orderID = orderID;
    }

    /** 
     * Get the 'BookingReferences' element value.
     * 
     * @return value
     */
    public BookingReferences getBookingReferences() {
        return bookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value.
     * 
     * @param bookingReferences
     */
    public void setBookingReferences(BookingReferences bookingReferences) {
        this.bookingReferences = bookingReferences;
    }

    /** 
     * Get the 'OriginalOrder' element value.
     * 
     * @return value
     */
    public OriginalOrder getOriginalOrder() {
        return originalOrder;
    }

    /** 
     * Set the 'OriginalOrder' element value.
     * 
     * @param originalOrder
     */
    public void setOriginalOrder(OriginalOrder originalOrder) {
        this.originalOrder = originalOrder;
    }

    /** 
     * Get the 'TotalOrderPrice' element value.
     * 
     * @return value
     */
    public TotalOrderPrice getTotalOrderPrice() {
        return totalOrderPrice;
    }

    /** 
     * Set the 'TotalOrderPrice' element value.
     * 
     * @param totalOrderPrice
     */
    public void setTotalOrderPrice(TotalOrderPrice totalOrderPrice) {
        this.totalOrderPrice = totalOrderPrice;
    }

    /** 
     * Get the 'Payments' element value.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        this.payments = payments;
    }

    /** 
     * Get the 'TimeLimits' element value.
     * 
     * @return value
     */
    public TimeLimits getTimeLimits() {
        return timeLimits;
    }

    /** 
     * Set the 'TimeLimits' element value.
     * 
     * @param timeLimits
     */
    public void setTimeLimits(TimeLimits timeLimits) {
        this.timeLimits = timeLimits;
    }

    /** 
     * Get the 'OrderKeys' element value.
     * 
     * @return value
     */
    public OrderKeysType getOrderKeys() {
        return orderKeys;
    }

    /** 
     * Set the 'OrderKeys' element value.
     * 
     * @param orderKeys
     */
    public void setOrderKeys(OrderKeysType orderKeys) {
        this.orderKeys = orderKeys;
    }

    /** 
     * Get the 'TotalOrderItemQuantity' element value. The total number of Order Items included in this Order. Example: 3
     * 
     * @return value
     */
    public String getTotalOrderItemQuantity() {
        return totalOrderItemQuantity;
    }

    /** 
     * Set the 'TotalOrderItemQuantity' element value. The total number of Order Items included in this Order. Example: 3
     * 
     * @param totalOrderItemQuantity
     */
    public void setTotalOrderItemQuantity(String totalOrderItemQuantity) {
        this.totalOrderItemQuantity = totalOrderItemQuantity;
    }
    /** 
     * This may be used when an Order has been sub-divided into associated Orders (eg because a change creates non-homogeneity in a PNR), and serves as a cross reference for the original Order ID.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalOrder" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OrderID_Type" name="OriginalOrderID"/>
     *       &lt;xs:element name="PriceQuotes" minOccurs="0">
     *         &lt;!-- Reference to inner class PriceQuotes -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OriginalOrder implements Serializable
    {
        private OrderIDType originalOrderID;
        private PriceQuotes priceQuotes;

        /** 
         * Get the 'OriginalOrderID' element value. The Original airline-assigned unique Order ID. Example: ORDER-q988-ac01-a20b


         * 
         * @return value
         */
        public OrderIDType getOriginalOrderID() {
            return originalOrderID;
        }

        /** 
         * Set the 'OriginalOrderID' element value. The Original airline-assigned unique Order ID. Example: ORDER-q988-ac01-a20b


         * 
         * @param originalOrderID
         */
        public void setOriginalOrderID(OrderIDType originalOrderID) {
            this.originalOrderID = originalOrderID;
        }

        /** 
         * Get the 'PriceQuotes' element value.
         * 
         * @return value
         */
        public PriceQuotes getPriceQuotes() {
            return priceQuotes;
        }

        /** 
         * Set the 'PriceQuotes' element value.
         * 
         * @param priceQuotes
         */
        public void setPriceQuotes(PriceQuotes priceQuotes) {
            this.priceQuotes = priceQuotes;
        }
        /** 
         * This is pertinent information for an order change involving re-pricing as it provides the order pricing history e.g. indicating that an order has already been priced a number of times and the pricing source and history. 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuotes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="PriceQuote" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PriceQuote -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriceQuotes implements Serializable
        {
            private List<PriceQuote> priceQuoteList = new ArrayList<PriceQuote>();

            /** 
             * Get the list of 'PriceQuote' element items.
             * 
             * @return list
             */
            public List<PriceQuote> getPriceQuoteList() {
                return priceQuoteList;
            }

            /** 
             * Set the list of 'PriceQuote' element items.
             * 
             * @param list
             */
            public void setPriceQuoteList(List<PriceQuote> list) {
                priceQuoteList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuote" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Amount">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element ref="ns:CurrencyAmount"/>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="Source">
             *         &lt;xs:complexType>
             *           &lt;xs:attribute type="xs:anySimpleType" name="Owner"/>
             *           &lt;xs:attribute type="xs:anySimpleType" name="Reference"/>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element ref="ns:Commission"/>
             *       &lt;xs:element ref="ns:PriceGuaranteeTimeLimit"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:anySimpleType" name="CreatedDate"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PriceQuote implements Serializable
            {
                private CurrencyAmount amount;
                private String sourceOwner;
                private String sourceReference;
                private Commission commission;
                private PriceGuaranteeTimeLimit priceGuaranteeTimeLimit;
                private String createdDate;

                /** 
                 * Get the 'CurrencyAmount' element value. Payment Amount
                 * 
                 * @return value
                 */
                public CurrencyAmount getAmount() {
                    return amount;
                }

                /** 
                 * Set the 'CurrencyAmount' element value. Payment Amount
                 * 
                 * @param amount
                 */
                public void setAmount(CurrencyAmount amount) {
                    this.amount = amount;
                }

                /** 
                 * Get the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

                Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
                 * 
                 * @return value
                 */
                public String getSourceOwner() {
                    return sourceOwner;
                }

                /** 
                 * Set the 'Owner' attribute value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA

                Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
                 * 
                 * @param sourceOwner
                 */
                public void setSourceOwner(String sourceOwner) {
                    this.sourceOwner = sourceOwner;
                }

                /** 
                 * Get the 'Reference' attribute value.
                 * 
                 * @return value
                 */
                public String getSourceReference() {
                    return sourceReference;
                }

                /** 
                 * Set the 'Reference' attribute value.
                 * 
                 * @param sourceReference
                 */
                public void setSourceReference(String sourceReference) {
                    this.sourceReference = sourceReference;
                }

                /** 
                 * Get the 'Commission' element value.
                 * 
                 * @return value
                 */
                public Commission getCommission() {
                    return commission;
                }

                /** 
                 * Set the 'Commission' element value.
                 * 
                 * @param commission
                 */
                public void setCommission(Commission commission) {
                    this.commission = commission;
                }

                /** 
                 * Get the 'PriceGuaranteeTimeLimit' element value.
                 * 
                 * @return value
                 */
                public PriceGuaranteeTimeLimit getPriceGuaranteeTimeLimit() {
                    return priceGuaranteeTimeLimit;
                }

                /** 
                 * Set the 'PriceGuaranteeTimeLimit' element value.
                 * 
                 * @param priceGuaranteeTimeLimit
                 */
                public void setPriceGuaranteeTimeLimit(
                        PriceGuaranteeTimeLimit priceGuaranteeTimeLimit) {
                    this.priceGuaranteeTimeLimit = priceGuaranteeTimeLimit;
                }

                /** 
                 * Get the 'CreatedDate' attribute value. Order creation timestamp.
                Example: 2015-01-13T13:59:38Z
                 * 
                 * @return value
                 */
                public String getCreatedDate() {
                    return createdDate;
                }

                /** 
                 * Set the 'CreatedDate' attribute value. Order creation timestamp.
                Example: 2015-01-13T13:59:38Z
                 * 
                 * @param createdDate
                 */
                public void setCreatedDate(String createdDate) {
                    this.createdDate = createdDate;
                }
            }
        }
    }
    /** 
     * Total Order Price. Example: 3400 USD

    Note: This is a sub-total of all associated Order Item prices.Currency, Redemption and Partial Pricing
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalOrderPrice" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:AwardPricing"/>
     *       &lt;xs:element ref="ns:CombinationPricing"/>
     *       &lt;xs:element ref="ns:DetailCurrencyPrice"/>
     *       &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
     *       &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalOrderPrice implements Serializable
    {
        private int totalOrderPriceSelect = -1;
        private static final int AWARD_PRICING_CHOICE = 0;
        private static final int COMBINATION_PRICING_CHOICE = 1;
        private static final int DETAIL_CURRENCY_PRICE_CHOICE = 2;
        private static final int ENCODED_CURRENCY_PRICE_CHOICE = 3;
        private static final int SIMPLE_CURRENCY_PRICE_CHOICE = 4;
        private AwardPriceUnitType awardPricing;
        private CombinationPriceType combinationPricing;
        private DetailCurrencyPriceType detailCurrencyPrice;
        private EncodedCurrencyPrice encodedCurrencyPrice;
        private SimpleCurrencyPrice simpleCurrencyPrice;

        private void setTotalOrderPriceSelect(int choice) {
            if (totalOrderPriceSelect == -1) {
                totalOrderPriceSelect = choice;
            } else if (totalOrderPriceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearTotalOrderPriceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearTotalOrderPriceSelect() {
            totalOrderPriceSelect = -1;
        }

        /** 
         * Check if AwardPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAwardPricing() {
            return totalOrderPriceSelect == AWARD_PRICING_CHOICE;
        }

        /** 
         * Get the 'AwardPricing' element value.
         * 
         * @return value
         */
        public AwardPriceUnitType getAwardPricing() {
            return awardPricing;
        }

        /** 
         * Set the 'AwardPricing' element value.
         * 
         * @param awardPricing
         */
        public void setAwardPricing(AwardPriceUnitType awardPricing) {
            setTotalOrderPriceSelect(AWARD_PRICING_CHOICE);
            this.awardPricing = awardPricing;
        }

        /** 
         * Check if CombinationPricing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCombinationPricing() {
            return totalOrderPriceSelect == COMBINATION_PRICING_CHOICE;
        }

        /** 
         * Get the 'CombinationPricing' element value.
         * 
         * @return value
         */
        public CombinationPriceType getCombinationPricing() {
            return combinationPricing;
        }

        /** 
         * Set the 'CombinationPricing' element value.
         * 
         * @param combinationPricing
         */
        public void setCombinationPricing(
                CombinationPriceType combinationPricing) {
            setTotalOrderPriceSelect(COMBINATION_PRICING_CHOICE);
            this.combinationPricing = combinationPricing;
        }

        /** 
         * Check if DetailCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDetailCurrencyPrice() {
            return totalOrderPriceSelect == DETAIL_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'DetailCurrencyPrice' element value.
         * 
         * @return value
         */
        public DetailCurrencyPriceType getDetailCurrencyPrice() {
            return detailCurrencyPrice;
        }

        /** 
         * Set the 'DetailCurrencyPrice' element value.
         * 
         * @param detailCurrencyPrice
         */
        public void setDetailCurrencyPrice(
                DetailCurrencyPriceType detailCurrencyPrice) {
            setTotalOrderPriceSelect(DETAIL_CURRENCY_PRICE_CHOICE);
            this.detailCurrencyPrice = detailCurrencyPrice;
        }

        /** 
         * Check if EncodedCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEncodedCurrencyPrice() {
            return totalOrderPriceSelect == ENCODED_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'EncodedCurrencyPrice' element value.
         * 
         * @return value
         */
        public EncodedCurrencyPrice getEncodedCurrencyPrice() {
            return encodedCurrencyPrice;
        }

        /** 
         * Set the 'EncodedCurrencyPrice' element value.
         * 
         * @param encodedCurrencyPrice
         */
        public void setEncodedCurrencyPrice(
                EncodedCurrencyPrice encodedCurrencyPrice) {
            setTotalOrderPriceSelect(ENCODED_CURRENCY_PRICE_CHOICE);
            this.encodedCurrencyPrice = encodedCurrencyPrice;
        }

        /** 
         * Check if SimpleCurrencyPrice is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSimpleCurrencyPrice() {
            return totalOrderPriceSelect == SIMPLE_CURRENCY_PRICE_CHOICE;
        }

        /** 
         * Get the 'SimpleCurrencyPrice' element value.
         * 
         * @return value
         */
        public SimpleCurrencyPrice getSimpleCurrencyPrice() {
            return simpleCurrencyPrice;
        }

        /** 
         * Set the 'SimpleCurrencyPrice' element value.
         * 
         * @param simpleCurrencyPrice
         */
        public void setSimpleCurrencyPrice(
                SimpleCurrencyPrice simpleCurrencyPrice) {
            setTotalOrderPriceSelect(SIMPLE_CURRENCY_PRICE_CHOICE);
            this.simpleCurrencyPrice = simpleCurrencyPrice;
        }
    }
    /** 
     * Payment Processing information.

    Note: This payment information applies to the entire Order. Note that it may also be specified at the Order Item level.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:PaymentProcessType" name="Payment" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private List<PaymentProcessType> paymentList = new ArrayList<PaymentProcessType>();

        /** 
         * Get the list of 'Payment' element items. Payment Processing detail.
         * 
         * @return list
         */
        public List<PaymentProcessType> getPaymentList() {
            return paymentList;
        }

        /** 
         * Set the list of 'Payment' element items. Payment Processing detail.
         * 
         * @param list
         */
        public void setPaymentList(List<PaymentProcessType> list) {
            paymentList = list;
        }
    }
    /** 
     * Order-Level Time Limits.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeLimits" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PaymentTimeLimit" minOccurs="0">
     *         &lt;!-- Reference to inner class PaymentTimeLimit -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:DepositTimeLimit" minOccurs="0"/>
     *       &lt;xs:element ref="ns:NamingTimeLimit" minOccurs="0"/>
     *       &lt;xs:element ref="ns:BilateralTimeLimits" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TimeLimits implements Serializable
    {
        private PaymentTimeLimit paymentTimeLimit;
        private DepositTimeLimit depositTimeLimit;
        private NamingTimeLimit namingTimeLimit;
        private BilateralTimeLimitsType bilateralTimeLimits;

        /** 
         * Get the 'PaymentTimeLimit' element value.
         * 
         * @return value
         */
        public PaymentTimeLimit getPaymentTimeLimit() {
            return paymentTimeLimit;
        }

        /** 
         * Set the 'PaymentTimeLimit' element value.
         * 
         * @param paymentTimeLimit
         */
        public void setPaymentTimeLimit(PaymentTimeLimit paymentTimeLimit) {
            this.paymentTimeLimit = paymentTimeLimit;
        }

        /** 
         * Get the 'DepositTimeLimit' element value.
         * 
         * @return value
         */
        public DepositTimeLimit getDepositTimeLimit() {
            return depositTimeLimit;
        }

        /** 
         * Set the 'DepositTimeLimit' element value.
         * 
         * @param depositTimeLimit
         */
        public void setDepositTimeLimit(DepositTimeLimit depositTimeLimit) {
            this.depositTimeLimit = depositTimeLimit;
        }

        /** 
         * Get the 'NamingTimeLimit' element value.
         * 
         * @return value
         */
        public NamingTimeLimit getNamingTimeLimit() {
            return namingTimeLimit;
        }

        /** 
         * Set the 'NamingTimeLimit' element value.
         * 
         * @param namingTimeLimit
         */
        public void setNamingTimeLimit(NamingTimeLimit namingTimeLimit) {
            this.namingTimeLimit = namingTimeLimit;
        }

        /** 
         * Get the 'BilateralTimeLimits' element value.
         * 
         * @return value
         */
        public BilateralTimeLimitsType getBilateralTimeLimits() {
            return bilateralTimeLimits;
        }

        /** 
         * Set the 'BilateralTimeLimits' element value.
         * 
         * @param bilateralTimeLimits
         */
        public void setBilateralTimeLimits(
                BilateralTimeLimitsType bilateralTimeLimits) {
            this.bilateralTimeLimits = bilateralTimeLimits;
        }
        /** 
         * Payment Time Limit value.
        Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

        Notes:
        1. This is the deadline by which a commitment to pay must be made for the confirmed items in an offer as agreed witht he airline. The passenger meets this requirement by making complete payment for the order. 
        
        2. Payment Time Limit and Ticket Time Limit may be the same in most cases; however, Payment Time Limit expands to include ticketless transactions and other accountable documents.

        3. This time limit is at the OFFER-LEVEL and will apply to all (child) Offer Items.Although specified as mandatory in the BRD, there may be a case where Payment is already provided in the Order information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentTimeLimit" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:CoreDateGrpType">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class PaymentTimeLimit extends CoreDateGrpType implements
            Serializable
        {
            private String refs;

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
}
