
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The OrderCreate/ OrderView transaction is a multi-function message that may:

 1) Request specified inventory to be held (and returns a reference to the held inventory)

 2) Request that an order to be created (returning the complete view of the Order)

 3) Request additions to order data elements (e.g. add frequent flyer data)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderCreateRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element ref="ns:OrderCreateParameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Passengers">
 *               &lt;xs:complexType>
 *                 &lt;xs:sequence>
 *                   &lt;xs:element ref="ns:Passenger" minOccurs="0" maxOccurs="unbounded"/>
 *                   &lt;xs:element type="ns:GroupType" name="Group" minOccurs="0"/>
 *                 &lt;/xs:sequence>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element name="OrderItems">
 *               &lt;xs:complexType>
 *                 &lt;xs:sequence>
 *                   &lt;xs:element type="ns:ShoppingResponseOrderType" name="ShoppingResponse"/>
 *                   &lt;xs:element type="ns:OrderOfferItemType" name="OfferItem" minOccurs="0" maxOccurs="unbounded"/>
 *                 &lt;/xs:sequence>
 *                 &lt;xs:attribute type="xs:string" use="optional" name="OfferItemQuantity"/>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *             &lt;xs:element name="Payments" minOccurs="0">
 *               &lt;!-- Reference to inner class Payments -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="Promotions" minOccurs="0">
 *               &lt;!-- Reference to inner class Promotions -->
 *             &lt;/xs:element>
 *             &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0"/>
 *             &lt;xs:element ref="ns:BookingReferences" minOccurs="0"/>
 *             &lt;xs:element type="ns:DataListType" name="DataLists" minOccurs="0"/>
 *             &lt;xs:element type="ns:OrdCreateMetadataType" name="Metadata" minOccurs="0"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderCreateRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private OrdCreateParamsType orderCreateParameters;
    private List<Passenger> queryPassengerList = new ArrayList<Passenger>();
    private GroupType queryGroup;
    private ShoppingResponseOrderType queryOrderItemsShoppingResponse;
    private List<OrderOfferItemType> queryOrderItemsOfferItemList = new ArrayList<OrderOfferItemType>();
    private String queryOrderItemsOfferItemQuantity;
    private Payments payments;
    private Promotions promotions;
    private CommissionType queryCommission;
    private BookingReferences queryBookingReferences;
    private DataListType queryDataLists;
    private OrdCreateMetadataType queryMetadata;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'OrderCreateParameters' element value.
     * 
     * @return value
     */
    public OrdCreateParamsType getOrderCreateParameters() {
        return orderCreateParameters;
    }

    /** 
     * Set the 'OrderCreateParameters' element value.
     * 
     * @param orderCreateParameters
     */
    public void setOrderCreateParameters(
            OrdCreateParamsType orderCreateParameters) {
        this.orderCreateParameters = orderCreateParameters;
    }

    /** 
     * Get the list of 'Passenger' element items.
     * 
     * @return list
     */
    public List<Passenger> getQueryPassengerList() {
        return queryPassengerList;
    }

    /** 
     * Set the list of 'Passenger' element items.
     * 
     * @param list
     */
    public void setQueryPassengerList(List<Passenger> list) {
        queryPassengerList = list;
    }

    /** 
     * Get the 'Group' element value. Group Information.
     * 
     * @return value
     */
    public GroupType getQueryGroup() {
        return queryGroup;
    }

    /** 
     * Set the 'Group' element value. Group Information.
     * 
     * @param queryGroup
     */
    public void setQueryGroup(GroupType queryGroup) {
        this.queryGroup = queryGroup;
    }

    /** 
     * Get the 'ShoppingResponse' element value. Shopping Response ID(s).
     * 
     * @return value
     */
    public ShoppingResponseOrderType getQueryOrderItemsShoppingResponse() {
        return queryOrderItemsShoppingResponse;
    }

    /** 
     * Set the 'ShoppingResponse' element value. Shopping Response ID(s).
     * 
     * @param queryOrderItemsShoppingResponse
     */
    public void setQueryOrderItemsShoppingResponse(
            ShoppingResponseOrderType queryOrderItemsShoppingResponse) {
        this.queryOrderItemsShoppingResponse = queryOrderItemsShoppingResponse;
    }

    /** 
     * Get the list of 'OfferItem' element items. Offer Item(s) that comprise the Order Item.
     * 
     * @return list
     */
    public List<OrderOfferItemType> getQueryOrderItemsOfferItemList() {
        return queryOrderItemsOfferItemList;
    }

    /** 
     * Set the list of 'OfferItem' element items. Offer Item(s) that comprise the Order Item.
     * 
     * @param list
     */
    public void setQueryOrderItemsOfferItemList(List<OrderOfferItemType> list) {
        queryOrderItemsOfferItemList = list;
    }

    /** 
     * Get the 'OfferItemQuantity' attribute value. Total quantity of Order Items included in the order.
     * 
     * @return value
     */
    public String getQueryOrderItemsOfferItemQuantity() {
        return queryOrderItemsOfferItemQuantity;
    }

    /** 
     * Set the 'OfferItemQuantity' attribute value. Total quantity of Order Items included in the order.
     * 
     * @param queryOrderItemsOfferItemQuantity
     */
    public void setQueryOrderItemsOfferItemQuantity(
            String queryOrderItemsOfferItemQuantity) {
        this.queryOrderItemsOfferItemQuantity = queryOrderItemsOfferItemQuantity;
    }

    /** 
     * Get the 'Payments' element value. Order Create Query.
     * 
     * @return value
     */
    public Payments getPayments() {
        return payments;
    }

    /** 
     * Set the 'Payments' element value. Order Create Query.
     * 
     * @param payments
     */
    public void setPayments(Payments payments) {
        this.payments = payments;
    }

    /** 
     * Get the 'Promotions' element value. Order Create Query.
     * 
     * @return value
     */
    public Promotions getPromotions() {
        return promotions;
    }

    /** 
     * Set the 'Promotions' element value. Order Create Query.
     * 
     * @param promotions
     */
    public void setPromotions(Promotions promotions) {
        this.promotions = promotions;
    }

    /** 
     * Get the 'Commission' element value. Commission information
     * 
     * @return value
     */
    public CommissionType getQueryCommission() {
        return queryCommission;
    }

    /** 
     * Set the 'Commission' element value. Commission information
     * 
     * @param queryCommission
     */
    public void setQueryCommission(CommissionType queryCommission) {
        this.queryCommission = queryCommission;
    }

    /** 
     * Get the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferences getQueryBookingReferences() {
        return queryBookingReferences;
    }

    /** 
     * Set the 'BookingReferences' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param queryBookingReferences
     */
    public void setQueryBookingReferences(
            BookingReferences queryBookingReferences) {
        this.queryBookingReferences = queryBookingReferences;
    }

    /** 
     * Get the 'DataLists' element value. Data Lists(s).
     * 
     * @return value
     */
    public DataListType getQueryDataLists() {
        return queryDataLists;
    }

    /** 
     * Set the 'DataLists' element value. Data Lists(s).
     * 
     * @param queryDataLists
     */
    public void setQueryDataLists(DataListType queryDataLists) {
        this.queryDataLists = queryDataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public OrdCreateMetadataType getQueryMetadata() {
        return queryMetadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param queryMetadata
     */
    public void setQueryMetadata(OrdCreateMetadataType queryMetadata) {
        this.queryMetadata = queryMetadata;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Payment information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OrderPaymentFormType" name="Payment" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Payments implements Serializable
    {
        private List<OrderPaymentFormType> paymentList = new ArrayList<OrderPaymentFormType>();

        /** 
         * Get the list of 'Payment' element items. Payment detail, including association(s).
         * 
         * @return list
         */
        public List<OrderPaymentFormType> getPaymentList() {
            return paymentList;
        }

        /** 
         * Set the list of 'Payment' element items. Payment detail, including association(s).
         * 
         * @param list
         */
        public void setPaymentList(List<OrderPaymentFormType> list) {
            paymentList = list;
        }
    }
    /** 
     * Promotion information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Promotion" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Promotion -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Promotions implements Serializable
    {
        private List<Promotion> promotionList = new ArrayList<Promotion>();

        /** 
         * Get the list of 'Promotion' element items.
         * 
         * @return list
         */
        public List<Promotion> getPromotionList() {
            return promotionList;
        }

        /** 
         * Set the list of 'Promotion' element items.
         * 
         * @param list
         */
        public void setPromotionList(List<Promotion> list) {
            promotionList = list;
        }
        /** 
         * Promotion Code.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotion" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:PromotionType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="Passengers" minOccurs="0">
         *             &lt;!-- Reference to inner class Passengers -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Promotion extends PromotionType implements
            Serializable
        {
            private Passengers passengers;

            /** 
             * Get the 'Passengers' element value.
             * 
             * @return value
             */
            public Passengers getPassengers() {
                return passengers;
            }

            /** 
             * Set the 'Passengers' element value.
             * 
             * @param passengers
             */
            public void setPassengers(Passengers passengers) {
                this.passengers = passengers;
            }
            /** 
             * Passenger(s)/ Group(s) associated with the Promotion.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:choice>
             *       &lt;xs:element ref="ns:PassengerReferences"/>
             *       &lt;xs:element ref="ns:GroupReference"/>
             *     &lt;/xs:choice>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Passengers implements Serializable
            {
                private int passengersSelect = -1;
                private static final int PASSENGER_REFERENCES_CHOICE = 0;
                private static final int GROUP_REFERENCE_CHOICE = 1;
                private PassengerReferences passengerReferences;
                private GroupReference groupReference;

                private void setPassengersSelect(int choice) {
                    if (passengersSelect == -1) {
                        passengersSelect = choice;
                    } else if (passengersSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearPassengersSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearPassengersSelect() {
                    passengersSelect = -1;
                }

                /** 
                 * Check if PassengerReferences is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifPassengerReferences() {
                    return passengersSelect == PASSENGER_REFERENCES_CHOICE;
                }

                /** 
                 * Get the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                 * 
                 * @return value
                 */
                public PassengerReferences getPassengerReferences() {
                    return passengerReferences;
                }

                /** 
                 * Set the 'PassengerReferences' element value. Association to multiple Passenger instance(s). Example: pax1 pax2
                 * 
                 * @param passengerReferences
                 */
                public void setPassengerReferences(
                        PassengerReferences passengerReferences) {
                    setPassengersSelect(PASSENGER_REFERENCES_CHOICE);
                    this.passengerReferences = passengerReferences;
                }

                /** 
                 * Check if GroupReference is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifGroupReference() {
                    return passengersSelect == GROUP_REFERENCE_CHOICE;
                }

                /** 
                 * Get the 'GroupReference' element value.
                 * 
                 * @return value
                 */
                public GroupReference getGroupReference() {
                    return groupReference;
                }

                /** 
                 * Set the 'GroupReference' element value.
                 * 
                 * @param groupReference
                 */
                public void setGroupReference(GroupReference groupReference) {
                    setPassengersSelect(GROUP_REFERENCE_CHOICE);
                    this.groupReference = groupReference;
                }
            }
        }
    }
}
