
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Order Item association(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemAssociationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Passengers" minOccurs="0">
 *       &lt;!-- Reference to inner class Passengers -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:GroupType" name="Group" minOccurs="0"/>
 *     &lt;xs:element name="Flight" minOccurs="0">
 *       &lt;!-- Reference to inner class Flight -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OrderItems" minOccurs="0">
 *       &lt;!-- Reference to inner class OrderItems -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OfferItems" minOccurs="0">
 *       &lt;!-- Reference to inner class OfferItems -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Services" minOccurs="0">
 *       &lt;!-- Reference to inner class Services -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:OtherOrderAssocType" name="OtherAssociations" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="AllPassengersInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="WholeItineraryInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderItemAssociationType implements Serializable
{
    private Passengers passengers;
    private GroupType group;
    private Flight flight;
    private OrderItems orderItems;
    private OfferItems offerItems;
    private Services services;
    private OtherOrderAssocType otherAssociations;
    private Boolean allPassengersInd;
    private Boolean wholeItineraryInd;

    /** 
     * Get the 'Passengers' element value.
     * 
     * @return value
     */
    public Passengers getPassengers() {
        return passengers;
    }

    /** 
     * Set the 'Passengers' element value.
     * 
     * @param passengers
     */
    public void setPassengers(Passengers passengers) {
        this.passengers = passengers;
    }

    /** 
     * Get the 'Group' element value. Associated Group detail.
     * 
     * @return value
     */
    public GroupType getGroup() {
        return group;
    }

    /** 
     * Set the 'Group' element value. Associated Group detail.
     * 
     * @param group
     */
    public void setGroup(GroupType group) {
        this.group = group;
    }

    /** 
     * Get the 'Flight' element value.
     * 
     * @return value
     */
    public Flight getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value.
     * 
     * @param flight
     */
    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    /** 
     * Get the 'OrderItems' element value.
     * 
     * @return value
     */
    public OrderItems getOrderItems() {
        return orderItems;
    }

    /** 
     * Set the 'OrderItems' element value.
     * 
     * @param orderItems
     */
    public void setOrderItems(OrderItems orderItems) {
        this.orderItems = orderItems;
    }

    /** 
     * Get the 'OfferItems' element value.
     * 
     * @return value
     */
    public OfferItems getOfferItems() {
        return offerItems;
    }

    /** 
     * Set the 'OfferItems' element value.
     * 
     * @param offerItems
     */
    public void setOfferItems(OfferItems offerItems) {
        this.offerItems = offerItems;
    }

    /** 
     * Get the 'Services' element value.
     * 
     * @return value
     */
    public Services getServices() {
        return services;
    }

    /** 
     * Set the 'Services' element value.
     * 
     * @param services
     */
    public void setServices(Services services) {
        this.services = services;
    }

    /** 
     * Get the 'OtherAssociations' element value. Other optional association(s).
     * 
     * @return value
     */
    public OtherOrderAssocType getOtherAssociations() {
        return otherAssociations;
    }

    /** 
     * Set the 'OtherAssociations' element value. Other optional association(s).
     * 
     * @param otherAssociations
     */
    public void setOtherAssociations(OtherOrderAssocType otherAssociations) {
        this.otherAssociations = otherAssociations;
    }

    /** 
     * Get the 'AllPassengersInd' attribute value. When TRUE, this applies to all passengers.
     * 
     * @return value
     */
    public Boolean getAllPassengersInd() {
        return allPassengersInd;
    }

    /** 
     * Set the 'AllPassengersInd' attribute value. When TRUE, this applies to all passengers.
     * 
     * @param allPassengersInd
     */
    public void setAllPassengersInd(Boolean allPassengersInd) {
        this.allPassengersInd = allPassengersInd;
    }

    /** 
     * Get the 'WholeItineraryInd' attribute value. When TRUE, this applies to the whole itinerary, including all passengers.
     * 
     * @return value
     */
    public Boolean getWholeItineraryInd() {
        return wholeItineraryInd;
    }

    /** 
     * Set the 'WholeItineraryInd' attribute value. When TRUE, this applies to the whole itinerary, including all passengers.
     * 
     * @param wholeItineraryInd
     */
    public void setWholeItineraryInd(Boolean wholeItineraryInd) {
        this.wholeItineraryInd = wholeItineraryInd;
    }
    /** 
     * Passenger(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:Passenger" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Passengers implements Serializable
    {
        private List<Passenger> passengerList = new ArrayList<Passenger>();

        /** 
         * Get the list of 'Passenger' element items. Associated Passenger detail.
         * 
         * @return list
         */
        public List<Passenger> getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the list of 'Passenger' element items. Associated Passenger detail.
         * 
         * @param list
         */
        public void setPassengerList(List<Passenger> list) {
            passengerList = list;
        }
    }
    /** 
     * Flight that the offer applies to.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element type="xs:boolean" name="AllFlightInd"/>
     *       &lt;xs:element type="xs:boolean" name="AllOriginDestinationInd"/>
     *       &lt;xs:element type="xs:boolean" name="AllSegmentInd"/>
     *       &lt;xs:choice maxOccurs="2">
     *         &lt;!-- Reference to inner class Choice -->
     *       &lt;/xs:choice>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Flight implements Serializable
    {
        private int flightSelect = -1;
        private static final int ALL_FLIGHT_IND_CHOICE = 0;
        private static final int ALL_ORIGIN_DESTINATION_IND_CHOICE = 1;
        private static final int ALL_SEGMENT_IND_CHOICE = 2;
        private static final int CHOICE_LIST_CHOICE = 3;
        private boolean allFlightInd;
        private boolean allOriginDestinationInd;
        private boolean allSegmentInd;
        private List<Choice> choiceList = new ArrayList<Choice>();

        private void setFlightSelect(int choice) {
            if (flightSelect == -1) {
                flightSelect = choice;
            } else if (flightSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearFlightSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearFlightSelect() {
            flightSelect = -1;
        }

        /** 
         * Check if AllFlightInd is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAllFlightInd() {
            return flightSelect == ALL_FLIGHT_IND_CHOICE;
        }

        /** 
         * Get the 'AllFlightInd' element value. When TRUE, this Baggage Offer applies to all specified flights.
         * 
         * @return value
         */
        public boolean isAllFlightInd() {
            return allFlightInd;
        }

        /** 
         * Set the 'AllFlightInd' element value. When TRUE, this Baggage Offer applies to all specified flights.
         * 
         * @param allFlightInd
         */
        public void setAllFlightInd(boolean allFlightInd) {
            setFlightSelect(ALL_FLIGHT_IND_CHOICE);
            this.allFlightInd = allFlightInd;
        }

        /** 
         * Check if AllOriginDestinationInd is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAllOriginDestinationInd() {
            return flightSelect == ALL_ORIGIN_DESTINATION_IND_CHOICE;
        }

        /** 
         * Get the 'AllOriginDestinationInd' element value. When TRUE, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
         * 
         * @return value
         */
        public boolean isAllOriginDestinationInd() {
            return allOriginDestinationInd;
        }

        /** 
         * Set the 'AllOriginDestinationInd' element value. When TRUE, this Baggage Offer applies to all specified flight Origin/ Destination Pairs.
         * 
         * @param allOriginDestinationInd
         */
        public void setAllOriginDestinationInd(boolean allOriginDestinationInd) {
            setFlightSelect(ALL_ORIGIN_DESTINATION_IND_CHOICE);
            this.allOriginDestinationInd = allOriginDestinationInd;
        }

        /** 
         * Check if AllSegmentInd is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAllSegmentInd() {
            return flightSelect == ALL_SEGMENT_IND_CHOICE;
        }

        /** 
         * Get the 'AllSegmentInd' element value. When TRUE, this Baggage Offer applies to all specified flight Segments.
         * 
         * @return value
         */
        public boolean isAllSegmentInd() {
            return allSegmentInd;
        }

        /** 
         * Set the 'AllSegmentInd' element value. When TRUE, this Baggage Offer applies to all specified flight Segments.
         * 
         * @param allSegmentInd
         */
        public void setAllSegmentInd(boolean allSegmentInd) {
            setFlightSelect(ALL_SEGMENT_IND_CHOICE);
            this.allSegmentInd = allSegmentInd;
        }

        /** 
         * Check if ChoiceList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifChoiceList() {
            return flightSelect == CHOICE_LIST_CHOICE;
        }

        /** 
         * Get the list of choice items.
         * 
         * @return list
         */
        public List<Choice> getChoiceList() {
            return choiceList;
        }

        /** 
         * Set the list of choice items.
         * 
         * @param list
         */
        public void setChoiceList(List<Choice> list) {
            setFlightSelect(CHOICE_LIST_CHOICE);
            choiceList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
         *   &lt;xs:element ref="ns:OriginDestinationReferences"/>
         *   &lt;xs:element ref="ns:SegmentReferences"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class Choice implements Serializable
        {
            private int choiceListSelect = -1;
            private static final int ORIGIN_DESTINATION_REFERENCES_CHOICE = 0;
            private static final int SEGMENT_REFERENCES_CHOICE = 1;
            private OriginDestinationReferences originDestinationReferences;
            private SegmentReferences segmentReferences;

            private void setChoiceListSelect(int choice) {
                if (choiceListSelect == -1) {
                    choiceListSelect = choice;
                } else if (choiceListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceListSelect() {
                choiceListSelect = -1;
            }

            /** 
             * Check if OriginDestinationReferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifOriginDestinationReferences() {
                return choiceListSelect == ORIGIN_DESTINATION_REFERENCES_CHOICE;
            }

            /** 
             * Get the 'OriginDestinationReferences' element value.
             * 
             * @return value
             */
            public OriginDestinationReferences getOriginDestinationReferences() {
                return originDestinationReferences;
            }

            /** 
             * Set the 'OriginDestinationReferences' element value.
             * 
             * @param originDestinationReferences
             */
            public void setOriginDestinationReferences(
                    OriginDestinationReferences originDestinationReferences) {
                setChoiceListSelect(ORIGIN_DESTINATION_REFERENCES_CHOICE);
                this.originDestinationReferences = originDestinationReferences;
            }

            /** 
             * Check if SegmentReferences is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSegmentReferences() {
                return choiceListSelect == SEGMENT_REFERENCES_CHOICE;
            }

            /** 
             * Get the 'SegmentReferences' element value.
             * 
             * @return value
             */
            public SegmentReferences getSegmentReferences() {
                return segmentReferences;
            }

            /** 
             * Set the 'SegmentReferences' element value.
             * 
             * @param segmentReferences
             */
            public void setSegmentReferences(SegmentReferences segmentReferences) {
                setChoiceListSelect(SEGMENT_REFERENCES_CHOICE);
                this.segmentReferences = segmentReferences;
            }
        }
    }
    /** 
     * Associated Order Item(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItems" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:OrderItemID" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OrderItems implements Serializable
    {
        private List<OrderItemID> orderItemIDList = new ArrayList<OrderItemID>();

        /** 
         * Get the list of 'OrderItemID' element items.
         * 
         * @return list
         */
        public List<OrderItemID> getOrderItemIDList() {
            return orderItemIDList;
        }

        /** 
         * Set the list of 'OrderItemID' element items.
         * 
         * @param list
         */
        public void setOrderItemIDList(List<OrderItemID> list) {
            orderItemIDList = list;
        }
    }
    /** 
     * Associated Offer Item(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItems" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:OfferItemID" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OfferItems implements Serializable
    {
        private List<OfferItemID> offerItemIDList = new ArrayList<OfferItemID>();

        /** 
         * Get the list of 'OfferItemID' element items.
         * 
         * @return list
         */
        public List<OfferItemID> getOfferItemIDList() {
            return offerItemIDList;
        }

        /** 
         * Set the list of 'OfferItemID' element items.
         * 
         * @param list
         */
        public void setOfferItemIDList(List<OfferItemID> list) {
            offerItemIDList = list;
        }
    }
    /** 
     * Associated Order Item(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:ServiceID" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Services implements Serializable
    {
        private List<ServiceIDType> serviceIDList = new ArrayList<ServiceIDType>();

        /** 
         * Get the list of 'ServiceID' element items.
         * 
         * @return list
         */
        public List<ServiceIDType> getServiceIDList() {
            return serviceIDList;
        }

        /** 
         * Set the list of 'ServiceID' element items.
         * 
         * @param list
         */
        public void setServiceIDList(List<ServiceIDType> list) {
            serviceIDList = list;
        }
    }
}
