
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * REPRICED ORDER ITEM definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemRepriceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OrderItem" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class OrderItem -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderItemRepriceType implements Serializable
{
    private List<OrderItem> orderItemList = new ArrayList<OrderItem>();

    /** 
     * Get the list of 'OrderItem' element items.
     * 
     * @return list
     */
    public List<OrderItem> getOrderItemList() {
        return orderItemList;
    }

    /** 
     * Set the list of 'OrderItem' element items.
     * 
     * @param list
     */
    public void setOrderItemList(List<OrderItem> list) {
        orderItemList = list;
    }
    /** 
     * Order Item details.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItem" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:OrderItemID"/>
     *           &lt;xs:element ref="ns:Associations" minOccurs="0"/>
     *           &lt;xs:element ref="ns:BaggageItem" minOccurs="0"/>
     *           &lt;xs:element ref="ns:FlightItem" minOccurs="0"/>
     *           &lt;xs:element ref="ns:OtherItem" minOccurs="0"/>
     *           &lt;xs:element ref="ns:SeatItem" minOccurs="0"/>
     *           &lt;xs:element name="InventoryGuarantee" minOccurs="0">
     *             &lt;!-- Reference to inner class InventoryGuarantee -->
     *           &lt;/xs:element>
     *           &lt;xs:element ref="ns:Disclosures" minOccurs="0"/>
     *           &lt;xs:element type="ns:OrderItemTimeLimitsType" name="TimeLimits" minOccurs="0"/>
     *           &lt;xs:element ref="ns:ItemStatus" minOccurs="0"/>
     *           &lt;xs:element type="ns:PenaltyType" name="Penalty" minOccurs="0"/>
     *           &lt;xs:element ref="ns:OrderItemDetails" minOccurs="0"/>
     *           &lt;xs:element name="ActionType" minOccurs="0">
     *             &lt;!-- Reference to inner class ActionType -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OrderItem extends KeyWithMetaObjectBaseType implements
        Serializable
    {
        private OrderItemID orderItemID;
        private Associations associations;
        private BaggageItem baggageItem;
        private FlightItem flightItem;
        private OtherItem otherItem;
        private SeatItem seatItem;
        private InventoryGuarantee inventoryGuarantee;
        private DisclosureType disclosures;
        private OrderItemTimeLimitsType timeLimits;
        private ItemStatus itemStatus;
        private PenaltyType penalty;
        private OrderItemDetails orderItemDetails;
        private ActionType actionType;

        /** 
         * Get the 'OrderItemID' element value.
         * 
         * @return value
         */
        public OrderItemID getOrderItemID() {
            return orderItemID;
        }

        /** 
         * Set the 'OrderItemID' element value.
         * 
         * @param orderItemID
         */
        public void setOrderItemID(OrderItemID orderItemID) {
            this.orderItemID = orderItemID;
        }

        /** 
         * Get the 'Associations' element value.
         * 
         * @return value
         */
        public Associations getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value.
         * 
         * @param associations
         */
        public void setAssociations(Associations associations) {
            this.associations = associations;
        }

        /** 
         * Get the 'BaggageItem' element value.
         * 
         * @return value
         */
        public BaggageItem getBaggageItem() {
            return baggageItem;
        }

        /** 
         * Set the 'BaggageItem' element value.
         * 
         * @param baggageItem
         */
        public void setBaggageItem(BaggageItem baggageItem) {
            this.baggageItem = baggageItem;
        }

        /** 
         * Get the 'FlightItem' element value.
         * 
         * @return value
         */
        public FlightItem getFlightItem() {
            return flightItem;
        }

        /** 
         * Set the 'FlightItem' element value.
         * 
         * @param flightItem
         */
        public void setFlightItem(FlightItem flightItem) {
            this.flightItem = flightItem;
        }

        /** 
         * Get the 'OtherItem' element value.
         * 
         * @return value
         */
        public OtherItem getOtherItem() {
            return otherItem;
        }

        /** 
         * Set the 'OtherItem' element value.
         * 
         * @param otherItem
         */
        public void setOtherItem(OtherItem otherItem) {
            this.otherItem = otherItem;
        }

        /** 
         * Get the 'SeatItem' element value.
         * 
         * @return value
         */
        public SeatItem getSeatItem() {
            return seatItem;
        }

        /** 
         * Set the 'SeatItem' element value.
         * 
         * @param seatItem
         */
        public void setSeatItem(SeatItem seatItem) {
            this.seatItem = seatItem;
        }

        /** 
         * Get the 'InventoryGuarantee' element value.
         * 
         * @return value
         */
        public InventoryGuarantee getInventoryGuarantee() {
            return inventoryGuarantee;
        }

        /** 
         * Set the 'InventoryGuarantee' element value.
         * 
         * @param inventoryGuarantee
         */
        public void setInventoryGuarantee(InventoryGuarantee inventoryGuarantee) {
            this.inventoryGuarantee = inventoryGuarantee;
        }

        /** 
         * Get the 'Disclosures' element value.
         * 
         * @return value
         */
        public DisclosureType getDisclosures() {
            return disclosures;
        }

        /** 
         * Set the 'Disclosures' element value.
         * 
         * @param disclosures
         */
        public void setDisclosures(DisclosureType disclosures) {
            this.disclosures = disclosures;
        }

        /** 
         * Get the 'TimeLimits' element value. Order-associated Time Limit(s).
         * 
         * @return value
         */
        public OrderItemTimeLimitsType getTimeLimits() {
            return timeLimits;
        }

        /** 
         * Set the 'TimeLimits' element value. Order-associated Time Limit(s).
         * 
         * @param timeLimits
         */
        public void setTimeLimits(OrderItemTimeLimitsType timeLimits) {
            this.timeLimits = timeLimits;
        }

        /** 
         * Get the 'ItemStatus' element value. 
                          Current Order Item status. Example: OK (Confirmed) Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
                        
         * 
         * @return value
         */
        public ItemStatus getItemStatus() {
            return itemStatus;
        }

        /** 
         * Set the 'ItemStatus' element value. 
                          Current Order Item status. Example: OK (Confirmed) Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
                        
         * 
         * @param itemStatus
         */
        public void setItemStatus(ItemStatus itemStatus) {
            this.itemStatus = itemStatus;
        }

        /** 
         * Get the 'Penalty' element value. Penalty information.
         * 
         * @return value
         */
        public PenaltyType getPenalty() {
            return penalty;
        }

        /** 
         * Set the 'Penalty' element value. Penalty information.
         * 
         * @param penalty
         */
        public void setPenalty(PenaltyType penalty) {
            this.penalty = penalty;
        }

        /** 
         * Get the 'OrderItemDetails' element value.
         * 
         * @return value
         */
        public OrderItemDetails getOrderItemDetails() {
            return orderItemDetails;
        }

        /** 
         * Set the 'OrderItemDetails' element value.
         * 
         * @param orderItemDetails
         */
        public void setOrderItemDetails(OrderItemDetails orderItemDetails) {
            this.orderItemDetails = orderItemDetails;
        }

        /** 
         * Get the 'ActionType' element value.
         * 
         * @return value
         */
        public ActionType getActionType() {
            return actionType;
        }

        /** 
         * Set the 'ActionType' element value.
         * 
         * @param actionType
         */
        public void setActionType(ActionType actionType) {
            this.actionType = actionType;
        }
        /** 
         * Inventory Guarantee 
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InventoryGuarantee" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="InvGuaranteeID"/>
         *       &lt;xs:element ref="ns:InvGuaranteeTimeLimits"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class InventoryGuarantee implements Serializable
        {
            private String invGuaranteeID;
            private CoreDateGrpType invGuaranteeTimeLimits;

            /** 
             * Get the 'InvGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @return value
             */
            public String getInvGuaranteeID() {
                return invGuaranteeID;
            }

            /** 
             * Set the 'InvGuaranteeID' element value. 
                                  Unique Inventory Guarantee ID. Examples: INVREF123456, 68E0-675C Note: This is a unique identifier issued by an Airline to reference that inventory for a specified offer will be guaranteed as available for a period.
                                
             * 
             * @param invGuaranteeID
             */
            public void setInvGuaranteeID(String invGuaranteeID) {
                this.invGuaranteeID = invGuaranteeID;
            }

            /** 
             * Get the 'InvGuaranteeTimeLimits' element value.
             * 
             * @return value
             */
            public CoreDateGrpType getInvGuaranteeTimeLimits() {
                return invGuaranteeTimeLimits;
            }

            /** 
             * Set the 'InvGuaranteeTimeLimits' element value.
             * 
             * @param invGuaranteeTimeLimits
             */
            public void setInvGuaranteeTimeLimits(
                    CoreDateGrpType invGuaranteeTimeLimits) {
                this.invGuaranteeTimeLimits = invGuaranteeTimeLimits;
            }
        }
        /** 
         * 
                          Order Action. Examples: Cancel, Create, Update, Delete, Reissue, Reprice
                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ActionType implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Action Type Context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Action Type Context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
}
