
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * ORDER PAYMENT FORM definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderPaymentFormType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Method">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element ref="ns:Voucher" minOccurs="0"/>
 *               &lt;xs:element ref="ns:PaymentCard" minOccurs="0"/>
 *               &lt;xs:element ref="ns:Other" minOccurs="0"/>
 *               &lt;xs:element ref="ns:MiscChargeOrder" minOccurs="0"/>
 *               &lt;xs:element ref="ns:LoyaltyRedemption" minOccurs="0"/>
 *               &lt;xs:element ref="ns:DirectBill" minOccurs="0"/>
 *               &lt;xs:element ref="ns:Cash" minOccurs="0"/>
 *               &lt;xs:element ref="ns:BankAccount" minOccurs="0"/>
 *               &lt;xs:element ref="ns:Cheque" minOccurs="0"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
 *         &lt;xs:element name="Associations" minOccurs="0">
 *           &lt;!-- Reference to inner class Associations -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Payer" minOccurs="0">
 *           &lt;!-- Reference to inner class Payer -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:CodesetType" name="Qualifier" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderPaymentFormType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private Voucher methodVoucher;
    private PaymentCardType methodPaymentCard;
    private Other methodOther;
    private MiscChargeOrder methodMiscChargeOrder;
    private LoyaltyRedemption methodLoyaltyRedemption;
    private DirectBillType methodDirectBill;
    private Cash methodCash;
    private BankAccountType methodBankAccount;
    private Cheque methodCheque;
    private CurrencyAmountOptType amount;
    private Associations associations;
    private Payer payer;
    private CodesetType qualifier;

    /** 
     * Get the 'Voucher' element value. Information relating to prepayment vouchers.
     * 
     * @return value
     */
    public Voucher getMethodVoucher() {
        return methodVoucher;
    }

    /** 
     * Set the 'Voucher' element value. Information relating to prepayment vouchers.
     * 
     * @param methodVoucher
     */
    public void setMethodVoucher(Voucher methodVoucher) {
        this.methodVoucher = methodVoucher;
    }

    /** 
     * Get the 'PaymentCard' element value.
     * 
     * @return value
     */
    public PaymentCardType getMethodPaymentCard() {
        return methodPaymentCard;
    }

    /** 
     * Set the 'PaymentCard' element value.
     * 
     * @param methodPaymentCard
     */
    public void setMethodPaymentCard(PaymentCardType methodPaymentCard) {
        this.methodPaymentCard = methodPaymentCard;
    }

    /** 
     * Get the 'Other' element value.
     * 
     * @return value
     */
    public Other getMethodOther() {
        return methodOther;
    }

    /** 
     * Set the 'Other' element value.
     * 
     * @param methodOther
     */
    public void setMethodOther(Other methodOther) {
        this.methodOther = methodOther;
    }

    /** 
     * Get the 'MiscChargeOrder' element value.
     * 
     * @return value
     */
    public MiscChargeOrder getMethodMiscChargeOrder() {
        return methodMiscChargeOrder;
    }

    /** 
     * Set the 'MiscChargeOrder' element value.
     * 
     * @param methodMiscChargeOrder
     */
    public void setMethodMiscChargeOrder(MiscChargeOrder methodMiscChargeOrder) {
        this.methodMiscChargeOrder = methodMiscChargeOrder;
    }

    /** 
     * Get the 'LoyaltyRedemption' element value.
     * 
     * @return value
     */
    public LoyaltyRedemption getMethodLoyaltyRedemption() {
        return methodLoyaltyRedemption;
    }

    /** 
     * Set the 'LoyaltyRedemption' element value.
     * 
     * @param methodLoyaltyRedemption
     */
    public void setMethodLoyaltyRedemption(
            LoyaltyRedemption methodLoyaltyRedemption) {
        this.methodLoyaltyRedemption = methodLoyaltyRedemption;
    }

    /** 
     * Get the 'DirectBill' element value.
     * 
     * @return value
     */
    public DirectBillType getMethodDirectBill() {
        return methodDirectBill;
    }

    /** 
     * Set the 'DirectBill' element value.
     * 
     * @param methodDirectBill
     */
    public void setMethodDirectBill(DirectBillType methodDirectBill) {
        this.methodDirectBill = methodDirectBill;
    }

    /** 
     * Get the 'Cash' element value.
     * 
     * @return value
     */
    public Cash getMethodCash() {
        return methodCash;
    }

    /** 
     * Set the 'Cash' element value.
     * 
     * @param methodCash
     */
    public void setMethodCash(Cash methodCash) {
        this.methodCash = methodCash;
    }

    /** 
     * Get the 'BankAccount' element value.
     * 
     * @return value
     */
    public BankAccountType getMethodBankAccount() {
        return methodBankAccount;
    }

    /** 
     * Set the 'BankAccount' element value.
     * 
     * @param methodBankAccount
     */
    public void setMethodBankAccount(BankAccountType methodBankAccount) {
        this.methodBankAccount = methodBankAccount;
    }

    /** 
     * Get the 'Cheque' element value.
     * 
     * @return value
     */
    public Cheque getMethodCheque() {
        return methodCheque;
    }

    /** 
     * Set the 'Cheque' element value.
     * 
     * @param methodCheque
     */
    public void setMethodCheque(Cheque methodCheque) {
        this.methodCheque = methodCheque;
    }

    /** 
     * Get the 'Amount' element value. The amount for this form of payment. Example: 300 USD
                
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. The amount for this form of payment. Example: 300 USD
                
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Associations' element value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'Payer' element value.
     * 
     * @return value
     */
    public Payer getPayer() {
        return payer;
    }

    /** 
     * Set the 'Payer' element value.
     * 
     * @param payer
     */
    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    /** 
     * Get the 'Qualifier' element value. Used to specify if this is the old, new or orginal form of payment. Encoding Scheme: IATA PADIS code list [9988] Data Indicator
                
     * 
     * @return value
     */
    public CodesetType getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value. Used to specify if this is the old, new or orginal form of payment. Encoding Scheme: IATA PADIS code list [9988] Data Indicator
                
     * 
     * @param qualifier
     */
    public void setQualifier(CodesetType qualifier) {
        this.qualifier = qualifier;
    }
    /** 
     * Payment Information Association(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Passengers" minOccurs="0">
     *         &lt;!-- Reference to inner class Passengers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OfferItemSets" minOccurs="0">
     *         &lt;!-- Reference to inner class OfferItemSets -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Associations implements Serializable
    {
        private Passengers passengers;
        private OfferItemSets offerItemSets;

        /** 
         * Get the 'Passengers' element value.
         * 
         * @return value
         */
        public Passengers getPassengers() {
            return passengers;
        }

        /** 
         * Set the 'Passengers' element value.
         * 
         * @param passengers
         */
        public void setPassengers(Passengers passengers) {
            this.passengers = passengers;
        }

        /** 
         * Get the 'OfferItemSets' element value.
         * 
         * @return value
         */
        public OfferItemSets getOfferItemSets() {
            return offerItemSets;
        }

        /** 
         * Set the 'OfferItemSets' element value.
         * 
         * @param offerItemSets
         */
        public void setOfferItemSets(OfferItemSets offerItemSets) {
            this.offerItemSets = offerItemSets;
        }
        /** 
         * 
                          Passenger(s) associated with the Offer Item. Note: This contains references to Passenger instance(s) defined in the Passengers/Passenger node.
                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element ref="ns:PassengerReference"/>
         *       &lt;xs:element ref="ns:GroupReference"/>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Passengers implements Serializable
        {
            private int passengersSelect = -1;
            private static final int PASSENGER_REFERENCE_CHOICE = 0;
            private static final int GROUP_REFERENCE_CHOICE = 1;
            private PassengerReference passengerReference;
            private GroupReference groupReference;

            private void setPassengersSelect(int choice) {
                if (passengersSelect == -1) {
                    passengersSelect = choice;
                } else if (passengersSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearPassengersSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearPassengersSelect() {
                passengersSelect = -1;
            }

            /** 
             * Check if PassengerReference is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPassengerReference() {
                return passengersSelect == PASSENGER_REFERENCE_CHOICE;
            }

            /** 
             * Get the 'PassengerReference' element value. 
                                  Association to multiple Passenger instance(s). Example: pax1 pax2
                                
             * 
             * @return value
             */
            public PassengerReference getPassengerReference() {
                return passengerReference;
            }

            /** 
             * Set the 'PassengerReference' element value. 
                                  Association to multiple Passenger instance(s). Example: pax1 pax2
                                
             * 
             * @param passengerReference
             */
            public void setPassengerReference(
                    PassengerReference passengerReference) {
                setPassengersSelect(PASSENGER_REFERENCE_CHOICE);
                this.passengerReference = passengerReference;
            }

            /** 
             * Check if GroupReference is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifGroupReference() {
                return passengersSelect == GROUP_REFERENCE_CHOICE;
            }

            /** 
             * Get the 'GroupReference' element value.
             * 
             * @return value
             */
            public GroupReference getGroupReference() {
                return groupReference;
            }

            /** 
             * Set the 'GroupReference' element value.
             * 
             * @param groupReference
             */
            public void setGroupReference(GroupReference groupReference) {
                setPassengersSelect(GROUP_REFERENCE_CHOICE);
                this.groupReference = groupReference;
            }
        }
        /** 
         * 
                          Passenger(s) associated with the Offer Item. Note: This contains references to Passenger instance(s) defined in the Passengers/Passenger node.
                        
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemSets" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="OfferItemSetRefs"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OfferItemSets implements Serializable
        {
            private String offerItemSetRefs;

            /** 
             * Get the 'OfferItemSetRefs' element value. 
                                  Association to one or multiple Offer Item Set instance(s). Example:set1 set2
                                
             * 
             * @return value
             */
            public String getOfferItemSetRefs() {
                return offerItemSetRefs;
            }

            /** 
             * Set the 'OfferItemSetRefs' element value. 
                                  Association to one or multiple Offer Item Set instance(s). Example:set1 set2
                                
             * 
             * @param offerItemSetRefs
             */
            public void setOfferItemSetRefs(String offerItemSetRefs) {
                this.offerItemSetRefs = offerItemSetRefs;
            }
        }
    }
    /** 
     * The person who is paying for an Order is not a passenger
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Payer" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Name">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="Surname">
     *               &lt;xs:complexType>
     *                 &lt;xs:simpleContent>
     *                   &lt;xs:extension base="xs:string">
     *                     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *                   &lt;/xs:extension>
     *                 &lt;/xs:simpleContent>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element name="Given" minOccurs="0" maxOccurs="5">
     *               &lt;!-- Reference to inner class Given -->
     *             &lt;/xs:element>
     *             &lt;xs:element type="xs:string" name="Title" minOccurs="0"/>
     *             &lt;xs:element name="SurnameSuffix" minOccurs="0"/>
     *             &lt;xs:element name="Middle" minOccurs="0" maxOccurs="3">
     *               &lt;!-- Reference to inner class Middle -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *           &lt;xs:attributeGroup ref="ns:ObjectPolicyMetaAttrGroup"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ns:Contacts" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Payer implements Serializable
    {
        private String nameSurnameString;
        private String nameSurnameRefs;
        private List<Given> givenList = new ArrayList<Given>();
        private String nameTitle;
        private boolean nameSurnameSuffix;
        private List<Middle> middleList = new ArrayList<Middle>();
        private ObjectPolicyMetaAttrGroup nameObjectPolicyMetaAttrGroup;
        private Contacts contacts;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getNameSurnameString() {
            return nameSurnameString;
        }

        /** 
         * Set the extension value.
         * 
         * @param nameSurnameString
         */
        public void setNameSurnameString(String nameSurnameString) {
            this.nameSurnameString = nameSurnameString;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getNameSurnameRefs() {
            return nameSurnameRefs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param nameSurnameRefs
         */
        public void setNameSurnameRefs(String nameSurnameRefs) {
            this.nameSurnameRefs = nameSurnameRefs;
        }

        /** 
         * Get the list of 'Given' element items. Passenger Name information.

        Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
         * 
         * @return list
         */
        public List<Given> getGivenList() {
            return givenList;
        }

        /** 
         * Set the list of 'Given' element items. Passenger Name information.

        Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
         * 
         * @param list
         */
        public void setGivenList(List<Given> list) {
            givenList = list;
        }

        /** 
         * Get the 'Title' element value. Name Title. Examples: MR, MRS, DR
         * 
         * @return value
         */
        public String getNameTitle() {
            return nameTitle;
        }

        /** 
         * Set the 'Title' element value. Name Title. Examples: MR, MRS, DR
         * 
         * @param nameTitle
         */
        public void setNameTitle(String nameTitle) {
            this.nameTitle = nameTitle;
        }

        /** 
         * Check if the 'SurnameSuffix' element is present.
         * 
         * @return <code>true</code> if present, <code>false</code> if not
         */
        public boolean ifNameSurnameSuffixPresent() {
            return nameSurnameSuffix;
        }

        /** 
         * Set flag for 'SurnameSuffix' element present.
         * 
         * @param nameSurnameSuffix
         */
        public void flagNameSurnameSuffixPresent(boolean nameSurnameSuffix) {
            this.nameSurnameSuffix = nameSurnameSuffix;
        }

        /** 
         * Get the list of 'Middle' element items. Passenger Name information.

        Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
         * 
         * @return list
         */
        public List<Middle> getMiddleList() {
            return middleList;
        }

        /** 
         * Set the list of 'Middle' element items. Passenger Name information.

        Note: Detailed Name information, such as prefix, title and suffix, are specified in PassengerMetadata.
         * 
         * @param list
         */
        public void setMiddleList(List<Middle> list) {
            middleList = list;
        }

        /** 
         * Get the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public ObjectPolicyMetaAttrGroup getNameObjectPolicyMetaAttrGroup() {
            return nameObjectPolicyMetaAttrGroup;
        }

        /** 
         * Set the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
         * 
         * @param nameObjectPolicyMetaAttrGroup
         */
        public void setNameObjectPolicyMetaAttrGroup(
                ObjectPolicyMetaAttrGroup nameObjectPolicyMetaAttrGroup) {
            this.nameObjectPolicyMetaAttrGroup = nameObjectPolicyMetaAttrGroup;
        }

        /** 
         * Get the 'Contacts' element value.
         * 
         * @return value
         */
        public Contacts getContacts() {
            return contacts;
        }

        /** 
         * Set the 'Contacts' element value.
         * 
         * @param contacts
         */
        public void setContacts(Contacts contacts) {
            this.contacts = contacts;
        }
        /** 
         * Family (first or given) name.  Example: JOHN
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Given" minOccurs="0" maxOccurs="5">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Given implements Serializable
        {
            private String string;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
        /** 
         * Middle name or initial.  Examples: G, GEORGE
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Middle" minOccurs="0" maxOccurs="3">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class Middle implements Serializable
        {
            private String string;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
}
