
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * ORIGIN/ DESTINATION definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:DepartureCode"/>
 *     &lt;xs:element ref="ns:ArrivalCode"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:string" name="OriginDestinationKey"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OriginDestinationType implements Serializable
{
    private DepartureCode departureCode;
    private ArrivalCode arrivalCode;
    private String refs;
    private String originDestinationKey;

    /** 
     * Get the 'DepartureCode' element value. Departure Airport Location code. Example: TPA

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @return value
     */
    public DepartureCode getDepartureCode() {
        return departureCode;
    }

    /** 
     * Set the 'DepartureCode' element value. Departure Airport Location code. Example: TPA

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @param departureCode
     */
    public void setDepartureCode(DepartureCode departureCode) {
        this.departureCode = departureCode;
    }

    /** 
     * Get the 'ArrivalCode' element value. Airport or a city code. Use a three letter  location identifier assigned according to the IATA Resolution 763.  Refer to IATA Airline Coding Directory . Example: TPA
     * 
     * @return value
     */
    public ArrivalCode getArrivalCode() {
        return arrivalCode;
    }

    /** 
     * Set the 'ArrivalCode' element value. Airport or a city code. Use a three letter  location identifier assigned according to the IATA Resolution 763.  Refer to IATA Airline Coding Directory . Example: TPA
     * 
     * @param arrivalCode
     */
    public void setArrivalCode(ArrivalCode arrivalCode) {
        this.arrivalCode = arrivalCode;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'OriginDestinationKey' attribute value. A globally unique identifier for this OriginDestination instance. Example: origDest1
     * 
     * @return value
     */
    public String getOriginDestinationKey() {
        return originDestinationKey;
    }

    /** 
     * Set the 'OriginDestinationKey' attribute value. A globally unique identifier for this OriginDestination instance. Example: origDest1
     * 
     * @param originDestinationKey
     */
    public void setOriginDestinationKey(String originDestinationKey) {
        this.originDestinationKey = originDestinationKey;
    }
}
