
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Other Order Optional Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherOrderAssocSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="PaymentForm"/>
 *     &lt;xs:enumeration value="Penalty"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OtherOrderAssocSimpleType implements Serializable {
    PAYMENT_FORM("PaymentForm"), PENALTY("Penalty");
    private final String value;

    private OtherOrderAssocSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OtherOrderAssocSimpleType convert(String value) {
        for (OtherOrderAssocSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
