
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * PASSENGER TYPE CODE/ QUANTITY definition.

 Passenger type code and Traveler quantity.  Example: ADT
 Encoding scheme:  IATA (three character) Passenger Type Code
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTC_QuantityType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:integer" use="optional" name="Quantity"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PTCQuantityType implements Serializable
{
    private String string;
    private BigInteger quantity;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'Quantity' attribute value. Number of Traveler(s) for associated passenger type and country of residence.  Example: 2
     * 
     * @return value
     */
    public BigInteger getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'Quantity' attribute value. Number of Traveler(s) for associated passenger type and country of residence.  Example: 2
     * 
     * @param quantity
     */
    public void setQuantity(BigInteger quantity) {
        this.quantity = quantity;
    }
}
