
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PASSENGER Metadata definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="NameDetail" minOccurs="0">
 *           &lt;!-- Reference to inner class NameDetail -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private NameDetail nameDetail;

    /** 
     * Get the 'NameDetail' element value.
     * 
     * @return value
     */
    public NameDetail getNameDetail() {
        return nameDetail;
    }

    /** 
     * Set the 'NameDetail' element value.
     * 
     * @param nameDetail
     */
    public void setNameDetail(NameDetail nameDetail) {
        this.nameDetail = nameDetail;
    }
    /** 
     * Traveler Name Detail, including Given Name Prefix, Title Suffix, Surname Prefix and Surname Suffix.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NameDetail" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="GivenNamePrefix" minOccurs="0" maxOccurs="3"/>
     *       &lt;xs:element type="xs:string" name="TitleSuffix" minOccurs="0" maxOccurs="5"/>
     *       &lt;xs:element type="xs:string" name="SurnamePrefix" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="SurnameSuffix" minOccurs="0" maxOccurs="3"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NameDetail implements Serializable
    {
        private List<String> givenNamePrefixList = new ArrayList<String>();
        private List<String> titleSuffixList = new ArrayList<String>();
        private String surnamePrefix;
        private List<String> surnameSuffixList = new ArrayList<String>();

        /** 
         * Get the list of 'GivenNamePrefix' element items. Given name prefix. Example: MR
         * 
         * @return list
         */
        public List<String> getGivenNamePrefixList() {
            return givenNamePrefixList;
        }

        /** 
         * Set the list of 'GivenNamePrefix' element items. Given name prefix. Example: MR
         * 
         * @param list
         */
        public void setGivenNamePrefixList(List<String> list) {
            givenNamePrefixList = list;
        }

        /** 
         * Get the list of 'TitleSuffix' element items. Title degree or honors. Examples: Ph.D., M.D.
         * 
         * @return list
         */
        public List<String> getTitleSuffixList() {
            return titleSuffixList;
        }

        /** 
         * Set the list of 'TitleSuffix' element items. Title degree or honors. Examples: Ph.D., M.D.
         * 
         * @param list
         */
        public void setTitleSuffixList(List<String> list) {
            titleSuffixList = list;
        }

        /** 
         * Get the 'SurnamePrefix' element value. Surname prefix. Examples: van der, von, de
         * 
         * @return value
         */
        public String getSurnamePrefix() {
            return surnamePrefix;
        }

        /** 
         * Set the 'SurnamePrefix' element value. Surname prefix. Examples: van der, von, de
         * 
         * @param surnamePrefix
         */
        public void setSurnamePrefix(String surnamePrefix) {
            this.surnamePrefix = surnamePrefix;
        }

        /** 
         * Get the list of 'SurnameSuffix' element items. Surname suffixes and letters. Examples: Jr., Sr., III, Ret., Esq.
         * 
         * @return list
         */
        public List<String> getSurnameSuffixList() {
            return surnameSuffixList;
        }

        /** 
         * Set the list of 'SurnameSuffix' element items. Surname suffixes and letters. Examples: Jr., Sr., III, Ret., Esq.
         * 
         * @param list
         */
        public void setSurnameSuffixList(List<String> list) {
            surnameSuffixList = list;
        }
    }
}
