
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Baggage Applicable To contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PayFormListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="BankAccount"/>
 *     &lt;xs:enumeration value="Cash"/>
 *     &lt;xs:enumeration value="CreditCard"/>
 *     &lt;xs:enumeration value="DebitCard"/>
 *     &lt;xs:enumeration value="DirectBill"/>
 *     &lt;xs:enumeration value="LoyaltyRedemption"/>
 *     &lt;xs:enumeration value="MiscChargeOrder"/>
 *     &lt;xs:enumeration value="PaymentCard"/>
 *     &lt;xs:enumeration value="Voucher"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PayFormListType implements Serializable {
    BANK_ACCOUNT("BankAccount"), CASH("Cash"), CREDIT_CARD("CreditCard"), DEBIT_CARD(
            "DebitCard"), DIRECT_BILL("DirectBill"), LOYALTY_REDEMPTION(
            "LoyaltyRedemption"), MISC_CHARGE_ORDER("MiscChargeOrder"), PAYMENT_CARD(
            "PaymentCard"), VOUCHER("Voucher"), OTHER("Other");
    private final String value;

    private PayFormListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PayFormListType convert(String value) {
        for (PayFormListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
