
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PAYMENT PROCESSING  Information definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentProcessType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Associations"/>
 *         &lt;xs:element name="Status">
 *           &lt;xs:complexType>
 *             &lt;xs:complexContent>
 *               &lt;xs:extension base="ns:PaymentStatusType">
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="FailedPaymentInd"/>
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="PartialPaymentInd"/>
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="VerificationInd"/>
 *                 &lt;xs:attribute type="xs:boolean" use="optional" name="PriceVarianceInd"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:complexContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Amount">
 *           &lt;xs:complexType>
 *             &lt;xs:choice>
 *               &lt;xs:element ref="ns:AwardPricing"/>
 *               &lt;xs:element ref="ns:CombinationPricing"/>
 *               &lt;xs:element ref="ns:SimpleCurrencyPrice"/>
 *               &lt;xs:element ref="ns:DetailCurrencyPrice"/>
 *               &lt;xs:element ref="ns:EncodedCurrencyPrice"/>
 *             &lt;/xs:choice>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Method">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element ref="ns:VoucherMethod" minOccurs="0"/>
 *               &lt;xs:element ref="ns:RedemptionMethod" minOccurs="0"/>
 *               &lt;xs:element ref="ns:PaymentCardMethod" minOccurs="0"/>
 *               &lt;xs:element ref="ns:OtherMethod" minOccurs="0"/>
 *               &lt;xs:element ref="ns:MiscChargeMethod" minOccurs="0"/>
 *               &lt;xs:element ref="ns:DirectBillMethod" minOccurs="0"/>
 *               &lt;xs:element ref="ns:CashMethod" minOccurs="0"/>
 *               &lt;xs:element ref="ns:BankAccountMethod" minOccurs="0"/>
 *               &lt;xs:element ref="ns:Cheque" minOccurs="0"/>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element name="Variance" minOccurs="0">
 *           &lt;!-- Reference to inner class Variance -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Promotions" minOccurs="0">
 *           &lt;!-- Reference to inner class Promotions -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentProcessType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private Associations associations;
    private PaymentStatusType statusPaymentStatusType;
    private Boolean statusFailedPaymentInd;
    private Boolean statusPartialPaymentInd;
    private Boolean statusVerificationInd;
    private Boolean statusPriceVarianceInd;
    private int amountSelect = -1;
    private static final int AMOUNT_AWARD_PRICING_CHOICE = 0;
    private static final int AMOUNT_COMBINATION_PRICING_CHOICE = 1;
    private static final int AMOUNT_SIMPLE_CURRENCY_PRICE_CHOICE = 2;
    private static final int AMOUNT_DETAIL_CURRENCY_PRICE_CHOICE = 3;
    private static final int AMOUNT_ENCODED_CURRENCY_PRICE_CHOICE = 4;
    private AwardPriceUnitType amountAwardPricing;
    private CombinationPriceType amountCombinationPricing;
    private SimpleCurrencyPrice amountSimpleCurrencyPrice;
    private DetailCurrencyPriceType amountDetailCurrencyPrice;
    private EncodedCurrencyPrice amountEncodedCurrencyPrice;
    private VoucherMethodType methodVoucherMethod;
    private RedemptionMethodType methodRedemptionMethod;
    private PaymentCardMethodType methodPaymentCardMethod;
    private OtherMethodType methodOtherMethod;
    private MiscChargeMethodType methodMiscChargeMethod;
    private DirectBillMethodType methodDirectBillMethod;
    private CashMethodType methodCashMethod;
    private BankAccountMethodType methodBankAccountMethod;
    private Cheque methodCheque;
    private Variance variance;
    private Promotions promotions;

    /** 
     * Get the 'Associations' element value. Association(s), including Passenger and Group.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value. Association(s), including Passenger and Group.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public PaymentStatusType getStatusPaymentStatusType() {
        return statusPaymentStatusType;
    }

    /** 
     * Set the extension value.
     * 
     * @param statusPaymentStatusType
     */
    public void setStatusPaymentStatusType(
            PaymentStatusType statusPaymentStatusType) {
        this.statusPaymentStatusType = statusPaymentStatusType;
    }

    /** 
     * Get the 'FailedPaymentInd' attribute value. When TRUE, payment for this Order has failed.

    Note: Payment Failure status is specified in the PaymentStatus node.
     * 
     * @return value
     */
    public Boolean getStatusFailedPaymentInd() {
        return statusFailedPaymentInd;
    }

    /** 
     * Set the 'FailedPaymentInd' attribute value. When TRUE, payment for this Order has failed.

    Note: Payment Failure status is specified in the PaymentStatus node.
     * 
     * @param statusFailedPaymentInd
     */
    public void setStatusFailedPaymentInd(Boolean statusFailedPaymentInd) {
        this.statusFailedPaymentInd = statusFailedPaymentInd;
    }

    /** 
     * Get the 'PartialPaymentInd' attribute value. When TRUE, this Order has been partially paid.

    Note: Partial Payment status and information is specified in the PaymentStatus node.
     * 
     * @return value
     */
    public Boolean getStatusPartialPaymentInd() {
        return statusPartialPaymentInd;
    }

    /** 
     * Set the 'PartialPaymentInd' attribute value. When TRUE, this Order has been partially paid.

    Note: Partial Payment status and information is specified in the PaymentStatus node.
     * 
     * @param statusPartialPaymentInd
     */
    public void setStatusPartialPaymentInd(Boolean statusPartialPaymentInd) {
        this.statusPartialPaymentInd = statusPartialPaymentInd;
    }

    /** 
     * Get the 'VerificationInd' attribute value. When TRUE, payment for this Order requires additional authentication.

    Note: Payment Verification status and information is specified in the PaymentStatus node.
     * 
     * @return value
     */
    public Boolean getStatusVerificationInd() {
        return statusVerificationInd;
    }

    /** 
     * Set the 'VerificationInd' attribute value. When TRUE, payment for this Order requires additional authentication.

    Note: Payment Verification status and information is specified in the PaymentStatus node.
     * 
     * @param statusVerificationInd
     */
    public void setStatusVerificationInd(Boolean statusVerificationInd) {
        this.statusVerificationInd = statusVerificationInd;
    }

    /** 
     * Get the 'PriceVarianceInd' attribute value. When TRUE, a price variance was applied.
     * 
     * @return value
     */
    public Boolean getStatusPriceVarianceInd() {
        return statusPriceVarianceInd;
    }

    /** 
     * Set the 'PriceVarianceInd' attribute value. When TRUE, a price variance was applied.
     * 
     * @param statusPriceVarianceInd
     */
    public void setStatusPriceVarianceInd(Boolean statusPriceVarianceInd) {
        this.statusPriceVarianceInd = statusPriceVarianceInd;
    }

    private void setAmountSelect(int choice) {
        if (amountSelect == -1) {
            amountSelect = choice;
        } else if (amountSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearAmountSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearAmountSelect() {
        amountSelect = -1;
    }

    /** 
     * Check if AmountAwardPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountAwardPricing() {
        return amountSelect == AMOUNT_AWARD_PRICING_CHOICE;
    }

    /** 
     * Get the 'AwardPricing' element value.
     * 
     * @return value
     */
    public AwardPriceUnitType getAmountAwardPricing() {
        return amountAwardPricing;
    }

    /** 
     * Set the 'AwardPricing' element value.
     * 
     * @param amountAwardPricing
     */
    public void setAmountAwardPricing(AwardPriceUnitType amountAwardPricing) {
        setAmountSelect(AMOUNT_AWARD_PRICING_CHOICE);
        this.amountAwardPricing = amountAwardPricing;
    }

    /** 
     * Check if AmountCombinationPricing is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountCombinationPricing() {
        return amountSelect == AMOUNT_COMBINATION_PRICING_CHOICE;
    }

    /** 
     * Get the 'CombinationPricing' element value.
     * 
     * @return value
     */
    public CombinationPriceType getAmountCombinationPricing() {
        return amountCombinationPricing;
    }

    /** 
     * Set the 'CombinationPricing' element value.
     * 
     * @param amountCombinationPricing
     */
    public void setAmountCombinationPricing(
            CombinationPriceType amountCombinationPricing) {
        setAmountSelect(AMOUNT_COMBINATION_PRICING_CHOICE);
        this.amountCombinationPricing = amountCombinationPricing;
    }

    /** 
     * Check if AmountSimpleCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountSimpleCurrencyPrice() {
        return amountSelect == AMOUNT_SIMPLE_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'SimpleCurrencyPrice' element value.
     * 
     * @return value
     */
    public SimpleCurrencyPrice getAmountSimpleCurrencyPrice() {
        return amountSimpleCurrencyPrice;
    }

    /** 
     * Set the 'SimpleCurrencyPrice' element value.
     * 
     * @param amountSimpleCurrencyPrice
     */
    public void setAmountSimpleCurrencyPrice(
            SimpleCurrencyPrice amountSimpleCurrencyPrice) {
        setAmountSelect(AMOUNT_SIMPLE_CURRENCY_PRICE_CHOICE);
        this.amountSimpleCurrencyPrice = amountSimpleCurrencyPrice;
    }

    /** 
     * Check if AmountDetailCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountDetailCurrencyPrice() {
        return amountSelect == AMOUNT_DETAIL_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'DetailCurrencyPrice' element value.
     * 
     * @return value
     */
    public DetailCurrencyPriceType getAmountDetailCurrencyPrice() {
        return amountDetailCurrencyPrice;
    }

    /** 
     * Set the 'DetailCurrencyPrice' element value.
     * 
     * @param amountDetailCurrencyPrice
     */
    public void setAmountDetailCurrencyPrice(
            DetailCurrencyPriceType amountDetailCurrencyPrice) {
        setAmountSelect(AMOUNT_DETAIL_CURRENCY_PRICE_CHOICE);
        this.amountDetailCurrencyPrice = amountDetailCurrencyPrice;
    }

    /** 
     * Check if AmountEncodedCurrencyPrice is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmountEncodedCurrencyPrice() {
        return amountSelect == AMOUNT_ENCODED_CURRENCY_PRICE_CHOICE;
    }

    /** 
     * Get the 'EncodedCurrencyPrice' element value.
     * 
     * @return value
     */
    public EncodedCurrencyPrice getAmountEncodedCurrencyPrice() {
        return amountEncodedCurrencyPrice;
    }

    /** 
     * Set the 'EncodedCurrencyPrice' element value.
     * 
     * @param amountEncodedCurrencyPrice
     */
    public void setAmountEncodedCurrencyPrice(
            EncodedCurrencyPrice amountEncodedCurrencyPrice) {
        setAmountSelect(AMOUNT_ENCODED_CURRENCY_PRICE_CHOICE);
        this.amountEncodedCurrencyPrice = amountEncodedCurrencyPrice;
    }

    /** 
     * Get the 'VoucherMethod' element value.
     * 
     * @return value
     */
    public VoucherMethodType getMethodVoucherMethod() {
        return methodVoucherMethod;
    }

    /** 
     * Set the 'VoucherMethod' element value.
     * 
     * @param methodVoucherMethod
     */
    public void setMethodVoucherMethod(VoucherMethodType methodVoucherMethod) {
        this.methodVoucherMethod = methodVoucherMethod;
    }

    /** 
     * Get the 'RedemptionMethod' element value.
     * 
     * @return value
     */
    public RedemptionMethodType getMethodRedemptionMethod() {
        return methodRedemptionMethod;
    }

    /** 
     * Set the 'RedemptionMethod' element value.
     * 
     * @param methodRedemptionMethod
     */
    public void setMethodRedemptionMethod(
            RedemptionMethodType methodRedemptionMethod) {
        this.methodRedemptionMethod = methodRedemptionMethod;
    }

    /** 
     * Get the 'PaymentCardMethod' element value.
     * 
     * @return value
     */
    public PaymentCardMethodType getMethodPaymentCardMethod() {
        return methodPaymentCardMethod;
    }

    /** 
     * Set the 'PaymentCardMethod' element value.
     * 
     * @param methodPaymentCardMethod
     */
    public void setMethodPaymentCardMethod(
            PaymentCardMethodType methodPaymentCardMethod) {
        this.methodPaymentCardMethod = methodPaymentCardMethod;
    }

    /** 
     * Get the 'OtherMethod' element value.
     * 
     * @return value
     */
    public OtherMethodType getMethodOtherMethod() {
        return methodOtherMethod;
    }

    /** 
     * Set the 'OtherMethod' element value.
     * 
     * @param methodOtherMethod
     */
    public void setMethodOtherMethod(OtherMethodType methodOtherMethod) {
        this.methodOtherMethod = methodOtherMethod;
    }

    /** 
     * Get the 'MiscChargeMethod' element value.
     * 
     * @return value
     */
    public MiscChargeMethodType getMethodMiscChargeMethod() {
        return methodMiscChargeMethod;
    }

    /** 
     * Set the 'MiscChargeMethod' element value.
     * 
     * @param methodMiscChargeMethod
     */
    public void setMethodMiscChargeMethod(
            MiscChargeMethodType methodMiscChargeMethod) {
        this.methodMiscChargeMethod = methodMiscChargeMethod;
    }

    /** 
     * Get the 'DirectBillMethod' element value.
     * 
     * @return value
     */
    public DirectBillMethodType getMethodDirectBillMethod() {
        return methodDirectBillMethod;
    }

    /** 
     * Set the 'DirectBillMethod' element value.
     * 
     * @param methodDirectBillMethod
     */
    public void setMethodDirectBillMethod(
            DirectBillMethodType methodDirectBillMethod) {
        this.methodDirectBillMethod = methodDirectBillMethod;
    }

    /** 
     * Get the 'CashMethod' element value.
     * 
     * @return value
     */
    public CashMethodType getMethodCashMethod() {
        return methodCashMethod;
    }

    /** 
     * Set the 'CashMethod' element value.
     * 
     * @param methodCashMethod
     */
    public void setMethodCashMethod(CashMethodType methodCashMethod) {
        this.methodCashMethod = methodCashMethod;
    }

    /** 
     * Get the 'BankAccountMethod' element value.
     * 
     * @return value
     */
    public BankAccountMethodType getMethodBankAccountMethod() {
        return methodBankAccountMethod;
    }

    /** 
     * Set the 'BankAccountMethod' element value.
     * 
     * @param methodBankAccountMethod
     */
    public void setMethodBankAccountMethod(
            BankAccountMethodType methodBankAccountMethod) {
        this.methodBankAccountMethod = methodBankAccountMethod;
    }

    /** 
     * Get the 'Cheque' element value.
     * 
     * @return value
     */
    public Cheque getMethodCheque() {
        return methodCheque;
    }

    /** 
     * Set the 'Cheque' element value.
     * 
     * @param methodCheque
     */
    public void setMethodCheque(Cheque methodCheque) {
        this.methodCheque = methodCheque;
    }

    /** 
     * Get the 'Variance' element value.
     * 
     * @return value
     */
    public Variance getVariance() {
        return variance;
    }

    /** 
     * Set the 'Variance' element value.
     * 
     * @param variance
     */
    public void setVariance(Variance variance) {
        this.variance = variance;
    }

    /** 
     * Get the 'Promotions' element value.
     * 
     * @return value
     */
    public Promotions getPromotions() {
        return promotions;
    }

    /** 
     * Set the 'Promotions' element value.
     * 
     * @param promotions
     */
    public void setPromotions(Promotions promotions) {
        this.promotions = promotions;
    }
    /** 
     * Price variance actually applied during payment processing.

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Variance" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount"/>
     *       &lt;xs:element ref="ns:Associations"/>
     *       &lt;xs:element type="ns:PriceVarianceRuleType" name="Rule" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Variance implements Serializable
    {
        private CurrencyAmountOptType amount;
        private Associations associations;
        private PriceVarianceRuleType rule;

        /** 
         * Get the 'Amount' element value. Price Variance Amount. Example: .67 USD
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value. Price Variance Amount. Example: .67 USD
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'Associations' element value. Association(s), including Passenger and Group.
         * 
         * @return value
         */
        public Associations getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value. Association(s), including Passenger and Group.
         * 
         * @param associations
         */
        public void setAssociations(Associations associations) {
            this.associations = associations;
        }

        /** 
         * Get the 'Rule' element value. Price Variance Rule Applied.
         * 
         * @return value
         */
        public PriceVarianceRuleType getRule() {
            return rule;
        }

        /** 
         * Set the 'Rule' element value. Price Variance Rule Applied.
         * 
         * @param rule
         */
        public void setRule(PriceVarianceRuleType rule) {
            this.rule = rule;
        }
    }
    /** 
     * Applied Promotion(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Promotion" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Promotion -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Promotions implements Serializable
    {
        private List<Promotion> promotionList = new ArrayList<Promotion>();

        /** 
         * Get the list of 'Promotion' element items.
         * 
         * @return list
         */
        public List<Promotion> getPromotionList() {
            return promotionList;
        }

        /** 
         * Set the list of 'Promotion' element items.
         * 
         * @param list
         */
        public void setPromotionList(List<Promotion> list) {
            promotionList = list;
        }
        /** 
         * Promotion Detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotion" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:PromotionType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="ns:Associations"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Promotion extends PromotionType implements
            Serializable
        {
            private Associations associations;

            /** 
             * Get the 'Associations' element value. Association(s), including Passenger and Group.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value. Association(s), including Passenger and Group.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }
        }
    }
}
