
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * PRE-PAID TRAVEL Programs.

 Notes:
 1. Supports pricing flight offers and/ or other benefits from non-revenue and Air Pass Program certificates.

 2. Each Prepaid Travel Program MUST be associated to ONE individual Traveler.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrePaidProgramQualifier">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *         &lt;xs:sequence>
 *           &lt;xs:element name="PrepaidProgram">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:AirPassCore"/>
 *                 &lt;xs:element ref="ns:AirPassDetail"/>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class PrePaidProgramQualifier extends AssociatedObjectBaseType implements
    Serializable
{
    private AirPassCoreType prepaidProgramAirPassCore;
    private AirPassDetailType prepaidProgramAirPassDetail;

    /** 
     * Get the 'AirPassCore' element value.
     * 
     * @return value
     */
    public AirPassCoreType getPrepaidProgramAirPassCore() {
        return prepaidProgramAirPassCore;
    }

    /** 
     * Set the 'AirPassCore' element value.
     * 
     * @param prepaidProgramAirPassCore
     */
    public void setPrepaidProgramAirPassCore(
            AirPassCoreType prepaidProgramAirPassCore) {
        this.prepaidProgramAirPassCore = prepaidProgramAirPassCore;
    }

    /** 
     * Get the 'AirPassDetail' element value.
     * 
     * @return value
     */
    public AirPassDetailType getPrepaidProgramAirPassDetail() {
        return prepaidProgramAirPassDetail;
    }

    /** 
     * Set the 'AirPassDetail' element value.
     * 
     * @param prepaidProgramAirPassDetail
     */
    public void setPrepaidProgramAirPassDetail(
            AirPassDetailType prepaidProgramAirPassDetail) {
        this.prepaidProgramAirPassDetail = prepaidProgramAirPassDetail;
    }
}
