
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Price Class Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceClassAssocListItemType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Disclosure"/>
 *     &lt;xs:enumeration value="MediaGroup"/>
 *     &lt;xs:enumeration value="MediaItem"/>
 *     &lt;xs:enumeration value="Penalty"/>
 *     &lt;xs:enumeration value="Service"/>
 *     &lt;xs:enumeration value="ServiceBundle"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PriceClassAssocListItemType implements Serializable {
    DISCLOSURE("Disclosure"), MEDIA_GROUP("MediaGroup"), MEDIA_ITEM("MediaItem"), PENALTY(
            "Penalty"), SERVICE("Service"), SERVICE_BUNDLE("ServiceBundle");
    private final String value;

    private PriceClassAssocListItemType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PriceClassAssocListItemType convert(String value) {
        for (PriceClassAssocListItemType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
