
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Price Class Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceClassAssocType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Association" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Association -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceClassAssocType implements Serializable
{
    private List<Association> associationList = new ArrayList<Association>();

    /** 
     * Get the list of 'Association' element items.
     * 
     * @return list
     */
    public List<Association> getAssociationList() {
        return associationList;
    }

    /** 
     * Set the list of 'Association' element items.
     * 
     * @param list
     */
    public void setAssociationList(List<Association> list) {
        associationList = list;
    }
    /** 
     * Price Class Association Detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Association" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Type"/>
     *       &lt;xs:element type="xs:string" name="ReferenceValue"/>
     *       &lt;xs:element ref="ns:ServiceReference" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Association implements Serializable
    {
        private String type;
        private String referenceValue;
        private List<ServiceReference> serviceReferenceList = new ArrayList<ServiceReference>();

        /** 
         * Get the 'Type' element value. Named association type. Examples: ServiceBundle, MediaGroup
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' element value. Named association type. Examples: ServiceBundle, MediaGroup
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'ReferenceValue' element value. Associated object instance value. Example: mediagrp1
         * 
         * @return value
         */
        public String getReferenceValue() {
            return referenceValue;
        }

        /** 
         * Set the 'ReferenceValue' element value. Associated object instance value. Example: mediagrp1
         * 
         * @param referenceValue
         */
        public void setReferenceValue(String referenceValue) {
            this.referenceValue = referenceValue;
        }

        /** 
         * Get the list of 'ServiceReference' element items.
         * 
         * @return list
         */
        public List<ServiceReference> getServiceReferenceList() {
            return serviceReferenceList;
        }

        /** 
         * Set the list of 'ServiceReference' element items.
         * 
         * @param list
         */
        public void setServiceReferenceList(List<ServiceReference> list) {
            serviceReferenceList = list;
        }
    }
}
