
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PRICE CLASS definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceClassType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Name"/>
 *         &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
 *         &lt;xs:element type="ns:Descriptions" name="Descriptions" minOccurs="0"/>
 *         &lt;xs:element ref="ns:FareBasisCode" minOccurs="0"/>
 *         &lt;xs:element ref="ns:ClassOfService" minOccurs="0" maxOccurs="unbounded"/>
 *         &lt;xs:element type="ns:PriceClassAssocType" name="Associations" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="DisplayOrder" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceClassType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private String name;
    private String code;
    private Descriptions descriptions;
    private FareBasisCodeType fareBasisCode;
    private List<FlightCOSCoreType> classOfServiceList = new ArrayList<FlightCOSCoreType>();
    private PriceClassAssocType associations;
    private String displayOrder;

    /** 
     * Get the 'Name' element value. Price class name. Example: SUPERSAVER
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Price class name. Example: SUPERSAVER
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Code' element value. Price class code. Example: 1, ABC
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Price class code. Example: 1, ABC
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Descriptions' element value.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'FareBasisCode' element value. Fare Basis Code with optional application. Example: Y26
     * 
     * @return value
     */
    public FareBasisCodeType getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. Fare Basis Code with optional application. Example: Y26
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(FareBasisCodeType fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the list of 'ClassOfService' element items.
     * 
     * @return list
     */
    public List<FlightCOSCoreType> getClassOfServiceList() {
        return classOfServiceList;
    }

    /** 
     * Set the list of 'ClassOfService' element items.
     * 
     * @param list
     */
    public void setClassOfServiceList(List<FlightCOSCoreType> list) {
        classOfServiceList = list;
    }

    /** 
     * Get the 'Associations' element value. Price Class Associations.
     * 
     * @return value
     */
    public PriceClassAssocType getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value. Price Class Associations.
     * 
     * @param associations
     */
    public void setAssociations(PriceClassAssocType associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'DisplayOrder' element value. The Airline requested default display order (in a client application) for this price class. Example: 2
     * 
     * @return value
     */
    public String getDisplayOrder() {
        return displayOrder;
    }

    /** 
     * Set the 'DisplayOrder' element value. The Airline requested default display order (in a client application) for this price class. Example: 2
     * 
     * @param displayOrder
     */
    public void setDisplayOrder(String displayOrder) {
        this.displayOrder = displayOrder;
    }
}
