
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Core Priced Flight Offer definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricedFlightOfferCoreType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:OfferPriceLeadType" name="OfferPrice"/>
 *         &lt;xs:element ref="ns:FareDetail" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="LeadPricedInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="LeadPricingIncInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricedFlightOfferCoreType extends KeyWithMetaObjectBaseType
    implements Serializable
{
    private OfferPriceLeadType offerPrice;
    private FareDetailType fareDetail;
    private Boolean leadPricedInd;
    private Boolean leadPricingIncInd;

    /** 
     * Get the 'OfferPrice' element value. Fare Offer and Lead Calendar Pricing information.
     * 
     * @return value
     */
    public OfferPriceLeadType getOfferPrice() {
        return offerPrice;
    }

    /** 
     * Set the 'OfferPrice' element value. Fare Offer and Lead Calendar Pricing information.
     * 
     * @param offerPrice
     */
    public void setOfferPrice(OfferPriceLeadType offerPrice) {
        this.offerPrice = offerPrice;
    }

    /** 
     * Get the 'FareDetail' element value.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }

    /** 
     * Get the 'LeadPricedInd' attribute value. 
                      When TRUE, this is a lead pricing generated priced flight offer.
                    
     * 
     * @return value
     */
    public Boolean getLeadPricedInd() {
        return leadPricedInd;
    }

    /** 
     * Set the 'LeadPricedInd' attribute value. 
                      When TRUE, this is a lead pricing generated priced flight offer.
                    
     * 
     * @param leadPricedInd
     */
    public void setLeadPricedInd(Boolean leadPricedInd) {
        this.leadPricedInd = leadPricedInd;
    }

    /** 
     * Get the 'LeadPricingIncInd' attribute value. 
                      When TRUE, additional lead pricing offers are included with this proced flight offer.
                    
     * 
     * @return value
     */
    public Boolean getLeadPricingIncInd() {
        return leadPricingIncInd;
    }

    /** 
     * Set the 'LeadPricingIncInd' attribute value. 
                      When TRUE, additional lead pricing offers are included with this proced flight offer.
                    
     * 
     * @param leadPricingIncInd
     */
    public void setLeadPricingIncInd(Boolean leadPricingIncInd) {
        this.leadPricingIncInd = leadPricingIncInd;
    }
}
