
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.sql.Date;

/** 
 * COUPON-RELATED PRICING definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="Date" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Time" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LocationCode" minOccurs="0"/>
 *     &lt;xs:element ref="ns:CountryCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricingInfoType implements Serializable
{
    private Date date;
    private String time;
    private String locationCode;
    private CountryCodeType countryCode;

    /** 
     * Get the 'Date' element value. Booked Itinerary Pricing Date. Example: 2017-01-13

    Note: This is the date the booked itinerary was priced.
     * 
     * @return value
     */
    public Date getDate() {
        return date;
    }

    /** 
     * Set the 'Date' element value. Booked Itinerary Pricing Date. Example: 2017-01-13

    Note: This is the date the booked itinerary was priced.
     * 
     * @param date
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /** 
     * Get the 'Time' element value. Booked Itinerary Pricing Time. Example: 09:15

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @return value
     */
    public String getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value. Booked Itinerary Pricing Time. Example: 09:15

    Encoding Scheme: ISO 8601 Military/ 24 Hour Format (HH:MM)
     * 
     * @param time
     */
    public void setTime(String time) {
        this.time = time;
    }

    /** 
     * Get the 'LocationCode' element value. Pricing Location. Example: JFK

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @return value
     */
    public String getLocationCode() {
        return locationCode;
    }

    /** 
     * Set the 'LocationCode' element value. Pricing Location. Example: JFK

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @param locationCode
     */
    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    /** 
     * Get the 'CountryCode' element value. Booked Itinerary Pricing Country Code. Example: US

    Encoding Scheme: ISO 3166-1 (two character) Country Code

    Note: This is the code used to identify the country in which the booked itinerary was priced.
     * 
     * @return value
     */
    public CountryCodeType getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. Booked Itinerary Pricing Country Code. Example: US

    Encoding Scheme: ISO 3166-1 (two character) Country Code

    Note: This is the code used to identify the country in which the booked itinerary was priced.
     * 
     * @param countryCode
     */
    public void setCountryCode(CountryCodeType countryCode) {
        this.countryCode = countryCode;
    }
}
