
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Promotion(s) Information.

 Notes:
 1. Supports pricing discounts and/ or other benefits for Travelers with Promotion Codes issued (or sponsored by) Airlines, Travel Agencies and/ or Companies.

 2. Promotion Codes may be associated to individual Travelers but will apply to ALL Travelers if no associations are specified.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PromotionQualifiers">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns:PromotionType">
 *         &lt;xs:attribute type="xs:anySimpleType" name="CC_IssuingCountryInd"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class PromotionQualifiers extends PromotionType implements Serializable
{
    private String CCIssuingCountryInd;

    /** 
     * Get the 'CC_IssuingCountryInd' attribute value. Country where the Credit Card was issued.
     * 
     * @return value
     */
    public String getCCIssuingCountryInd() {
        return CCIssuingCountryInd;
    }

    /** 
     * Set the 'CC_IssuingCountryInd' attribute value. Country where the Credit Card was issued.
     * 
     * @param CCIssuingCountryInd
     */
    public void setCCIssuingCountryInd(String CCIssuingCountryInd) {
        this.CCIssuingCountryInd = CCIssuingCountryInd;
    }
}
