
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Shopping Request Qualifiers.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QualifiersType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Qualifier" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Qualifier -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class QualifiersType implements Serializable
{
    private List<Qualifier> qualifierList = new ArrayList<Qualifier>();

    /** 
     * Get the list of 'Qualifier' element items.
     * 
     * @return list
     */
    public List<Qualifier> getQualifierList() {
        return qualifierList;
    }

    /** 
     * Set the list of 'Qualifier' element items.
     * 
     * @param list
     */
    public void setQualifierList(List<Qualifier> list) {
        qualifierList = list;
    }
    /** 
     * Qualifier choices.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifier" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:SeatQualifier" minOccurs="0"/>
     *           &lt;xs:element ref="ns:ServiceQualifier" minOccurs="0"/>
     *           &lt;xs:element ref="ns:Associations" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Qualifier extends KeyWithMetaObjectBaseType implements
        Serializable
    {
        private SeatQualifier seatQualifier;
        private ServiceQualifierPriceType serviceQualifier;
        private Associations associations;

        /** 
         * Get the 'SeatQualifier' element value.
         * 
         * @return value
         */
        public SeatQualifier getSeatQualifier() {
            return seatQualifier;
        }

        /** 
         * Set the 'SeatQualifier' element value.
         * 
         * @param seatQualifier
         */
        public void setSeatQualifier(SeatQualifier seatQualifier) {
            this.seatQualifier = seatQualifier;
        }

        /** 
         * Get the 'ServiceQualifier' element value.
         * 
         * @return value
         */
        public ServiceQualifierPriceType getServiceQualifier() {
            return serviceQualifier;
        }

        /** 
         * Set the 'ServiceQualifier' element value.
         * 
         * @param serviceQualifier
         */
        public void setServiceQualifier(
                ServiceQualifierPriceType serviceQualifier) {
            this.serviceQualifier = serviceQualifier;
        }

        /** 
         * Get the 'Associations' element value.
         * 
         * @return value
         */
        public Associations getAssociations() {
            return associations;
        }

        /** 
         * Set the 'Associations' element value.
         * 
         * @param associations
         */
        public void setAssociations(Associations associations) {
            this.associations = associations;
        }
    }
}
