
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Effective/ Expiration Calendar Quarter Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QuarterPeriodRepType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Effective" minOccurs="0">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Effective -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Expiration" minOccurs="0">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class Expiration -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class QuarterPeriodRepType implements Serializable
{
    private Effective effective;
    private Expiration expiration;

    /** 
     * Get the 'Effective' element value. Effective (start) quarter.
    Example: 1Q (JAN-MAR)
     * 
     * @return value
     */
    public Effective getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' element value. Effective (start) quarter.
    Example: 1Q (JAN-MAR)
     * 
     * @param effective
     */
    public void setEffective(Effective effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' element value. Expiration (end) quarter.
    Example: 3Q (JUL-SEP)
     * 
     * @return value
     */
    public Expiration getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' element value. Expiration (end) quarter.
    Example: 3Q (JUL-SEP)
     * 
     * @param expiration
     */
    public void setExpiration(Expiration expiration) {
        this.expiration = expiration;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="1Q"/>
     *     &lt;xs:enumeration value="2Q"/>
     *     &lt;xs:enumeration value="3Q"/>
     *     &lt;xs:enumeration value="4Q"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Effective implements Serializable {
        _1_Q("1Q"), _2_Q("2Q"), _3_Q("3Q"), _4_Q("4Q");
        private final String value;

        private Effective(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Effective convert(String value) {
            for (Effective inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="1Q"/>
     *     &lt;xs:enumeration value="2Q"/>
     *     &lt;xs:enumeration value="3Q"/>
     *     &lt;xs:enumeration value="4Q"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Expiration implements Serializable {
        _1_Q("1Q"), _2_Q("2Q"), _3_Q("3Q"), _4_Q("4Q");
        private final String value;

        private Expiration(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Expiration convert(String value) {
            for (Expiration inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
