
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for a Redemption Unit List.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RedempUnitListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Miles"/>
 *     &lt;xs:enumeration value="Points"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RedempUnitListType implements Serializable {
    MILES("Miles"), POINTS("Points"), OTHER("Other");
    private final String value;

    private RedempUnitListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RedempUnitListType convert(String value) {
        for (RedempUnitListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
