
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * REFERENCE POINT RADIUS QUERY representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReferencePointQueryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ReferencePoints" minOccurs="0">
 *       &lt;!-- Reference to inner class ReferencePoints -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Proximity" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Proximity -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReferencePointQueryType implements Serializable
{
    private ReferencePoints referencePoints;
    private List<Proximity> proximityList = new ArrayList<Proximity>();
    private PreferenceAttrGroup preferenceAttrGroup;

    /** 
     * Get the 'ReferencePoints' element value.
     * 
     * @return value
     */
    public ReferencePoints getReferencePoints() {
        return referencePoints;
    }

    /** 
     * Set the 'ReferencePoints' element value.
     * 
     * @param referencePoints
     */
    public void setReferencePoints(ReferencePoints referencePoints) {
        this.referencePoints = referencePoints;
    }

    /** 
     * Get the list of 'Proximity' element items.
     * 
     * @return list
     */
    public List<Proximity> getProximityList() {
        return proximityList;
    }

    /** 
     * Set the list of 'Proximity' element items.
     * 
     * @param list
     */
    public void setProximityList(List<Proximity> list) {
        proximityList = list;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getPreferenceAttrGroup() {
        return preferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param preferenceAttrGroup
     */
    public void setPreferenceAttrGroup(PreferenceAttrGroup preferenceAttrGroup) {
        this.preferenceAttrGroup = preferenceAttrGroup;
    }
    /** 
     * Reference Point(s), e.g. Cities and Metro Areas.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReferencePoints" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ReferencePoint" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ReferencePoint -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReferencePoints implements Serializable
    {
        private List<ReferencePoint> referencePointList = new ArrayList<ReferencePoint>();

        /** 
         * Get the list of 'ReferencePoint' element items.
         * 
         * @return list
         */
        public List<ReferencePoint> getReferencePointList() {
            return referencePointList;
        }

        /** 
         * Set the list of 'ReferencePoint' element items.
         * 
         * @param list
         */
        public void setReferencePointList(List<ReferencePoint> list) {
            referencePointList = list;
        }
        /** 
         * Reference Point Name or Code.  Examples: TAMPA, TPA
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReferencePoint" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ReferencePoint implements Serializable
        {
            private String string;
            private PreferenceAttrGroup preferenceAttrGroup;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @return value
             */
            public PreferenceAttrGroup getPreferenceAttrGroup() {
                return preferenceAttrGroup;
            }

            /** 
             * Set the 'PreferenceAttrGroup' attributeGroup value.
             * 
             * @param preferenceAttrGroup
             */
            public void setPreferenceAttrGroup(
                    PreferenceAttrGroup preferenceAttrGroup) {
                this.preferenceAttrGroup = preferenceAttrGroup;
            }
        }
    }
    /** 
     * Reference Point Proximity.

    Notes:
    1. This contains either the requested maximum distance search radius values -or- the actual Proximity information, which is typically used to specify the results from the named location radius search.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Proximity" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ReferencePoint">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Application"/>
     *       &lt;xs:element name="AreaValue">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:decimal">
     *               &lt;xs:attribute type="xs:string" use="optional" name="UOM"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Proximity implements Serializable
    {
        private String referencePointString;
        private PreferenceAttrGroup referencePointPreferenceAttrGroup;
        private String application;
        private BigDecimal areaValueDecimal;
        private String areaValueUOM;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getReferencePointString() {
            return referencePointString;
        }

        /** 
         * Set the extension value.
         * 
         * @param referencePointString
         */
        public void setReferencePointString(String referencePointString) {
            this.referencePointString = referencePointString;
        }

        /** 
         * Get the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @return value
         */
        public PreferenceAttrGroup getReferencePointPreferenceAttrGroup() {
            return referencePointPreferenceAttrGroup;
        }

        /** 
         * Set the 'PreferenceAttrGroup' attributeGroup value.
         * 
         * @param referencePointPreferenceAttrGroup
         */
        public void setReferencePointPreferenceAttrGroup(
                PreferenceAttrGroup referencePointPreferenceAttrGroup) {
            this.referencePointPreferenceAttrGroup = referencePointPreferenceAttrGroup;
        }

        /** 
         * Get the 'Application' element value. Proximity Data Application.  Example: SearchRadius, ActualProximity, Other
         * 
         * @return value
         */
        public String getApplication() {
            return application;
        }

        /** 
         * Set the 'Application' element value. Proximity Data Application.  Example: SearchRadius, ActualProximity, Other
         * 
         * @param application
         */
        public void setApplication(String application) {
            this.application = application;
        }

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public BigDecimal getAreaValueDecimal() {
            return areaValueDecimal;
        }

        /** 
         * Set the extension value.
         * 
         * @param areaValueDecimal
         */
        public void setAreaValueDecimal(BigDecimal areaValueDecimal) {
            this.areaValueDecimal = areaValueDecimal;
        }

        /** 
         * Get the 'UOM' attribute value. Distance unit of measure. Examples: Miles, Kilometers
         * 
         * @return value
         */
        public String getAreaValueUOM() {
            return areaValueUOM;
        }

        /** 
         * Set the 'UOM' attribute value. Distance unit of measure. Examples: Miles, Kilometers
         * 
         * @param areaValueUOM
         */
        public void setAreaValueUOM(String areaValueUOM) {
            this.areaValueUOM = areaValueUOM;
        }
    }
}
