
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * REMARK helper object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RemarkType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Remark" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Remark -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RemarkType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private List<Remark> remarkList = new ArrayList<Remark>();

    /** 
     * Get the list of 'Remark' element items.
     * 
     * @return list
     */
    public List<Remark> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items.
     * 
     * @param list
     */
    public void setRemarkList(List<Remark> list) {
        remarkList = list;
    }
    /** 
     * Remark Text.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="DisplayInd"/>
     *         &lt;xs:attribute type="xs:dateTime" use="optional" name="Timestamp"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remark implements Serializable
    {
        private String string;
        private Boolean displayInd;
        private Date timestamp;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'DisplayInd' attribute value. When TRUE, this remark should be displayed.

        Notes:
        1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specification. 
         * 
         * @return value
         */
        public Boolean getDisplayInd() {
            return displayInd;
        }

        /** 
         * Set the 'DisplayInd' attribute value. When TRUE, this remark should be displayed.

        Notes:
        1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specification. 
         * 
         * @param displayInd
         */
        public void setDisplayInd(Boolean displayInd) {
            this.displayInd = displayInd;
        }

        /** 
         * Get the 'Timestamp' attribute value. Remark creation timestamp.  Example: 2017-01-13T13:59:38Z
         * 
         * @return value
         */
        public Date getTimestamp() {
            return timestamp;
        }

        /** 
         * Set the 'Timestamp' attribute value. Remark creation timestamp.  Example: 2017-01-13T13:59:38Z
         * 
         * @param timestamp
         */
        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }
    }
}
