
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for a set of rendering instructions for converting XML data in a designated element into a specified display format or instructions to display a pre-rendered version of the data.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RenderingInstructionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Method"/>
 *     &lt;xs:element type="xs:string" name="OutputFormat"/>
 *     &lt;xs:element type="xs:string" name="AttachmentURI" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AttachmentSize" minOccurs="0"/>
 *     &lt;xs:element type="ns:RenderingParameterType" name="Parameters" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Overview" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class RenderingInstructionsType implements Serializable
{
    private String method;
    private String outputFormat;
    private String attachmentURI;
    private String attachmentSize;
    private RenderingParameterType parameters;
    private String overview;
    private String refs;

    /** 
     * Get the 'Method' element value. Rendering Method.  Example: Narrative, XSLT, Other
     * 
     * @return value
     */
    public String getMethod() {
        return method;
    }

    /** 
     * Set the 'Method' element value. Rendering Method.  Example: Narrative, XSLT, Other
     * 
     * @param method
     */
    public void setMethod(String method) {
        this.method = method;
    }

    /** 
     * Get the 'OutputFormat' element value. An identifier for a file format or content type of the rendered output.
     * 
     * @return value
     */
    public String getOutputFormat() {
        return outputFormat;
    }

    /** 
     * Set the 'OutputFormat' element value. An identifier for a file format or content type of the rendered output.
     * 
     * @param outputFormat
     */
    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    /** 
     * Get the 'AttachmentURI' element value. Rendering Attachment URI, e.g. for a stylesheet.
     * 
     * @return value
     */
    public String getAttachmentURI() {
        return attachmentURI;
    }

    /** 
     * Set the 'AttachmentURI' element value. Rendering Attachment URI, e.g. for a stylesheet.
     * 
     * @param attachmentURI
     */
    public void setAttachmentURI(String attachmentURI) {
        this.attachmentURI = attachmentURI;
    }

    /** 
     * Get the 'AttachmentSize' element value. Attachment Size Value. Example: 57KB
     * 
     * @return value
     */
    public String getAttachmentSize() {
        return attachmentSize;
    }

    /** 
     * Set the 'AttachmentSize' element value. Attachment Size Value. Example: 57KB
     * 
     * @param attachmentSize
     */
    public void setAttachmentSize(String attachmentSize) {
        this.attachmentSize = attachmentSize;
    }

    /** 
     * Get the 'Parameters' element value. Rendering Instruction Parameters.

    Notes: This is typically used for XSLT.
     * 
     * @return value
     */
    public RenderingParameterType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Rendering Instruction Parameters.

    Notes: This is typically used for XSLT.
     * 
     * @param parameters
     */
    public void setParameters(RenderingParameterType parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'Overview' element value. An overview of the rendering method or style.
     * 
     * @return value
     */
    public String getOverview() {
        return overview;
    }

    /** 
     * Set the 'Overview' element value. An overview of the rendering method or style.
     * 
     * @param overview
     */
    public void setOverview(String overview) {
        this.overview = overview;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
