
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for a Rendering Type constrained list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RenderingTypeListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Narrative"/>
 *     &lt;xs:enumeration value="XSLT"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RenderingTypeListType implements Serializable {
    NARRATIVE("Narrative"), XSLT("XSLT"), OTHER("Other");
    private final String value;

    private RenderingTypeListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RenderingTypeListType convert(String value) {
        for (RenderingTypeListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
