
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * A data type for Rule Status contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleStatusListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ActionRequired"/>
 *     &lt;xs:enumeration value="RuleExecuted"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum RuleStatusListType implements Serializable {
    ACTION_REQUIRED("ActionRequired"), RULE_EXECUTED("RuleExecuted");
    private final String value;

    private RuleStatusListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static RuleStatusListType convert(String value) {
        for (RuleStatusListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
