
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * SEAT MAP COMPONENT definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatComponentType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Locations">
 *           &lt;xs:complexType>
 *             &lt;xs:sequence>
 *               &lt;xs:element name="Location" maxOccurs="unbounded">
 *                 &lt;!-- Reference to inner class Location -->
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:CodesetType" name="Type"/>
 *         &lt;xs:element name="Dimensions" minOccurs="0">
 *           &lt;!-- Reference to inner class Dimensions -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatComponentType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private List<Location> locationList = new ArrayList<Location>();
    private CodesetType type;
    private Dimensions dimensions;

    /** 
     * Get the list of 'Location' element items. Component Location information.
     * 
     * @return list
     */
    public List<Location> getLocationList() {
        return locationList;
    }

    /** 
     * Set the list of 'Location' element items. Component Location information.
     * 
     * @param list
     */
    public void setLocationList(List<Location> list) {
        locationList = list;
    }

    /** 
     * Get the 'Type' element value. Cabin component.
    Examples:
    701 (Movable compartment divider)
    702 (Convertible seats)
    AR (Air phone)
    BA (Bar)
    BK (Bulkhead)
    CL (Closet)
    G (Galley)
    LA (Lavatory)
    LG (Luggage storage)
    MV (Movie screen)
    SO (Storage space)
    ST (Stairs to upper deck)
    TA (Table)

    Encoding Scheme: IATA PADIS Code List for data element 9978 - Cabin Facilities Characteristic
     * 
     * @return value
     */
    public CodesetType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Cabin component.
    Examples:
    701 (Movable compartment divider)
    702 (Convertible seats)
    AR (Air phone)
    BA (Bar)
    BK (Bulkhead)
    CL (Closet)
    G (Galley)
    LA (Lavatory)
    LG (Luggage storage)
    MV (Movie screen)
    SO (Storage space)
    ST (Stairs to upper deck)
    TA (Table)

    Encoding Scheme: IATA PADIS Code List for data element 9978 - Cabin Facilities Characteristic
     * 
     * @param type
     */
    public void setType(CodesetType type) {
        this.type = type;
    }

    /** 
     * Get the 'Dimensions' element value.
     * 
     * @return value
     */
    public Dimensions getDimensions() {
        return dimensions;
    }

    /** 
     * Set the 'Dimensions' element value.
     * 
     * @param dimensions
     */
    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }
    /** 
     * Component location information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Location" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
     *         &lt;xs:choice>
     *           &lt;xs:element name="Space">
     *             &lt;xs:complexType>
     *               &lt;xs:sequence>
     *                 &lt;xs:element name="RowRange" maxOccurs="unbounded">
     *                   &lt;!-- Reference to inner class RowRange -->
     *                 &lt;/xs:element>
     *                 &lt;xs:element name="ColumnRange">
     *                   &lt;xs:complexType>
     *                     &lt;xs:choice maxOccurs="2">
     *                       &lt;!-- Reference to inner class ColumnRange -->
     *                     &lt;/xs:choice>
     *                   &lt;/xs:complexType>
     *                 &lt;/xs:element>
     *               &lt;/xs:sequence>
     *             &lt;/xs:complexType>
     *           &lt;/xs:element>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="Row">
     *               &lt;xs:complexType>
     *                 &lt;xs:sequence>
     *                   &lt;xs:element type="xs:string" name="Position"/>
     *                   &lt;xs:element type="ns:CodesetType" name="Orientation" minOccurs="0"/>
     *                 &lt;/xs:sequence>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element name="Column">
     *               &lt;xs:complexType>
     *                 &lt;xs:sequence>
     *                   &lt;xs:element type="xs:string" name="Position"/>
     *                   &lt;xs:element type="ns:CodesetType" name="Orientation" minOccurs="0"/>
     *                 &lt;/xs:sequence>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *         &lt;/xs:choice>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Location extends AssociatedObjectBaseType implements
        Serializable
    {
        private int choiceSelect = -1;
        private static final int SPACE_CHOICE = 0;
        private static final int ROW_CHOICE = 1;
        private List<RowRange> rowRangeList = new ArrayList<RowRange>();
        private List<ColumnRange> spaceColumnRangeList = new ArrayList<ColumnRange>();
        private String rowPosition;
        private CodesetType rowOrientation;
        private String columnPosition;
        private CodesetType columnOrientation;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if Space is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSpace() {
            return choiceSelect == SPACE_CHOICE;
        }

        /** 
         * Get the list of 'RowRange' element items. Actual space occupied by this component. 
        Example:
        GALLEY COVERS ROWS 15-17 AND COLUMNS A-C
         * 
         * @return list
         */
        public List<RowRange> getRowRangeList() {
            return rowRangeList;
        }

        /** 
         * Set the list of 'RowRange' element items. Actual space occupied by this component. 
        Example:
        GALLEY COVERS ROWS 15-17 AND COLUMNS A-C
         * 
         * @param list
         */
        public void setRowRangeList(List<RowRange> list) {
            setChoiceSelect(SPACE_CHOICE);
            rowRangeList = list;
        }

        /** 
         * Get the list of 'ColumnRange' element items. All columns covered on the map by this item.
         * 
         * @return list
         */
        public List<ColumnRange> getSpaceColumnRangeList() {
            return spaceColumnRangeList;
        }

        /** 
         * Set the list of 'ColumnRange' element items. All columns covered on the map by this item.
         * 
         * @param list
         */
        public void setSpaceColumnRangeList(List<ColumnRange> list) {
            setChoiceSelect(SPACE_CHOICE);
            spaceColumnRangeList = list;
        }

        /** 
         * Check if Row is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifRow() {
            return choiceSelect == ROW_CHOICE;
        }

        /** 
         * Get the 'Position' element value. Row number value.
        Example: 11
         * 
         * @return value
         */
        public String getRowPosition() {
            return rowPosition;
        }

        /** 
         * Set the 'Position' element value. Row number value.
        Example: 11
         * 
         * @param rowPosition
         */
        public void setRowPosition(String rowPosition) {
            setChoiceSelect(ROW_CHOICE);
            this.rowPosition = rowPosition;
        }

        /** 
         * Get the 'Orientation' element value. Icon placement (in orientation to cabin row or column).

        Examples:
        FRO (Place icon before row)
        INL (Place icon inline with row or column)
        LEF (Place icon left of column)
        REA (Place icon behind row)
        RIG (Place icon right of column)

        Encoding Scheme: IATA PADIS code list COT - Camera Orientation Type
         * 
         * @return value
         */
        public CodesetType getRowOrientation() {
            return rowOrientation;
        }

        /** 
         * Set the 'Orientation' element value. Icon placement (in orientation to cabin row or column).

        Examples:
        FRO (Place icon before row)
        INL (Place icon inline with row or column)
        LEF (Place icon left of column)
        REA (Place icon behind row)
        RIG (Place icon right of column)

        Encoding Scheme: IATA PADIS code list COT - Camera Orientation Type
         * 
         * @param rowOrientation
         */
        public void setRowOrientation(CodesetType rowOrientation) {
            setChoiceSelect(ROW_CHOICE);
            this.rowOrientation = rowOrientation;
        }

        /** 
         * Get the 'Position' element value. Column position value.
        Example: C
         * 
         * @return value
         */
        public String getColumnPosition() {
            return columnPosition;
        }

        /** 
         * Set the 'Position' element value. Column position value.
        Example: C
         * 
         * @param columnPosition
         */
        public void setColumnPosition(String columnPosition) {
            setChoiceSelect(ROW_CHOICE);
            this.columnPosition = columnPosition;
        }

        /** 
         * Get the 'Orientation' element value. Icon placement (in orientation to cabin row or column).

        Examples:
        FRO (Place icon before row)
        INL (Place icon inline with row or column)
        LEF (Place icon left of column)
        REA (Place icon behind row)
        RIG (Place icon right of column)

        Encoding Scheme: IATA PADIS code list COT - Camera Orientation Type
         * 
         * @return value
         */
        public CodesetType getColumnOrientation() {
            return columnOrientation;
        }

        /** 
         * Set the 'Orientation' element value. Icon placement (in orientation to cabin row or column).

        Examples:
        FRO (Place icon before row)
        INL (Place icon inline with row or column)
        LEF (Place icon left of column)
        REA (Place icon behind row)
        RIG (Place icon right of column)

        Encoding Scheme: IATA PADIS code list COT - Camera Orientation Type
         * 
         * @param columnOrientation
         */
        public void setColumnOrientation(CodesetType columnOrientation) {
            setChoiceSelect(ROW_CHOICE);
            this.columnOrientation = columnOrientation;
        }
        /** 
         * A range of rows covered by a non-seat cabin component for seat map information
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RowRange" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:choice maxOccurs="2">
         *       &lt;!-- Reference to inner class RowRangeInner -->
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RowRange implements Serializable
        {
            private List<RowRangeInner> rowRangeList = new ArrayList<RowRangeInner>();

            /** 
             * Get the list of 'RowRange' element items.
             * 
             * @return list
             */
            public List<RowRangeInner> getRowRangeList() {
                return rowRangeList;
            }

            /** 
             * Set the list of 'RowRange' element items.
             * 
             * @param list
             */
            public void setRowRangeList(List<RowRangeInner> list) {
                rowRangeList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
             *   &lt;xs:element type="xs:string" name="Begin"/>
             *   &lt;xs:element type="xs:string" name="End"/>
             * &lt;/xs:choice>
             * </pre>
             */
            public static class RowRangeInner implements Serializable
            {
                private int rowRangeListSelect = -1;
                private static final int BEGIN_CHOICE = 0;
                private static final int END_CHOICE = 1;
                private String begin;
                private String end;

                private void setRowRangeListSelect(int choice) {
                    if (rowRangeListSelect == -1) {
                        rowRangeListSelect = choice;
                    } else if (rowRangeListSelect != choice) {
                        throw new IllegalStateException(
                                "Need to call clearRowRangeListSelect() before changing existing choice");
                    }
                }

                /** 
                 * Clear the choice selection.
                 */
                public void clearRowRangeListSelect() {
                    rowRangeListSelect = -1;
                }

                /** 
                 * Check if Begin is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifBegin() {
                    return rowRangeListSelect == BEGIN_CHOICE;
                }

                /** 
                 * Get the 'Begin' element value. First row occupied by this item. Example: 13
                 * 
                 * @return value
                 */
                public String getBegin() {
                    return begin;
                }

                /** 
                 * Set the 'Begin' element value. First row occupied by this item. Example: 13
                 * 
                 * @param begin
                 */
                public void setBegin(String begin) {
                    setRowRangeListSelect(BEGIN_CHOICE);
                    this.begin = begin;
                }

                /** 
                 * Check if End is current selection for choice.
                 * 
                 * @return <code>true</code> if selection, <code>false</code> if not
                 */
                public boolean ifEnd() {
                    return rowRangeListSelect == END_CHOICE;
                }

                /** 
                 * Get the 'End' element value. Last row occupied by this item. Example: 17
                 * 
                 * @return value
                 */
                public String getEnd() {
                    return end;
                }

                /** 
                 * Set the 'End' element value. Last row occupied by this item. Example: 17
                 * 
                 * @param end
                 */
                public void setEnd(String end) {
                    setRowRangeListSelect(END_CHOICE);
                    this.end = end;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="2">
         *   &lt;xs:element type="xs:string" name="Begin"/>
         *   &lt;xs:element type="xs:string" name="End"/>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class ColumnRange implements Serializable
        {
            private int spaceColumnRangeListSelect = -1;
            private static final int BEGIN_CHOICE = 0;
            private static final int END_CHOICE = 1;
            private String begin;
            private String end;

            private void setSpaceColumnRangeListSelect(int choice) {
                if (spaceColumnRangeListSelect == -1) {
                    spaceColumnRangeListSelect = choice;
                } else if (spaceColumnRangeListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearSpaceColumnRangeListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearSpaceColumnRangeListSelect() {
                spaceColumnRangeListSelect = -1;
            }

            /** 
             * Check if Begin is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifBegin() {
                return spaceColumnRangeListSelect == BEGIN_CHOICE;
            }

            /** 
             * Get the 'Begin' element value. Left most column occupied by this item. Example: A
             * 
             * @return value
             */
            public String getBegin() {
                return begin;
            }

            /** 
             * Set the 'Begin' element value. Left most column occupied by this item. Example: A
             * 
             * @param begin
             */
            public void setBegin(String begin) {
                setSpaceColumnRangeListSelect(BEGIN_CHOICE);
                this.begin = begin;
            }

            /** 
             * Check if End is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifEnd() {
                return spaceColumnRangeListSelect == END_CHOICE;
            }

            /** 
             * Get the 'End' element value. Right most column occupied by this item. Example: C
             * 
             * @return value
             */
            public String getEnd() {
                return end;
            }

            /** 
             * Set the 'End' element value. Right most column occupied by this item. Example: C
             * 
             * @param end
             */
            public void setEnd(String end) {
                setSpaceColumnRangeListSelect(END_CHOICE);
                this.end = end;
            }
        }
    }
    /** 
     * Seat Dimensions.

    Note: Defines the size of this item in actual measurement units or defines how much space in relation to rows and columns the space of this item actually consumes.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Dimensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:AssociatedObjectBaseType">
     *         &lt;xs:choice>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:decimal" name="RowEquivalent"/>
     *             &lt;xs:element type="xs:decimal" name="ColumnEquivalent"/>
     *           &lt;/xs:sequence>
     *           &lt;xs:element name="ActualSize">
     *             &lt;xs:complexType>
     *               &lt;xs:sequence>
     *                 &lt;xs:element type="ns:SizeUnitSimpleType" name="UOM"/>
     *                 &lt;xs:element type="xs:string" name="Length"/>
     *                 &lt;xs:element type="xs:string" name="Width"/>
     *               &lt;/xs:sequence>
     *             &lt;/xs:complexType>
     *           &lt;/xs:element>
     *         &lt;/xs:choice>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Dimensions extends AssociatedObjectBaseType implements
        Serializable
    {
        private int choiceSelect = -1;
        private static final int ROW_EQUIVALENT_CHOICE = 0;
        private static final int ACTUAL_SIZE_CHOICE = 1;
        private BigDecimal rowEquivalent;
        private BigDecimal columnEquivalent;
        private SizeUnitSimpleType actualSizeUOM;
        private String actualSizeLength;
        private String actualSizeWidth;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if RowEquivalent is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifRowEquivalent() {
            return choiceSelect == ROW_EQUIVALENT_CHOICE;
        }

        /** 
         * Get the 'RowEquivalent' element value. Length in number of ROWS value. Example: 2.5
         * 
         * @return value
         */
        public BigDecimal getRowEquivalent() {
            return rowEquivalent;
        }

        /** 
         * Set the 'RowEquivalent' element value. Length in number of ROWS value. Example: 2.5
         * 
         * @param rowEquivalent
         */
        public void setRowEquivalent(BigDecimal rowEquivalent) {
            setChoiceSelect(ROW_EQUIVALENT_CHOICE);
            this.rowEquivalent = rowEquivalent;
        }

        /** 
         * Get the 'ColumnEquivalent' element value. Width in number of COLUMNS value. Example: 2.5
         * 
         * @return value
         */
        public BigDecimal getColumnEquivalent() {
            return columnEquivalent;
        }

        /** 
         * Set the 'ColumnEquivalent' element value. Width in number of COLUMNS value. Example: 2.5
         * 
         * @param columnEquivalent
         */
        public void setColumnEquivalent(BigDecimal columnEquivalent) {
            setChoiceSelect(ROW_EQUIVALENT_CHOICE);
            this.columnEquivalent = columnEquivalent;
        }

        /** 
         * Check if ActualSize is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifActualSize() {
            return choiceSelect == ACTUAL_SIZE_CHOICE;
        }

        /** 
         * Get the 'UOM' element value. First row number.
        Example: 15
         * 
         * @return value
         */
        public SizeUnitSimpleType getActualSizeUOM() {
            return actualSizeUOM;
        }

        /** 
         * Set the 'UOM' element value. First row number.
        Example: 15
         * 
         * @param actualSizeUOM
         */
        public void setActualSizeUOM(SizeUnitSimpleType actualSizeUOM) {
            setChoiceSelect(ACTUAL_SIZE_CHOICE);
            this.actualSizeUOM = actualSizeUOM;
        }

        /** 
         * Get the 'Length' element value. Front to back LENGTH measurement value. Example: 70
         * 
         * @return value
         */
        public String getActualSizeLength() {
            return actualSizeLength;
        }

        /** 
         * Set the 'Length' element value. Front to back LENGTH measurement value. Example: 70
         * 
         * @param actualSizeLength
         */
        public void setActualSizeLength(String actualSizeLength) {
            setChoiceSelect(ACTUAL_SIZE_CHOICE);
            this.actualSizeLength = actualSizeLength;
        }

        /** 
         * Get the 'Width' element value. Front to back WIDTH measurement value. Example: 70
         * 
         * @return value
         */
        public String getActualSizeWidth() {
            return actualSizeWidth;
        }

        /** 
         * Set the 'Width' element value. Front to back WIDTH measurement value. Example: 70
         * 
         * @param actualSizeWidth
         */
        public void setActualSizeWidth(String actualSizeWidth) {
            setChoiceSelect(ACTUAL_SIZE_CHOICE);
            this.actualSizeWidth = actualSizeWidth;
        }
    }
}
