
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A SEAT OFFER with additional Seat Characteristics information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatItemType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:DetailCurrencyPriceType" name="Price" minOccurs="0"/>
 *         &lt;xs:element type="ns:Descriptions" name="Descriptions" minOccurs="0"/>
 *         &lt;xs:element type="ns:SeatCharacteristicType" name="SeatDetail" minOccurs="0"/>
 *         &lt;xs:choice>
 *           &lt;xs:element type="ns:SeatLocationType" name="Location" minOccurs="0"/>
 *           &lt;xs:element ref="ns:SeatReference" maxOccurs="unbounded"/>
 *         &lt;/xs:choice>
 *         &lt;xs:element ref="ns:SeatAssociation" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatItemType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private DetailCurrencyPriceType price;
    private Descriptions descriptions;
    private SeatCharacteristicType seatDetail;
    private int choiceSelect = -1;
    private static final int LOCATION_CHOICE = 0;
    private static final int SEAT_REFERENCE_LIST_CHOICE = 1;
    private SeatLocationType location;
    private List<SeatReference> seatReferenceList = new ArrayList<SeatReference>();
    private List<SeatAssociation> seatAssociationList = new ArrayList<SeatAssociation>();

    /** 
     * Get the 'Price' element value. Price
     * 
     * @return value
     */
    public DetailCurrencyPriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. Price
     * 
     * @param price
     */
    public void setPrice(DetailCurrencyPriceType price) {
        this.price = price;
    }

    /** 
     * Get the 'Descriptions' element value. Seat Description.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value. Seat Description.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'SeatDetail' element value. Seat Detail, including Marketing Name, Features, Size and Keywords.
     * 
     * @return value
     */
    public SeatCharacteristicType getSeatDetail() {
        return seatDetail;
    }

    /** 
     * Set the 'SeatDetail' element value. Seat Detail, including Marketing Name, Features, Size and Keywords.
     * 
     * @param seatDetail
     */
    public void setSeatDetail(SeatCharacteristicType seatDetail) {
        this.seatDetail = seatDetail;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Location is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLocation() {
        return choiceSelect == LOCATION_CHOICE;
    }

    /** 
     * Get the 'Location' element value. Seat Location information.
     * 
     * @return value
     */
    public SeatLocationType getLocation() {
        return location;
    }

    /** 
     * Set the 'Location' element value. Seat Location information.
     * 
     * @param location
     */
    public void setLocation(SeatLocationType location) {
        setChoiceSelect(LOCATION_CHOICE);
        this.location = location;
    }

    /** 
     * Check if SeatReferenceList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSeatReferenceList() {
        return choiceSelect == SEAT_REFERENCE_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SeatReference' element items.
     * 
     * @return list
     */
    public List<SeatReference> getSeatReferenceList() {
        return seatReferenceList;
    }

    /** 
     * Set the list of 'SeatReference' element items.
     * 
     * @param list
     */
    public void setSeatReferenceList(List<SeatReference> list) {
        setChoiceSelect(SEAT_REFERENCE_LIST_CHOICE);
        seatReferenceList = list;
    }

    /** 
     * Get the list of 'SeatAssociation' element items.
     * 
     * @return list
     */
    public List<SeatAssociation> getSeatAssociationList() {
        return seatAssociationList;
    }

    /** 
     * Set the list of 'SeatAssociation' element items.
     * 
     * @param list
     */
    public void setSeatAssociationList(List<SeatAssociation> list) {
        seatAssociationList = list;
    }
}
