
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * SEAT MAP COMPONENT MEDIA and MESSAGE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatMapMessageType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:KeyWithMetaObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Images" minOccurs="0" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Images -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Links" minOccurs="0" maxOccurs="unbounded">
 *           &lt;!-- Reference to inner class Links -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatMapMessageType extends KeyWithMetaObjectBaseType implements
    Serializable
{
    private List<Images> imageList = new ArrayList<Images>();
    private List<Links> linkList = new ArrayList<Links>();
    private Remarks remarks;

    /** 
     * Get the list of 'Images' element items.
     * 
     * @return list
     */
    public List<Images> getImageList() {
        return imageList;
    }

    /** 
     * Set the list of 'Images' element items.
     * 
     * @param list
     */
    public void setImageList(List<Images> list) {
        imageList = list;
    }

    /** 
     * Get the list of 'Links' element items.
     * 
     * @return list
     */
    public List<Links> getLinkList() {
        return linkList;
    }

    /** 
     * Set the list of 'Links' element items.
     * 
     * @param list
     */
    public void setLinkList(List<Links> list) {
        linkList = list;
    }

    /** 
     * Get the 'Remarks' element value. Marketing message for all seats in this section.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value. Marketing message for all seats in this section.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }
    /** 
     * Images applicable to this section
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Images" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="ImageID"/>
     *       &lt;xs:element type="ns:CabinCameraPosType" name="Position" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Images implements Serializable
    {
        private String imageID;
        private CabinCameraPosType position;

        /** 
         * Get the 'ImageID' element value. Image ID defined in root node MediaContent.
        Examples:
        IMG713
        SFO_LOUNGE
         * 
         * @return value
         */
        public String getImageID() {
            return imageID;
        }

        /** 
         * Set the 'ImageID' element value. Image ID defined in root node MediaContent.
        Examples:
        IMG713
        SFO_LOUNGE
         * 
         * @param imageID
         */
        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        /** 
         * Get the 'Position' element value. Camera position on seat map information.=notes=
        1. This is the desired position where camera icon or equivalent needs to be positioned on a seat map.
         * 
         * @return value
         */
        public CabinCameraPosType getPosition() {
            return position;
        }

        /** 
         * Set the 'Position' element value. Camera position on seat map information.=notes=
        1. This is the desired position where camera icon or equivalent needs to be positioned on a seat map.
         * 
         * @param position
         */
        public void setPosition(CabinCameraPosType position) {
            this.position = position;
        }
    }
    /** 
     * Links applicable to this section
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Links" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:MediaLink"/>
     *       &lt;xs:element type="ns:CabinCameraPosType" name="Position" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Links implements Serializable
    {
        private MediaLink mediaLink;
        private CabinCameraPosType position;

        /** 
         * Get the 'MediaLink' element value.
         * 
         * @return value
         */
        public MediaLink getMediaLink() {
            return mediaLink;
        }

        /** 
         * Set the 'MediaLink' element value.
         * 
         * @param mediaLink
         */
        public void setMediaLink(MediaLink mediaLink) {
            this.mediaLink = mediaLink;
        }

        /** 
         * Get the 'Position' element value. Camera position on seat map information.=notes=
        1. This is the desired position where camera icon or equivalent needs to be positioned on a seat map.
         * 
         * @return value
         */
        public CabinCameraPosType getPosition() {
            return position;
        }

        /** 
         * Set the 'Position' element value. Camera position on seat map information.=notes=
        1. This is the desired position where camera icon or equivalent needs to be positioned on a seat map.
         * 
         * @param position
         */
        public void setPosition(CabinCameraPosType position) {
            this.position = position;
        }
    }
}
