
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * Aircraft seat row with seat map ghost row metadata definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatMapRowNbrType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="RowSuffix"/>
 *       &lt;xs:attribute use="optional" name="RowPos">
 *         &lt;xs:simpleType>
 *           &lt;!-- Reference to inner class RowPos -->
 *         &lt;/xs:simpleType>
 *       &lt;/xs:attribute>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatMapRowNbrType implements Serializable
{
    private String string;
    private String rowSuffix;
    private RowPos rowPos;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'RowSuffix' attribute value. Ghost row suffix.
    Example: A

    Notes: A "Ghost" row may be used to identify non-seat rows that contain components, such as lavatory and galley, by their seat characteristics.
     * 
     * @return value
     */
    public String getRowSuffix() {
        return rowSuffix;
    }

    /** 
     * Set the 'RowSuffix' attribute value. Ghost row suffix.
    Example: A

    Notes: A "Ghost" row may be used to identify non-seat rows that contain components, such as lavatory and galley, by their seat characteristics.
     * 
     * @param rowSuffix
     */
    public void setRowSuffix(String rowSuffix) {
        this.rowSuffix = rowSuffix;
    }

    /** 
     * Get the 'RowPos' attribute value. Ghost row position.
    Examples:
    BACK
    FRONT

    Notes: Identifies if the Ghost row is in front of or behind the referenced true row.
    Example: If there is a lavatory, taking the equivalent space of 2 rows in front of row number 1, the values for the 2 ghost rows needed would be:
    Row="1"+ RowSuffix="A" and Row="1" + RowSuffix="B".
    The RowPos value would be "FRONT" (in front).
     * 
     * @return value
     */
    public RowPos getRowPos() {
        return rowPos;
    }

    /** 
     * Set the 'RowPos' attribute value. Ghost row position.
    Examples:
    BACK
    FRONT

    Notes: Identifies if the Ghost row is in front of or behind the referenced true row.
    Example: If there is a lavatory, taking the equivalent space of 2 rows in front of row number 1, the values for the 2 ghost rows needed would be:
    Row="1"+ RowSuffix="A" and Row="1" + RowSuffix="B".
    The RowPos value would be "FRONT" (in front).
     * 
     * @param rowPos
     */
    public void setRowPos(RowPos rowPos) {
        this.rowPos = rowPos;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="BACK"/>
     *     &lt;xs:enumeration value="FRONT"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum RowPos implements Serializable {
        BACK, FRONT
    }
}
