
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel050;

import java.io.Serializable;

/** 
 * SEAT Metadata definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CodesetType" name="SeatStatus" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private CodesetType seatStatus;

    /** 
     * Get the 'SeatStatus' element value. Seat status.
    Examples:
    SA (Seats are available)
    WO (Seats waitlist open for segment)
    WC (Seats waitlist closed for segment)
    OR (Seats on request only to airline)

    Encoding Scheme: IATA PADIS Code List for data element 9865 - Seat Occupation
     * 
     * @return value
     */
    public CodesetType getSeatStatus() {
        return seatStatus;
    }

    /** 
     * Set the 'SeatStatus' element value. Seat status.
    Examples:
    SA (Seats are available)
    WO (Seats waitlist open for segment)
    WC (Seats waitlist closed for segment)
    OR (Seats on request only to airline)

    Encoding Scheme: IATA PADIS Code List for data element 9865 - Seat Occupation
     * 
     * @param seatStatus
     */
    public void setSeatStatus(CodesetType seatStatus) {
        this.seatStatus = seatStatus;
    }
}
